/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.MovimientoCajaRequest;
import com.sistema.turistico.dto.VentaAnulacionRequest;
import com.sistema.turistico.dto.VentaRequest;
import com.sistema.turistico.dto.VentaResponse;
import com.sistema.turistico.entity.Caja;
import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.entity.MovimientoCaja;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.Usuario;
import com.sistema.turistico.entity.Venta;
import com.sistema.turistico.entity.Voucher;
import com.sistema.turistico.repository.PagoReservaRepository;
import com.sistema.turistico.repository.VentaRepository;
import com.sistema.turistico.repository.VoucherRepository;
import com.sistema.turistico.service.CajaService;
import com.sistema.turistico.service.ReservaService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class VentaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VentaService.class);
    private static final Set<String> METODOS_VALIDOS = Set.of("Efectivo", "Tarjeta Cr\u00e9dito", "Tarjeta D\u00e9bito", "Transferencia", "Yape/Plin", "Otros");
    private final VentaRepository ventaRepository;
    private final VoucherRepository voucherRepository;
    private final PagoReservaRepository pagoReservaRepository;
    private final ReservaService reservaService;
    private final CajaService cajaService;
    @PersistenceContext
    private EntityManager entityManager;

    public VentaResponse emitirVenta(VentaRequest request) {
        log.info("Emitiendo venta para reserva {}", (Object)request.getReservaId());
        this.validarMetodoPago(request.getMetodoPago());
        Reserva reserva = (Reserva)this.reservaService.findById(request.getReservaId()).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        Caja caja = this.cajaService.obtenerCajaActiva(request.getCajaId());
        if (!reserva.getEmpresa().getIdEmpresa().equals(caja.getEmpresa().getIdEmpresa())) {
            throw new IllegalArgumentException("La caja seleccionada no pertenece a la empresa de la reserva");
        }
        BigDecimal totalReserva = reserva.getPrecioFinal();
        BigDecimal totalPagado = this.pagoReservaRepository.sumMontosActivosPorReserva(reserva.getIdReserva());
        if (totalPagado.compareTo(totalReserva) < 0) {
            throw new IllegalStateException("La reserva a\u00fan presenta saldo pendiente");
        }
        BigDecimal descuento = request.getDescuento() != null ? request.getDescuento() : BigDecimal.ZERO;
        BigDecimal propina = request.getPropina() != null ? request.getPropina() : BigDecimal.ZERO;
        BigDecimal montoFinal = totalReserva.subtract(descuento).add(propina);
        if (montoFinal.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("El monto final de la venta debe ser mayor a 0");
        }
        Venta venta = new Venta();
        venta.setEmpresa(reserva.getEmpresa());
        venta.setCliente(this.obtenerClienteVenta(request, reserva));
        venta.setReserva(reserva);
        venta.setUsuario((Usuario)this.entityManager.getReference(Usuario.class, (Object)request.getUsuarioId()));
        venta.setCaja(caja);
        venta.setFechaHora(LocalDateTime.now());
        venta.setMontoTotal(montoFinal);
        venta.setMetodoPago(this.normalizarMetodoPago(request.getMetodoPago()));
        venta.setNumeroOperacion(request.getNumeroOperacion());
        venta.setComprobante(request.getComprobante());
        venta.setDescuento(descuento);
        venta.setPropina(propina);
        venta.setObservaciones(request.getObservaciones());
        venta.setEstado(Boolean.TRUE);
        Venta ventaGuardada = (Venta)this.ventaRepository.save((Object)venta);
        this.generarOVincularVoucher(reserva);
        this.reservaService.actualizarEstadoFinanciero(reserva, Reserva.EstadoReserva.Pagada);
        log.info("Venta {} emitida correctamente", (Object)ventaGuardada.getIdVenta());
        return this.convertirAVentaResponse(ventaGuardada);
    }

    @Transactional(readOnly=true)
    public VentaResponse obtenerVenta(Long ventaId) {
        Venta venta = this.obtenerVentaInterna(ventaId);
        return this.convertirAVentaResponse(venta);
    }

    @Transactional(readOnly=true)
    private Venta obtenerVentaInterna(Long ventaId) {
        return (Venta)this.ventaRepository.findById((Object)ventaId).orElseThrow(() -> new IllegalArgumentException("Venta no encontrada"));
    }

    @Transactional(readOnly=true)
    public List<VentaResponse> listarVentas(Long empresaId, LocalDateTime inicio, LocalDateTime fin, String metodoPago, Boolean estado) {
        String metodoNormalizado;
        String string = metodoNormalizado = metodoPago != null ? this.normalizarMetodoPago(metodoPago) : null;
        if (metodoNormalizado != null) {
            this.validarMetodoPago(metodoNormalizado);
        }
        List ventas = this.ventaRepository.findByFiltros(empresaId, inicio, fin, metodoNormalizado, estado);
        return ventas.stream().map(arg_0 -> this.convertirAVentaResponse(arg_0)).toList();
    }

    public VentaResponse anularVenta(Long ventaId, VentaAnulacionRequest request) {
        log.info("Anulando venta {}", (Object)ventaId);
        Venta venta = this.obtenerVentaInterna(ventaId);
        if (Boolean.FALSE.equals(venta.getEstado())) {
            throw new IllegalStateException("La venta ya se encuentra anulada");
        }
        Caja cajaActiva = this.cajaService.obtenerCajaActiva(request.getCajaId());
        if (!venta.getCaja().getIdCaja().equals(cajaActiva.getIdCaja())) {
            throw new IllegalArgumentException("La anulaci\u00f3n debe realizarse en la misma caja donde se registr\u00f3 la venta");
        }
        venta.setEstado(Boolean.FALSE);
        String motivo = request.getMotivo();
        if (motivo != null && !motivo.isBlank()) {
            String observaciones = venta.getObservaciones();
            String nuevaObs = "Anulada: " + motivo + " (" + String.valueOf(LocalDateTime.now()) + ")";
            venta.setObservaciones(observaciones == null ? nuevaObs : observaciones + " | " + nuevaObs);
        }
        Venta ventaAnulada = (Venta)this.ventaRepository.save((Object)venta);
        MovimientoCajaRequest movimientoRequest = new MovimientoCajaRequest();
        movimientoRequest.setTipoMovimiento(MovimientoCaja.TipoMovimiento.Egreso);
        movimientoRequest.setMonto(ventaAnulada.getMontoTotal());
        movimientoRequest.setDescripcion("Reverso venta reserva " + String.valueOf(venta.getReserva() != null ? venta.getReserva().getCodigoReserva() : venta.getIdVenta()));
        movimientoRequest.setVentaId(ventaAnulada.getIdVenta());
        this.cajaService.registrarMovimiento(cajaActiva.getIdCaja(), movimientoRequest);
        if (venta.getReserva() != null) {
            BigDecimal totalPagado = this.pagoReservaRepository.sumMontosActivosPorReserva(venta.getReserva().getIdReserva());
            Reserva.EstadoReserva estado = totalPagado.compareTo(venta.getReserva().getPrecioFinal()) >= 0 ? Reserva.EstadoReserva.Pagada : (totalPagado.compareTo(BigDecimal.ZERO) > 0 ? Reserva.EstadoReserva.PagoParcial : Reserva.EstadoReserva.Confirmada);
            this.reservaService.actualizarEstadoFinanciero(venta.getReserva(), estado);
        }
        this.voucherRepository.findByReserva_IdReserva(venta.getReserva() != null ? venta.getReserva().getIdReserva() : null).ifPresent(voucher -> {
            voucher.setEstado(Voucher.EstadoVoucher.Cancelado);
            this.voucherRepository.save(voucher);
        });
        return this.convertirAVentaResponse(ventaAnulada);
    }

    public VentaResponse actualizarVenta(Long ventaId, VentaRequest request) {
        log.info("Actualizando venta {}", (Object)ventaId);
        Venta venta = this.obtenerVentaInterna(ventaId);
        if (Boolean.FALSE.equals(venta.getEstado())) {
            throw new IllegalStateException("No se puede actualizar una venta anulada");
        }
        if (request.getMetodoPago() != null) {
            this.validarMetodoPago(request.getMetodoPago());
            venta.setMetodoPago(this.normalizarMetodoPago(request.getMetodoPago()));
        }
        if (request.getNumeroOperacion() != null) {
            venta.setNumeroOperacion(request.getNumeroOperacion());
        }
        if (request.getComprobante() != null) {
            venta.setComprobante(request.getComprobante());
        }
        if (request.getObservaciones() != null) {
            venta.setObservaciones(request.getObservaciones());
        }
        if (request.getDescuento() != null) {
            venta.setDescuento(request.getDescuento());
        }
        if (request.getPropina() != null) {
            venta.setPropina(request.getPropina());
        }
        if (request.getClienteId() != null) {
            venta.setCliente((Cliente)this.entityManager.getReference(Cliente.class, (Object)request.getClienteId()));
        }
        if (request.getDescuento() != null || request.getPropina() != null) {
            BigDecimal descuento = request.getDescuento() != null ? request.getDescuento() : venta.getDescuento();
            BigDecimal propina = request.getPropina() != null ? request.getPropina() : venta.getPropina();
            BigDecimal precioBase = venta.getReserva() != null ? venta.getReserva().getPrecioFinal() : venta.getMontoTotal();
            BigDecimal montoFinal = precioBase.subtract(descuento).add(propina);
            if (montoFinal.compareTo(BigDecimal.ZERO) <= 0) {
                throw new IllegalArgumentException("El monto final de la venta debe ser mayor a 0");
            }
            venta.setMontoTotal(montoFinal);
        }
        return this.convertirAVentaResponse((Venta)this.ventaRepository.save((Object)venta));
    }

    public VentaResponse eliminarVenta(Long ventaId, Long cajaId, String motivo) {
        log.info("Eliminando venta {}", (Object)ventaId);
        Venta venta = this.obtenerVentaInterna(ventaId);
        if (Boolean.FALSE.equals(venta.getEstado())) {
            throw new IllegalStateException("La venta ya se encuentra eliminada");
        }
        LocalDate hoy = LocalDate.now();
        if (!venta.getFechaHora().toLocalDate().equals(hoy)) {
            throw new IllegalArgumentException("Solo se pueden eliminar ventas del d\u00eda actual");
        }
        Caja cajaActiva = this.cajaService.obtenerCajaActiva(cajaId);
        if (!venta.getCaja().getIdCaja().equals(cajaActiva.getIdCaja())) {
            throw new IllegalArgumentException("La eliminaci\u00f3n debe realizarse en la misma caja donde se registr\u00f3 la venta");
        }
        venta.setEstado(Boolean.FALSE);
        if (motivo != null && !motivo.isBlank()) {
            String observaciones = venta.getObservaciones();
            String nuevaObs = "Eliminada: " + motivo + " (" + String.valueOf(LocalDateTime.now()) + ")";
            venta.setObservaciones(observaciones == null ? nuevaObs : observaciones + " | " + nuevaObs);
        }
        Venta ventaEliminada = (Venta)this.ventaRepository.save((Object)venta);
        MovimientoCajaRequest movimientoRequest = new MovimientoCajaRequest();
        movimientoRequest.setTipoMovimiento(MovimientoCaja.TipoMovimiento.Egreso);
        movimientoRequest.setMonto(ventaEliminada.getMontoTotal());
        movimientoRequest.setDescripcion("Reverso eliminaci\u00f3n venta reserva " + String.valueOf(venta.getReserva() != null ? venta.getReserva().getCodigoReserva() : venta.getIdVenta()));
        movimientoRequest.setVentaId(ventaEliminada.getIdVenta());
        this.cajaService.registrarMovimiento(cajaActiva.getIdCaja(), movimientoRequest);
        if (venta.getReserva() != null) {
            BigDecimal totalPagado = this.pagoReservaRepository.sumMontosActivosPorReserva(venta.getReserva().getIdReserva());
            Reserva.EstadoReserva estado = totalPagado.compareTo(venta.getReserva().getPrecioFinal()) >= 0 ? Reserva.EstadoReserva.Pagada : (totalPagado.compareTo(BigDecimal.ZERO) > 0 ? Reserva.EstadoReserva.PagoParcial : Reserva.EstadoReserva.Confirmada);
            this.reservaService.actualizarEstadoFinanciero(venta.getReserva(), estado);
        }
        this.voucherRepository.findByReserva_IdReserva(venta.getReserva() != null ? venta.getReserva().getIdReserva() : null).ifPresent(voucher -> {
            voucher.setEstado(Voucher.EstadoVoucher.Cancelado);
            this.voucherRepository.save(voucher);
        });
        return this.convertirAVentaResponse(ventaEliminada);
    }

    @Transactional(readOnly=true)
    public Map<String, String> obtenerProximaNumeracion(Long empresaId) {
        LocalDate hoy = LocalDate.now();
        LocalDateTime inicio = hoy.atStartOfDay();
        LocalDateTime fin = hoy.atTime(LocalTime.MAX);
        long cantidadHoy = this.ventaRepository.findByFiltros(empresaId, inicio, fin, null, Boolean.TRUE).size();
        String numero = String.format("%s-%04d", hoy.toString().replace("-", ""), cantidadHoy + 1L);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("siguienteNumero", numero);
        return response;
    }

    private Cliente obtenerClienteVenta(VentaRequest request, Reserva reserva) {
        if (request.getClienteId() != null) {
            return (Cliente)this.entityManager.getReference(Cliente.class, (Object)request.getClienteId());
        }
        return reserva.getCliente();
    }

    private void generarOVincularVoucher(Reserva reserva) {
        Voucher voucher = this.voucherRepository.findByReserva_IdReserva(reserva.getIdReserva()).orElseGet(Voucher::new);
        voucher.setReserva(reserva);
        voucher.setFechaEmision(LocalDate.now());
        voucher.setFechaExpiracion(reserva.getFechaServicio().toLocalDate());
        voucher.setEstado(Voucher.EstadoVoucher.Emitido);
        if (voucher.getCodigoQr() == null || voucher.getCodigoQr().isBlank()) {
            voucher.setCodigoQr(UUID.randomUUID().toString());
        }
        this.voucherRepository.save((Object)voucher);
    }

    private void validarMetodoPago(String metodo) {
        if (metodo == null || metodo.trim().isEmpty()) {
            throw new IllegalArgumentException("El m\u00e9todo de pago es obligatorio");
        }
        String metodoNormalizado = this.normalizarMetodoPago(metodo);
        if (!METODOS_VALIDOS.contains(metodoNormalizado)) {
            throw new IllegalArgumentException("M\u00e9todo de pago no soportado: " + metodo + ". M\u00e9todos v\u00e1lidos: " + String.valueOf(METODOS_VALIDOS));
        }
    }

    private String normalizarMetodoPago(String metodoPago) {
        if (metodoPago == null) {
            return null;
        }
        String trimmed = metodoPago.trim();
        if (trimmed.length() > 1) {
            return trimmed.substring(0, 1).toUpperCase() + trimmed.substring(1).toLowerCase();
        }
        return trimmed.toUpperCase();
    }

    private VentaResponse convertirAVentaResponse(Venta venta) {
        VentaResponse response = new VentaResponse();
        response.setIdVenta(venta.getIdVenta());
        response.setEmpresaId(venta.getEmpresa() != null ? venta.getEmpresa().getIdEmpresa() : null);
        response.setClienteId(venta.getCliente() != null ? venta.getCliente().getIdCliente() : null);
        response.setReservaId(venta.getReserva() != null ? venta.getReserva().getIdReserva() : null);
        response.setUsuarioId(venta.getUsuario() != null ? venta.getUsuario().getIdUsuario() : null);
        response.setCajaId(venta.getCaja() != null ? venta.getCaja().getIdCaja() : null);
        response.setFechaHora(venta.getFechaHora());
        response.setMontoTotal(venta.getMontoTotal());
        response.setMetodoPago(venta.getMetodoPago());
        response.setNumeroOperacion(venta.getNumeroOperacion());
        response.setComprobante(venta.getComprobante());
        response.setDescuento(venta.getDescuento());
        response.setPropina(venta.getPropina());
        response.setObservaciones(venta.getObservaciones());
        response.setEstado(venta.getEstado());
        response.setCreatedAt(venta.getCreatedAt());
        response.setUpdatedAt(venta.getUpdatedAt());
        return response;
    }

    @Generated
    public VentaService(VentaRepository ventaRepository, VoucherRepository voucherRepository, PagoReservaRepository pagoReservaRepository, ReservaService reservaService, CajaService cajaService) {
        this.ventaRepository = ventaRepository;
        this.voucherRepository = voucherRepository;
        this.pagoReservaRepository = pagoReservaRepository;
        this.reservaService = reservaService;
        this.cajaService = cajaService;
    }
}

