/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Permiso;
import com.sistema.turistico.entity.Usuario;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Set;
import lombok.Generated;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="roles")
@EntityListeners(value={AuditingEntityListener.class})
public class Rol {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_rol")
    private Long idRol;
    @NotBlank(message="El nombre del rol es obligatorio")
    @Size(max=100, message="El nombre del rol no puede exceder 100 caracteres")
    @Column(name="nombre_rol", nullable=false, unique=true, length=100)
    private @NotBlank(message="El nombre del rol es obligatorio") @Size(max=100, message="El nombre del rol no puede exceder 100 caracteres") String nombreRol;
    @Size(max=500, message="La descripci\u00f3n no puede exceder 500 caracteres")
    @Column(name="descripcion", columnDefinition="TEXT")
    private @Size(max=500, message="La descripci\u00f3n no puede exceder 500 caracteres") String descripcion;
    @Column(name="estado", nullable=false)
    private Integer estado = 1;
    @CreatedDate
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @LastModifiedDate
    @Column(name="updated_at", nullable=false)
    private LocalDateTime updatedAt;
    @Column(name="deleted_at")
    private LocalDateTime deletedAt;
    @OneToMany(mappedBy="rol", fetch=FetchType.LAZY)
    private Set<Usuario> usuarios;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="roles_permisos", joinColumns={@JoinColumn(name="id_rol")}, inverseJoinColumns={@JoinColumn(name="id_permiso")})
    private Set<Permiso> permisos;

    @Generated
    public Long getIdRol() {
        return this.idRol;
    }

    @Generated
    public String getNombreRol() {
        return this.nombreRol;
    }

    @Generated
    public String getDescripcion() {
        return this.descripcion;
    }

    @Generated
    public Integer getEstado() {
        return this.estado;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public LocalDateTime getDeletedAt() {
        return this.deletedAt;
    }

    @Generated
    public Set<Usuario> getUsuarios() {
        return this.usuarios;
    }

    @Generated
    public Set<Permiso> getPermisos() {
        return this.permisos;
    }

    @Generated
    public void setIdRol(Long idRol) {
        this.idRol = idRol;
    }

    @Generated
    public void setNombreRol(String nombreRol) {
        this.nombreRol = nombreRol;
    }

    @Generated
    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    @Generated
    public void setEstado(Integer estado) {
        this.estado = estado;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setDeletedAt(LocalDateTime deletedAt) {
        this.deletedAt = deletedAt;
    }

    @Generated
    public void setUsuarios(Set<Usuario> usuarios) {
        this.usuarios = usuarios;
    }

    @Generated
    public void setPermisos(Set<Permiso> permisos) {
        this.permisos = permisos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rol)) {
            return false;
        }
        Rol other = (Rol)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idRol = this.getIdRol();
        Long other$idRol = other.getIdRol();
        if (this$idRol == null ? other$idRol != null : !((Object)this$idRol).equals(other$idRol)) {
            return false;
        }
        Integer this$estado = this.getEstado();
        Integer other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        String this$nombreRol = this.getNombreRol();
        String other$nombreRol = other.getNombreRol();
        if (this$nombreRol == null ? other$nombreRol != null : !this$nombreRol.equals(other$nombreRol)) {
            return false;
        }
        String this$descripcion = this.getDescripcion();
        String other$descripcion = other.getDescripcion();
        if (this$descripcion == null ? other$descripcion != null : !this$descripcion.equals(other$descripcion)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        LocalDateTime this$deletedAt = this.getDeletedAt();
        LocalDateTime other$deletedAt = other.getDeletedAt();
        if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
            return false;
        }
        Set this$usuarios = this.getUsuarios();
        Set other$usuarios = other.getUsuarios();
        if (this$usuarios == null ? other$usuarios != null : !((Object)this$usuarios).equals(other$usuarios)) {
            return false;
        }
        Set this$permisos = this.getPermisos();
        Set other$permisos = other.getPermisos();
        return !(this$permisos == null ? other$permisos != null : !((Object)this$permisos).equals(other$permisos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Rol;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idRol = this.getIdRol();
        result = result * 59 + ($idRol == null ? 43 : ((Object)$idRol).hashCode());
        Integer $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        String $nombreRol = this.getNombreRol();
        result = result * 59 + ($nombreRol == null ? 43 : $nombreRol.hashCode());
        String $descripcion = this.getDescripcion();
        result = result * 59 + ($descripcion == null ? 43 : $descripcion.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        LocalDateTime $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        Set $usuarios = this.getUsuarios();
        result = result * 59 + ($usuarios == null ? 43 : ((Object)$usuarios).hashCode());
        Set $permisos = this.getPermisos();
        result = result * 59 + ($permisos == null ? 43 : ((Object)$permisos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Rol(idRol=" + String.valueOf(this.getIdRol()) + ", nombreRol=" + this.getNombreRol() + ", descripcion=" + this.getDescripcion() + ", estado=" + String.valueOf(this.getEstado()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ", usuarios=" + String.valueOf(this.getUsuarios()) + ", permisos=" + String.valueOf(this.getPermisos()) + ")";
    }

    @Generated
    public Rol() {
    }

    @Generated
    public Rol(Long idRol, String nombreRol, String descripcion, Integer estado, LocalDateTime createdAt, LocalDateTime updatedAt, LocalDateTime deletedAt, Set<Usuario> usuarios, Set<Permiso> permisos) {
        this.idRol = idRol;
        this.nombreRol = nombreRol;
        this.descripcion = descripcion;
        this.estado = estado;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.deletedAt = deletedAt;
        this.usuarios = usuarios;
        this.permisos = permisos;
    }
}

