/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.AsignacionPersonalRequest;
import com.sistema.turistico.dto.AsignacionPersonalUpdateRequest;
import com.sistema.turistico.entity.AsignacionPersonal;
import com.sistema.turistico.entity.Personal;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.repository.AsignacionPersonalRepository;
import com.sistema.turistico.repository.PersonalRepository;
import com.sistema.turistico.repository.ReservaRepository;
import java.sql.Date;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AsignacionPersonalService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsignacionPersonalService.class);
    private final AsignacionPersonalRepository asignacionRepository;
    private final PersonalRepository personalRepository;
    private final ReservaRepository reservaRepository;

    @Transactional
    public AsignacionPersonal create(AsignacionPersonalRequest request) {
        Date fechaAsignacion;
        log.info("Creando asignaci\u00f3n de personal: {} para reserva {}", (Object)request.getIdPersonal(), (Object)request.getIdReserva());
        Personal personal = (Personal)this.personalRepository.findById((Object)request.getIdPersonal()).orElseThrow(() -> new IllegalArgumentException("Personal no encontrado"));
        if (!personal.isActivo()) {
            throw new IllegalArgumentException("El personal no est\u00e1 activo");
        }
        Reserva reserva = (Reserva)this.reservaRepository.findById((Object)request.getIdReserva()).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        Date date = fechaAsignacion = request.getFechaAsignacion() != null ? request.getFechaAsignacion() : reserva.getFechaServicio();
        if (this.asignacionRepository.existsByPersonalAndFecha(request.getIdPersonal(), fechaAsignacion)) {
            throw new IllegalArgumentException("El personal ya est\u00e1 asignado en esta fecha");
        }
        if (!fechaAsignacion.equals(reserva.getFechaServicio())) {
            throw new IllegalArgumentException("La fecha de asignaci\u00f3n debe coincidir con la fecha del servicio");
        }
        AsignacionPersonal asignacion = new AsignacionPersonal(personal, reserva, fechaAsignacion);
        asignacion.setObservaciones(request.getObservaciones());
        asignacion.setEstado(AsignacionPersonal.EstadoAsignacion.Asignado);
        return (AsignacionPersonal)this.asignacionRepository.save((Object)asignacion);
    }

    @Transactional
    public AsignacionPersonal create(AsignacionPersonal asignacion) {
        log.info("Creando asignaci\u00f3n de personal: {} para reserva {}", (Object)asignacion.getPersonal().getIdPersonal(), (Object)asignacion.getReserva().getIdReserva());
        Personal personal = (Personal)this.personalRepository.findById((Object)asignacion.getPersonal().getIdPersonal()).orElseThrow(() -> new IllegalArgumentException("Personal no encontrado"));
        if (!personal.isActivo()) {
            throw new IllegalArgumentException("El personal no est\u00e1 activo");
        }
        Reserva reserva = (Reserva)this.reservaRepository.findById((Object)asignacion.getReserva().getIdReserva()).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        if (this.asignacionRepository.existsByPersonalAndFecha(personal.getIdPersonal(), asignacion.getFechaAsignacion())) {
            throw new IllegalArgumentException("El personal ya est\u00e1 asignado en esta fecha");
        }
        if (!asignacion.getFechaAsignacion().equals(reserva.getFechaServicio())) {
            throw new IllegalArgumentException("La fecha de asignaci\u00f3n debe coincidir con la fecha del servicio");
        }
        asignacion.setEstado(AsignacionPersonal.EstadoAsignacion.Asignado);
        return (AsignacionPersonal)this.asignacionRepository.save((Object)asignacion);
    }

    public Optional<AsignacionPersonal> findById(Long id) {
        return this.asignacionRepository.findById((Object)id);
    }

    public List<AsignacionPersonal> findByReservaId(Long reservaId) {
        return this.asignacionRepository.findByReservaId(reservaId);
    }

    public List<AsignacionPersonal> findByPersonalId(Long personalId) {
        return this.asignacionRepository.findByPersonalId(personalId);
    }

    public List<AsignacionPersonal> findByFecha(Date fecha) {
        return this.asignacionRepository.findByFechaAsignacion(fecha);
    }

    public List<AsignacionPersonal> findByFechaBetween(Date fechaInicio, Date fechaFin) {
        return this.asignacionRepository.findByFechaAsignacionBetween(fechaInicio, fechaFin);
    }

    @Transactional
    public AsignacionPersonal update(Long id, AsignacionPersonal asignacionActualizada) {
        log.info("Actualizando asignaci\u00f3n ID: {}", (Object)id);
        AsignacionPersonal asignacionExistente = (AsignacionPersonal)this.asignacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Asignaci\u00f3n no encontrada"));
        if (asignacionActualizada.getObservaciones() != null) {
            asignacionExistente.setObservaciones(asignacionActualizada.getObservaciones());
        }
        return (AsignacionPersonal)this.asignacionRepository.save((Object)asignacionExistente);
    }

    @Transactional
    public AsignacionPersonal update(Long id, AsignacionPersonalUpdateRequest request) {
        log.info("Actualizando asignaci\u00f3n ID: {} con nuevo personal: {}", (Object)id, (Object)request.getIdPersonal());
        AsignacionPersonal asignacionExistente = (AsignacionPersonal)this.asignacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Asignaci\u00f3n no encontrada"));
        if (!request.getIdPersonal().equals(asignacionExistente.getPersonal().getIdPersonal())) {
            Personal nuevoPersonal = (Personal)this.personalRepository.findById((Object)request.getIdPersonal()).orElseThrow(() -> new IllegalArgumentException("Nuevo personal no encontrado"));
            if (!nuevoPersonal.isActivo()) {
                throw new IllegalArgumentException("El nuevo personal no est\u00e1 activo");
            }
            if (this.asignacionRepository.existsByPersonalAndFecha(request.getIdPersonal(), asignacionExistente.getFechaAsignacion())) {
                throw new IllegalArgumentException("El nuevo personal ya est\u00e1 asignado en esta fecha");
            }
            asignacionExistente.setPersonal(nuevoPersonal);
        }
        asignacionExistente.setObservaciones(request.getObservaciones());
        return (AsignacionPersonal)this.asignacionRepository.save((Object)asignacionExistente);
    }

    @Transactional
    public AsignacionPersonal completar(Long id) {
        log.info("Marcando asignaci\u00f3n ID {} como completada", (Object)id);
        AsignacionPersonal asignacion = (AsignacionPersonal)this.asignacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Asignaci\u00f3n no encontrada"));
        if (asignacion.getEstado() != AsignacionPersonal.EstadoAsignacion.Asignado) {
            throw new IllegalArgumentException("Solo se pueden completar asignaciones en estado 'Asignado'");
        }
        asignacion.setEstado(AsignacionPersonal.EstadoAsignacion.Completado);
        return (AsignacionPersonal)this.asignacionRepository.save((Object)asignacion);
    }

    @Transactional
    public AsignacionPersonal cancelar(Long id, String motivo) {
        log.info("Cancelando asignaci\u00f3n ID: {}", (Object)id);
        AsignacionPersonal asignacion = (AsignacionPersonal)this.asignacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Asignaci\u00f3n no encontrada"));
        if (asignacion.getEstado() == AsignacionPersonal.EstadoAsignacion.Completado) {
            throw new IllegalArgumentException("No se puede cancelar una asignaci\u00f3n completada");
        }
        asignacion.setEstado(AsignacionPersonal.EstadoAsignacion.Cancelado);
        asignacion.setObservaciones(motivo != null ? motivo : "Cancelado por el sistema");
        return (AsignacionPersonal)this.asignacionRepository.save((Object)asignacion);
    }

    @Transactional
    public void delete(Long id) {
        log.info("Eliminando asignaci\u00f3n ID: {}", (Object)id);
        AsignacionPersonal asignacion = (AsignacionPersonal)this.asignacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Asignaci\u00f3n no encontrada"));
        this.asignacionRepository.delete((Object)asignacion);
    }

    @Transactional(readOnly=true)
    public boolean verificarDisponibilidadPersonal(Long personalId, Date fecha) {
        return !this.asignacionRepository.existsByPersonalAndFecha(personalId, fecha);
    }

    public Long countAsignacionesActivasByPersonal(Long personalId) {
        return this.asignacionRepository.countAsignacionesActivasByPersonal(personalId);
    }

    @Generated
    public AsignacionPersonalService(AsignacionPersonalRepository asignacionRepository, PersonalRepository personalRepository, ReservaRepository reservaRepository) {
        this.asignacionRepository = asignacionRepository;
        this.personalRepository = personalRepository;
        this.reservaRepository = reservaRepository;
    }
}

