/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.ServicioResponse;
import com.sistema.turistico.entity.ServicioTuristico;
import com.sistema.turistico.repository.ServicioTuristicoRepository;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServicioTuristicoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServicioTuristicoService.class);
    private final ServicioTuristicoRepository servicioRepository;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sistema$turistico$entity$ServicioTuristico$TipoServicio;

    public ServicioTuristico create(ServicioTuristico servicio) {
        log.info("Creando nuevo servicio tur\u00edstico: {}", (Object)servicio.getNombreServicio());
        if (this.servicioRepository.existsByEmpresaIdAndNombreServicioAndIdNot(servicio.getEmpresa().getIdEmpresa(), servicio.getNombreServicio(), Long.valueOf(0L))) {
            throw new IllegalArgumentException("Ya existe un servicio con este nombre en la empresa");
        }
        this.validarServicio(servicio);
        servicio.setEstado(Boolean.valueOf(true));
        ServicioTuristico savedServicio = (ServicioTuristico)this.servicioRepository.save((Object)servicio);
        log.info("Servicio tur\u00edstico creado exitosamente con ID: {}", (Object)savedServicio.getIdServicio());
        return savedServicio;
    }

    @Transactional(readOnly=true)
    public Optional<ServicioTuristico> findById(Long id) {
        log.debug("Buscando servicio tur\u00edstico con ID: {}", (Object)id);
        return this.servicioRepository.findById((Object)id);
    }

    @Transactional(readOnly=true)
    public List<ServicioTuristico> findByEmpresaId(Long empresaId) {
        log.debug("Listando servicios tur\u00edsticos de empresa ID: {}", (Object)empresaId);
        return this.servicioRepository.findByEmpresaId(empresaId);
    }

    @Transactional(readOnly=true)
    public List<ServicioTuristico> findByEmpresaIdAndTipoServicio(Long empresaId, ServicioTuristico.TipoServicio tipoServicio) {
        log.debug("Listando servicios de empresa {} y tipo {}", (Object)empresaId, (Object)tipoServicio);
        return this.servicioRepository.findByEmpresaIdAndTipoServicio(empresaId, tipoServicio);
    }

    @Transactional(readOnly=true)
    public List<ServicioTuristico> findDisponiblesByEmpresaIdAndPersonas(Long empresaId, Integer personasRequeridas) {
        log.debug("Buscando servicios disponibles para {} personas en empresa {}", (Object)personasRequeridas, (Object)empresaId);
        return this.servicioRepository.findDisponiblesByEmpresaIdAndPersonas(empresaId, personasRequeridas);
    }

    @Transactional(readOnly=true)
    public List<ServicioTuristico> findByEmpresaIdAndBusqueda(Long empresaId, String busqueda) {
        log.debug("Buscando servicios en empresa {} con t\u00e9rmino: {}", (Object)empresaId, (Object)busqueda);
        if (busqueda == null || busqueda.trim().isEmpty()) {
            return this.servicioRepository.findByEmpresaIdOrderByCreatedAtDesc(empresaId);
        }
        return this.servicioRepository.findByEmpresaIdAndBusqueda(empresaId, busqueda.trim());
    }

    @Transactional(readOnly=true)
    public List<ServicioTuristico> findByEmpresaIdAndPrecioBetween(Long empresaId, BigDecimal precioMin, BigDecimal precioMax) {
        log.debug("Buscando servicios en empresa {} entre precios {} - {}", new Object[]{empresaId, precioMin, precioMax});
        return this.servicioRepository.findByEmpresaIdAndPrecioBetween(empresaId, precioMin, precioMax);
    }

    public ServicioTuristico update(Long id, ServicioTuristico servicioActualizado) {
        log.info("Actualizando servicio tur\u00edstico ID: {}", (Object)id);
        ServicioTuristico servicioExistente = (ServicioTuristico)this.servicioRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Servicio tur\u00edstico no encontrado"));
        if (this.servicioRepository.existsByEmpresaIdAndNombreServicioAndIdNot(servicioExistente.getEmpresa().getIdEmpresa(), servicioActualizado.getNombreServicio(), id)) {
            throw new IllegalArgumentException("Ya existe un servicio con este nombre en la empresa");
        }
        this.validarServicio(servicioActualizado);
        servicioExistente.setNombreServicio(servicioActualizado.getNombreServicio());
        servicioExistente.setTipoServicio(servicioActualizado.getTipoServicio());
        servicioExistente.setDescripcion(servicioActualizado.getDescripcion());
        servicioExistente.setUbicacionDestino(servicioActualizado.getUbicacionDestino());
        servicioExistente.setDuracion(servicioActualizado.getDuracion());
        servicioExistente.setCapacidadMaxima(servicioActualizado.getCapacidadMaxima());
        servicioExistente.setPrecioBase(servicioActualizado.getPrecioBase());
        servicioExistente.setIncluye(servicioActualizado.getIncluye());
        servicioExistente.setNoIncluye(servicioActualizado.getNoIncluye());
        servicioExistente.setRequisitos(servicioActualizado.getRequisitos());
        servicioExistente.setPoliticasEspeciales(servicioActualizado.getPoliticasEspeciales());
        servicioExistente.setImagenes(servicioActualizado.getImagenes());
        servicioExistente.setItinerario(servicioActualizado.getItinerario());
        servicioExistente.setIdCategoria(servicioActualizado.getIdCategoria());
        servicioExistente.setIdProveedor(servicioActualizado.getIdProveedor());
        ServicioTuristico updatedServicio = (ServicioTuristico)this.servicioRepository.save((Object)servicioExistente);
        log.info("Servicio tur\u00edstico actualizado exitosamente: {}", (Object)updatedServicio.getIdServicio());
        return updatedServicio;
    }

    public void delete(Long id) {
        log.info("Eliminando servicio tur\u00edstico ID: {} (soft delete)", (Object)id);
        ServicioTuristico servicio = (ServicioTuristico)this.servicioRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Servicio tur\u00edstico no encontrado"));
        servicio.setEstado(Boolean.valueOf(false));
        servicio.setDeletedAt(LocalDateTime.now());
        this.servicioRepository.save((Object)servicio);
        log.info("Servicio tur\u00edstico eliminado exitosamente: {}", (Object)id);
    }

    @Transactional(readOnly=true)
    public boolean verificarDisponibilidad(Long servicioId, Integer personasRequeridas) {
        Optional servicioOpt = this.servicioRepository.findById((Object)servicioId);
        if (servicioOpt.isEmpty()) {
            return false;
        }
        ServicioTuristico servicio = (ServicioTuristico)servicioOpt.get();
        return servicio.isActivo() && servicio.tieneDisponibilidad(personasRequeridas);
    }

    @Transactional(readOnly=true)
    public BigDecimal calcularPrecioTotal(Long servicioId, Integer personas) {
        ServicioTuristico servicio = (ServicioTuristico)this.servicioRepository.findById((Object)servicioId).orElseThrow(() -> new IllegalArgumentException("Servicio tur\u00edstico no encontrado"));
        if (!servicio.isActivo()) {
            throw new IllegalArgumentException("El servicio no est\u00e1 disponible");
        }
        return servicio.calcularPrecioTotal(personas);
    }

    /*
     * Exception decompiling
     */
    private void validarServicio(ServicioTuristico servicio) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Transactional(readOnly=true)
    public Long countByEmpresaId(Long empresaId) {
        return this.servicioRepository.countByEmpresaId(empresaId);
    }

    public ServicioResponse toResponse(ServicioTuristico servicio) {
        return new ServicioResponse(servicio.getIdServicio(), servicio.getTipoServicio().toString(), servicio.getNombreServicio(), servicio.getDescripcion(), servicio.getUbicacionDestino(), servicio.getDuracion(), servicio.getCapacidadMaxima(), servicio.getPrecioBase(), servicio.getIncluye(), servicio.getNoIncluye(), servicio.getRequisitos(), servicio.getPoliticasEspeciales(), servicio.getEstado().booleanValue(), servicio.getCreatedAt() != null ? servicio.getCreatedAt().toString() : null, servicio.getUpdatedAt() != null ? servicio.getUpdatedAt().toString() : null);
    }

    @Generated
    public ServicioTuristicoService(ServicioTuristicoRepository servicioRepository) {
        this.servicioRepository = servicioRepository;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sistema$turistico$entity$ServicioTuristico$TipoServicio() {
        if ($SWITCH_TABLE$com$sistema$turistico$entity$ServicioTuristico$TipoServicio != null) {
            return $SWITCH_TABLE$com$sistema$turistico$entity$ServicioTuristico$TipoServicio;
        }
        int[] nArray = new int[ServicioTuristico.TipoServicio.values().length];
        try {
            nArray[ServicioTuristico.TipoServicio.EntradaAtractivo.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ServicioTuristico.TipoServicio.Hotel.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ServicioTuristico.TipoServicio.Tour.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ServicioTuristico.TipoServicio.Transporte.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sistema$turistico$entity$ServicioTuristico$TipoServicio = nArray;
        return nArray;
    }
}

