/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.UsuarioRequest;
import com.sistema.turistico.dto.UsuarioResponse;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.Rol;
import com.sistema.turistico.entity.Sucursal;
import com.sistema.turistico.entity.Usuario;
import com.sistema.turistico.repository.EmpresaRepository;
import com.sistema.turistico.repository.RolRepository;
import com.sistema.turistico.repository.SucursalRepository;
import com.sistema.turistico.repository.UsuarioRepository;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UsuarioCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UsuarioCrudService.class);
    private final UsuarioRepository usuarioRepository;
    private final EmpresaRepository empresaRepository;
    private final RolRepository rolRepository;
    private final SucursalRepository sucursalRepository;
    private final PasswordEncoder passwordEncoder;

    public Usuario crear(UsuarioRequest request) {
        String dni;
        log.info("Creando usuario con email {}", (Object)request.getEmail());
        String email = request.getEmail().trim();
        if (this.usuarioRepository.existsByEmail(email)) {
            throw new IllegalArgumentException("Ya existe un usuario con este email");
        }
        String string = dni = request.getDni() != null ? request.getDni().trim() : null;
        if (dni != null && !dni.isEmpty() && this.usuarioRepository.existsByDni(dni)) {
            throw new IllegalArgumentException("Ya existe un usuario con este DNI");
        }
        Integer estado = request.getEstado();
        if (estado != null && estado != 0 && estado != 1) {
            throw new IllegalArgumentException("El estado del usuario debe ser 0 (Inactivo) o 1 (Activo)");
        }
        Empresa empresa = (Empresa)this.empresaRepository.findById((Object)request.getEmpresaId()).orElseThrow(() -> new IllegalArgumentException("Empresa no encontrada"));
        Rol rol = (Rol)this.rolRepository.findActivoById(request.getRolId()).orElseThrow(() -> new IllegalArgumentException("Rol no encontrado"));
        Sucursal sucursal = null;
        if (request.getSucursalId() != null) {
            sucursal = this.obtenerSucursal(request.getSucursalId());
        }
        if (request.getPassword() == null || request.getPassword().trim().isEmpty()) {
            throw new IllegalArgumentException("La contrase\u00f1a es obligatoria");
        }
        String password = request.getPassword().trim();
        Usuario usuario = new Usuario();
        usuario.setNombre(request.getNombre().trim());
        usuario.setApellido(request.getApellido().trim());
        usuario.setEmail(email);
        usuario.setPasswordHash(this.passwordEncoder.encode((CharSequence)password));
        usuario.setDni(dni);
        usuario.setEstado(Integer.valueOf(estado != null ? estado : 1));
        usuario.setEmpresa(empresa);
        usuario.setRol(rol);
        usuario.setSucursal(sucursal);
        usuario.setDeletedAt(null);
        Usuario creado = (Usuario)this.usuarioRepository.save((Object)usuario);
        log.info("Usuario creado exitosamente con ID {}", (Object)creado.getIdUsuario());
        return creado;
    }

    @Transactional(readOnly=true)
    public List<Usuario> listar(String busqueda, Integer estado, Long empresaId, Long rolId) {
        String criterio;
        String string = criterio = busqueda != null && !busqueda.trim().isEmpty() ? busqueda.trim() : null;
        if (criterio == null && estado == null && empresaId == null && rolId == null) {
            return this.usuarioRepository.findAllActivos();
        }
        return this.usuarioRepository.findByFiltros(criterio, estado, empresaId, rolId);
    }

    @Transactional(readOnly=true)
    public Usuario obtenerPorId(Long id) {
        return (Usuario)this.usuarioRepository.findActivoById(id).orElseThrow(() -> new IllegalArgumentException("Usuario no encontrado"));
    }

    public Usuario actualizar(Long id, UsuarioRequest request) {
        String dni;
        log.info("Actualizando usuario {}", (Object)id);
        Usuario existente = this.obtenerPorId(id);
        String email = request.getEmail().trim();
        if (!existente.getEmail().equalsIgnoreCase(email) && this.usuarioRepository.existsByEmailAndIdUsuarioNot(email, id)) {
            throw new IllegalArgumentException("Ya existe un usuario con este email");
        }
        String string = dni = request.getDni() != null ? request.getDni().trim() : null;
        if (dni != null && !dni.isEmpty() && this.usuarioRepository.existsByDniAndIdUsuarioNot(dni, id)) {
            throw new IllegalArgumentException("Ya existe un usuario con este DNI");
        }
        Integer estado = request.getEstado();
        if (estado != null && estado != 0 && estado != 1) {
            throw new IllegalArgumentException("El estado del usuario debe ser 0 (Inactivo) o 1 (Activo)");
        }
        Empresa empresa = (Empresa)this.empresaRepository.findById((Object)request.getEmpresaId()).orElseThrow(() -> new IllegalArgumentException("Empresa no encontrada"));
        Rol rol = (Rol)this.rolRepository.findActivoById(request.getRolId()).orElseThrow(() -> new IllegalArgumentException("Rol no encontrado"));
        Sucursal sucursal = null;
        if (request.getSucursalId() != null) {
            sucursal = this.obtenerSucursal(request.getSucursalId());
        }
        existente.setNombre(request.getNombre().trim());
        existente.setApellido(request.getApellido().trim());
        existente.setEmail(email);
        if (request.getPassword() != null && !request.getPassword().trim().isEmpty()) {
            existente.setPasswordHash(this.passwordEncoder.encode((CharSequence)request.getPassword().trim()));
        }
        existente.setDni(dni);
        if (estado != null) {
            existente.setEstado(estado);
        }
        existente.setEmpresa(empresa);
        existente.setRol(rol);
        existente.setSucursal(sucursal);
        Usuario actualizado = (Usuario)this.usuarioRepository.save((Object)existente);
        log.info("Usuario actualizado exitosamente {}", (Object)actualizado.getIdUsuario());
        return actualizado;
    }

    public void eliminar(Long id) {
        log.info("Eliminando usuario (soft delete) {}", (Object)id);
        Usuario usuario = this.obtenerPorId(id);
        usuario.setEstado(Integer.valueOf(0));
        usuario.setDeletedAt(LocalDateTime.now());
        this.usuarioRepository.save((Object)usuario);
    }

    @Transactional(readOnly=true)
    public UsuarioResponse toResponse(Usuario usuario) {
        return new UsuarioResponse(usuario.getIdUsuario(), usuario.getNombre(), usuario.getApellido(), usuario.getEmail(), usuario.getDni(), usuario.getEstado(), usuario.getEmpresa() != null ? usuario.getEmpresa().getIdEmpresa() : null, usuario.getEmpresa() != null ? usuario.getEmpresa().getNombreEmpresa() : null, usuario.getRol() != null ? usuario.getRol().getIdRol() : null, usuario.getRol() != null ? usuario.getRol().getNombreRol() : null, usuario.getSucursal() != null ? usuario.getSucursal().getIdSucursal() : null, usuario.getCreatedAt() != null ? usuario.getCreatedAt().toString() : null, usuario.getUpdatedAt() != null ? usuario.getUpdatedAt().toString() : null, usuario.getDeletedAt() != null ? usuario.getDeletedAt().toString() : null);
    }

    private Sucursal obtenerSucursal(Long sucursalId) {
        return (Sucursal)this.sucursalRepository.findActivaById(sucursalId).orElseThrow(() -> new IllegalArgumentException("Sucursal no encontrada"));
    }

    @Generated
    public UsuarioCrudService(UsuarioRepository usuarioRepository, EmpresaRepository empresaRepository, RolRepository rolRepository, SucursalRepository sucursalRepository, PasswordEncoder passwordEncoder) {
        this.usuarioRepository = usuarioRepository;
        this.empresaRepository = empresaRepository;
        this.rolRepository = rolRepository;
        this.sucursalRepository = sucursalRepository;
        this.passwordEncoder = passwordEncoder;
    }
}

