/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.util;

import com.sistema.turistico.config.JwtConfig;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.security.Key;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);
    private final JwtConfig jwtConfig;

    public String generateToken(Authentication authentication) {
        String username = authentication.getName();
        List roles = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        Date now = new Date();
        Date expiryDate = new Date(now.getTime() + this.jwtConfig.getExpiration());
        return Jwts.builder().setSubject(username).claim("roles", roles).setIssuer(this.jwtConfig.getIssuer()).setIssuedAt(now).setExpiration(expiryDate).signWith((Key)this.jwtConfig.getSecretKey(), SignatureAlgorithm.HS256).compact();
    }

    public String generateToken(String username, List<String> roles, Long userId, Long empresaId) {
        Date now = new Date();
        Date expiryDate = new Date(now.getTime() + this.jwtConfig.getExpiration());
        return Jwts.builder().setSubject(username).claim("userId", (Object)userId).claim("empresaId", (Object)empresaId).claim("roles", roles).setIssuer(this.jwtConfig.getIssuer()).setIssuedAt(now).setExpiration(expiryDate).signWith((Key)this.jwtConfig.getSecretKey(), SignatureAlgorithm.HS256).compact();
    }

    public String getUsernameFromToken(String token) {
        Claims claims = this.getClaimsFromToken(token);
        return claims.getSubject();
    }

    public Long getUserIdFromToken(String token) {
        Claims claims = this.getClaimsFromToken(token);
        return (Long)claims.get("userId", Long.class);
    }

    public Long getEmpresaIdFromToken(String token) {
        Claims claims = this.getClaimsFromToken(token);
        return (Long)claims.get("empresaId", Long.class);
    }

    public List<String> getRolesFromToken(String token) {
        Claims claims = this.getClaimsFromToken(token);
        return (List)claims.get((Object)"roles");
    }

    public boolean validateToken(String token) {
        try {
            Jwts.parserBuilder().setSigningKey((Key)this.jwtConfig.getSecretKey()).build().parseClaimsJws(token);
            return true;
        }
        catch (ExpiredJwtException e) {
            log.warn("Token expirado: {}", (Object)e.getMessage());
        }
        catch (UnsupportedJwtException e) {
            log.warn("Token no soportado: {}", (Object)e.getMessage());
        }
        catch (MalformedJwtException e) {
            log.warn("Token malformado: {}", (Object)e.getMessage());
        }
        catch (SignatureException e) {
            log.warn("Firma inv\u00e1lida: {}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.warn("Token vac\u00edo: {}", (Object)e.getMessage());
        }
        return false;
    }

    private Claims getClaimsFromToken(String token) {
        return (Claims)Jwts.parserBuilder().setSigningKey((Key)this.jwtConfig.getSecretKey()).build().parseClaimsJws(token).getBody();
    }

    @Generated
    public JwtUtil(JwtConfig jwtConfig) {
        this.jwtConfig = jwtConfig;
    }
}

