/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.PaqueteResponse;
import com.sistema.turistico.entity.PaqueteTuristico;
import com.sistema.turistico.service.PaqueteTuristicoService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.method.P;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/paquetes"})
@Tag(name="Paquetes Tur\u00edsticos", description="Endpoints para gesti\u00f3n de paquetes tur\u00edsticos")
public class PaqueteTuristicoController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PaqueteTuristicoController.class);
    private final PaqueteTuristicoService paqueteService;

    @PostMapping
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canManagePaquete(#paquete)")
    @Operation(summary="Crear paquete tur\u00edstico", description="Crea un nuevo paquete tur\u00edstico en el sistema")
    public ResponseEntity<Map<String, Object>> crearPaquete(@Valid @P(value="paquete") @RequestBody PaqueteTuristico paquete) {
        try {
            log.info("Creando paquete tur\u00edstico: {}", (Object)paquete.getNombrePaquete());
            PaqueteTuristico nuevoPaquete = this.paqueteService.create(paquete);
            PaqueteResponse paqueteResponse = this.paqueteService.toResponse(nuevoPaquete);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Paquete tur\u00edstico creado exitosamente");
            response.put("data", paqueteResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error de validaci\u00f3n al crear paquete: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error interno al crear paquete tur\u00edstico", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO','ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessEmpresa(#empresaId)")
    @Operation(summary="Listar paquetes tur\u00edsticos", description="Obtiene la lista de paquetes tur\u00edsticos con filtros opcionales")
    public ResponseEntity<Map<String, Object>> listarPaquetes(@P(value="empresaId") @RequestParam(value="empresaId", required=false) Long empresaId, @RequestParam(required=false) String busqueda, @RequestParam(required=false) Boolean disponibles, @RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="10") int size) {
        try {
            if (page < 1 || size < 1) {
                throw new IllegalArgumentException("Los par\u00e1metros de paginaci\u00f3n deben ser mayores que cero");
            }
            log.info("Listando paquetes de empresa {} con filtros", (Object)empresaId);
            List paquetes = Boolean.TRUE.equals(disponibles) ? this.paqueteService.findPaquetesDisponiblesByEmpresaId(empresaId) : this.paqueteService.findByEmpresaIdAndBusqueda(empresaId, busqueda);
            List<PaqueteResponse> paquetesResponse = paquetes.stream().map(arg_0 -> ((PaqueteTuristicoService)this.paqueteService).toResponse(arg_0)).toList();
            int totalItems = paquetesResponse.size();
            int startIndex = (page - 1) * size;
            int endIndex = Math.min(startIndex + size, totalItems);
            List<Object> paginatedData = startIndex >= totalItems ? List.of() : paquetesResponse.subList(startIndex, endIndex);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Paquetes tur\u00edsticos obtenidos exitosamente");
            response.put("data", paginatedData);
            response.put("total", totalItems);
            response.put("page", page);
            response.put("size", size);
            response.put("totalPages", (int)Math.ceil((double)totalItems / (double)size));
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error de validaci\u00f3n al listar paquetes: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al listar paquetes tur\u00edsticos", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO','ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessPaquete(#id)")
    @Operation(summary="Obtener paquete por ID", description="Obtiene un paquete tur\u00edstico espec\u00edfico por su ID")
    public ResponseEntity<Map<String, Object>> obtenerPaquete(@P(value="id") @PathVariable Long id) {
        try {
            log.info("Obteniendo paquete tur\u00edstico con ID: {}", (Object)id);
            PaqueteTuristico paquete = (PaqueteTuristico)this.paqueteService.findById(id).orElseThrow(() -> new IllegalArgumentException("Paquete tur\u00edstico no encontrado"));
            PaqueteResponse paqueteResponse = this.paqueteService.toResponse(paquete);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Paquete tur\u00edstico obtenido exitosamente");
            response.put("data", paqueteResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Paquete no encontrado: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            log.error("Error al obtener paquete con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessPaquete(#id) and @tenantSecurity.canManagePaquete(#paquete)")
    @Operation(summary="Actualizar paquete tur\u00edstico", description="Actualiza los datos de un paquete tur\u00edstico existente")
    public ResponseEntity<Map<String, Object>> actualizarPaquete(@P(value="id") @PathVariable Long id, @Valid @P(value="paquete") @RequestBody PaqueteTuristico paquete) {
        try {
            log.info("Actualizando paquete tur\u00edstico ID: {}", (Object)id);
            PaqueteTuristico paqueteActualizado = this.paqueteService.update(id, paquete);
            PaqueteResponse paqueteResponse = this.paqueteService.toResponse(paqueteActualizado);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Paquete tur\u00edstico actualizado exitosamente");
            response.put("data", paqueteResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error de validaci\u00f3n al actualizar paquete: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al actualizar paquete con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessPaquete(#id)")
    @Operation(summary="Eliminar paquete tur\u00edstico", description="Elimina un paquete tur\u00edstico del sistema (soft delete)")
    public ResponseEntity<Map<String, Object>> eliminarPaquete(@P(value="id") @PathVariable Long id) {
        try {
            log.info("Eliminando paquete tur\u00edstico ID: {}", (Object)id);
            this.paqueteService.delete(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Paquete tur\u00edstico eliminado exitosamente");
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error al eliminar paquete: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al eliminar paquete con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @PostMapping(value={"/{id}/servicios"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessPaquete(#id) and @tenantSecurity.canAccessServicio(#servicioId)")
    @Operation(summary="Agregar servicio al paquete", description="Agrega un servicio tur\u00edstico a un paquete existente")
    public ResponseEntity<Map<String, Object>> agregarServicio(@P(value="id") @PathVariable Long id, @P(value="servicioId") @RequestParam Long servicioId, @RequestParam(defaultValue="1") Integer orden) {
        try {
            log.info("Agregando servicio {} al paquete {}", (Object)servicioId, (Object)id);
            PaqueteTuristico paqueteActualizado = this.paqueteService.agregarServicio(id, servicioId, orden);
            PaqueteResponse paqueteResponse = this.paqueteService.toResponse(paqueteActualizado);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Servicio agregado al paquete exitosamente");
            response.put("data", paqueteResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error al agregar servicio al paquete: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al agregar servicio al paquete {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @DeleteMapping(value={"/{id}/servicios/{servicioId}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessPaquete(#id) and @tenantSecurity.canAccessServicio(#servicioId)")
    @Operation(summary="Remover servicio del paquete", description="Remueve un servicio tur\u00edstico de un paquete existente")
    public ResponseEntity<Map<String, Object>> removerServicio(@P(value="id") @PathVariable Long id, @P(value="servicioId") @PathVariable Long servicioId) {
        try {
            log.info("Removiendo servicio {} del paquete {}", (Object)servicioId, (Object)id);
            PaqueteTuristico paqueteActualizado = this.paqueteService.removerServicio(id, servicioId);
            PaqueteResponse paqueteResponse = this.paqueteService.toResponse(paqueteActualizado);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Servicio removido del paquete exitosamente");
            response.put("data", paqueteResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error al remover servicio del paquete: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al remover servicio del paquete {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping(value={"/{id}/precio"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO','ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessPaquete(#id)")
    @Operation(summary="Calcular precio del paquete", description="Calcula el precio total del paquete con descuento aplicado")
    public ResponseEntity<Map<String, Object>> calcularPrecio(@P(value="id") @PathVariable Long id) {
        try {
            log.info("Calculando precio del paquete {}", (Object)id);
            PaqueteTuristico paquete = (PaqueteTuristico)this.paqueteService.findById(id).orElseThrow(() -> new IllegalArgumentException("Paquete tur\u00edstico no encontrado"));
            BigDecimal precioTotal = paquete.getPrecioTotal();
            BigDecimal precioFinal = paquete.getPrecioFinal();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Precio del paquete calculado exitosamente");
            response.put("data", Map.of("paqueteId", id, "precioTotal", precioTotal, "descuento", paquete.getDescuento(), "precioFinal", precioFinal, "ahorro", precioTotal.subtract(precioFinal)));
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error al calcular precio del paquete: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al calcular precio del paquete {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @Generated
    public PaqueteTuristicoController(PaqueteTuristicoService paqueteService) {
        this.paqueteService = paqueteService;
    }
}

