/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.service.ReporteFinancieroService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.method.P;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reportes/finanzas"})
@Tag(name="Reportes Financieros", description="Resumenes de caja y ventas")
public class ReporteFinancieroController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReporteFinancieroController.class);
    private final ReporteFinancieroService reporteFinancieroService;

    @GetMapping(value={"/caja-diaria"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessEmpresa(#empresaId)")
    @Operation(summary="Resumen diario de caja", description="Obtiene totales de cajas por fecha para una empresa")
    public ResponseEntity<Map<String, Object>> obtenerResumenCajaDiaria(@P(value="empresaId") @RequestParam(required=false) Long empresaId, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fecha) {
        try {
            Map data = this.reporteFinancieroService.resumenCajaDiario(empresaId, fecha);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Resumen de caja obtenido correctamente");
            response.put("data", data);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Solicitud inv\u00e1lida para resumen de caja: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener resumen de caja", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/impuestos"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessEmpresa(#empresaId)")
    @Operation(summary="Resumen de impuestos", description="Calcula impuestos estimados de las ventas en un periodo")
    public ResponseEntity<Map<String, Object>> obtenerResumenImpuestos(@P(value="empresaId") @RequestParam(required=false) Long empresaId, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaInicio, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaFin, @RequestParam(required=false) BigDecimal porcentajeImpuesto) {
        try {
            Map data = this.reporteFinancieroService.resumenVentasImpuestos(empresaId, fechaInicio, fechaFin, porcentajeImpuesto);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Resumen de impuestos obtenido correctamente");
            response.put("data", data);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Solicitud inv\u00e1lida para resumen de impuestos: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener resumen de impuestos", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @Generated
    public ReporteFinancieroController(ReporteFinancieroService reporteFinancieroService) {
        this.reporteFinancieroService = reporteFinancieroService;
    }
}

