/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.ServicioResponse;
import com.sistema.turistico.entity.ServicioTuristico;
import com.sistema.turistico.service.ServicioTuristicoService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.method.P;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servicios"})
@Tag(name="Servicios Tur\u00edsticos", description="Endpoints para gesti\u00f3n de servicios tur\u00edsticos")
public class ServicioTuristicoController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServicioTuristicoController.class);
    private final ServicioTuristicoService servicioService;

    @PostMapping
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canManageServicio(#servicio)")
    @Operation(summary="Crear servicio tur\u00edstico", description="Crea un nuevo servicio tur\u00edstico en el sistema")
    public ResponseEntity<Map<String, Object>> crearServicio(@Valid @P(value="servicio") @RequestBody ServicioTuristico servicio) {
        try {
            log.info("Creando servicio tur\u00edstico: {}", (Object)servicio.getNombreServicio());
            ServicioTuristico nuevoServicio = this.servicioService.create(servicio);
            ServicioResponse servicioResponse = this.servicioService.toResponse(nuevoServicio);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Servicio tur\u00edstico creado exitosamente");
            response.put("data", servicioResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error de validaci\u00f3n al crear servicio: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error interno al crear servicio tur\u00edstico", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO','ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessEmpresa(#empresaId)")
    @Operation(summary="Listar servicios tur\u00edsticos", description="Obtiene la lista de servicios tur\u00edsticos con filtros opcionales")
    public ResponseEntity<Map<String, Object>> listarServicios(@P(value="empresaId") @RequestParam(value="empresaId", required=false) Long empresaId, @RequestParam(required=false) String busqueda, @RequestParam(required=false) ServicioTuristico.TipoServicio tipoServicio, @RequestParam(required=false) BigDecimal precioMin, @RequestParam(required=false) BigDecimal precioMax, @RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="10") int size) {
        try {
            if (page < 1 || size < 1) {
                throw new IllegalArgumentException("Los par\u00e1metros de paginaci\u00f3n deben ser mayores que cero");
            }
            log.info("Listando servicios de empresa {} con filtros - p\u00e1gina: {}, tama\u00f1o: {}", new Object[]{empresaId, page, size});
            List servicios = tipoServicio != null ? this.servicioService.findByEmpresaIdAndTipoServicio(empresaId, tipoServicio) : (precioMin != null && precioMax != null ? this.servicioService.findByEmpresaIdAndPrecioBetween(empresaId, precioMin, precioMax) : this.servicioService.findByEmpresaIdAndBusqueda(empresaId, busqueda));
            int totalItems = servicios.size();
            int startIndex = (page - 1) * size;
            int endIndex = Math.min(startIndex + size, totalItems);
            List serviciosPaginados = startIndex >= totalItems ? List.of() : servicios.subList(startIndex, endIndex);
            List<ServicioResponse> serviciosResponse = serviciosPaginados.stream().map(arg_0 -> ((ServicioTuristicoService)this.servicioService).toResponse(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Servicios tur\u00edsticos obtenidos exitosamente");
            response.put("data", serviciosResponse);
            response.put("total", totalItems);
            response.put("page", page);
            response.put("size", size);
            response.put("totalPages", (int)Math.ceil((double)totalItems / (double)size));
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error al listar servicios: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al listar servicios tur\u00edsticos", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping(value={"/disponibles"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO','ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessEmpresa(#empresaId)")
    @Operation(summary="Listar servicios disponibles", description="Obtiene servicios disponibles para un n\u00famero de personas")
    public ResponseEntity<Map<String, Object>> listarServiciosDisponibles(@P(value="empresaId") @RequestParam(value="empresaId", required=false) Long empresaId, @RequestParam Integer personas) {
        try {
            log.info("Buscando servicios disponibles para {} personas en empresa {}", (Object)personas, (Object)empresaId);
            List servicios = this.servicioService.findDisponiblesByEmpresaIdAndPersonas(empresaId, personas);
            List<ServicioResponse> serviciosResponse = servicios.stream().map(arg_0 -> ((ServicioTuristicoService)this.servicioService).toResponse(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Servicios disponibles obtenidos exitosamente");
            response.put("data", serviciosResponse);
            response.put("total", serviciosResponse.size());
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error de validaci\u00f3n al listar servicios disponibles: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al listar servicios disponibles", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO','ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessServicio(#id)")
    @Operation(summary="Obtener servicio por ID", description="Obtiene un servicio tur\u00edstico espec\u00edfico por su ID")
    public ResponseEntity<Map<String, Object>> obtenerServicio(@P(value="id") @PathVariable Long id) {
        try {
            log.info("Obteniendo servicio tur\u00edstico con ID: {}", (Object)id);
            ServicioTuristico servicio = (ServicioTuristico)this.servicioService.findById(id).orElseThrow(() -> new IllegalArgumentException("Servicio tur\u00edstico no encontrado"));
            ServicioResponse servicioResponse = this.servicioService.toResponse(servicio);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Servicio tur\u00edstico obtenido exitosamente");
            response.put("data", servicioResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Servicio no encontrado: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            log.error("Error al obtener servicio con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessServicio(#id) and @tenantSecurity.canManageServicio(#servicio)")
    @Operation(summary="Actualizar servicio tur\u00edstico", description="Actualiza los datos de un servicio tur\u00edstico existente")
    public ResponseEntity<Map<String, Object>> actualizarServicio(@P(value="id") @PathVariable Long id, @Valid @P(value="servicio") @RequestBody ServicioTuristico servicio) {
        try {
            log.info("Actualizando servicio tur\u00edstico ID: {}", (Object)id);
            ServicioTuristico servicioActualizado = this.servicioService.update(id, servicio);
            ServicioResponse servicioResponse = this.servicioService.toResponse(servicioActualizado);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Servicio tur\u00edstico actualizado exitosamente");
            response.put("data", servicioResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error de validaci\u00f3n al actualizar servicio: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al actualizar servicio con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessServicio(#id)")
    @Operation(summary="Eliminar servicio tur\u00edstico", description="Elimina un servicio tur\u00edstico del sistema (soft delete)")
    public ResponseEntity<Map<String, Object>> eliminarServicio(@P(value="id") @PathVariable Long id) {
        try {
            log.info("Eliminando servicio tur\u00edstico ID: {}", (Object)id);
            this.servicioService.delete(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Servicio tur\u00edstico eliminado exitosamente");
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error al eliminar servicio: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al eliminar servicio con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping(value={"/{id}/precio"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO','ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessServicio(#id)")
    @Operation(summary="Calcular precio total", description="Calcula el precio total de un servicio para un n\u00famero de personas")
    public ResponseEntity<Map<String, Object>> calcularPrecio(@P(value="id") @PathVariable Long id, @RequestParam Integer personas) {
        try {
            log.info("Calculando precio para servicio {} y {} personas", (Object)id, (Object)personas);
            BigDecimal precioTotal = this.servicioService.calcularPrecioTotal(id, personas);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Precio calculado exitosamente");
            response.put("data", Map.of("servicioId", id, "personas", personas, "precioTotal", precioTotal));
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error al calcular precio: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al calcular precio para servicio {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @Generated
    public ServicioTuristicoController(ServicioTuristicoService servicioService) {
        this.servicioService = servicioService;
    }
}

