/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.VoucherResponse;
import com.sistema.turistico.dto.VoucherUpdateRequest;
import com.sistema.turistico.entity.Voucher;
import com.sistema.turistico.service.VoucherService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.method.P;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vouchers"})
@Tag(name="Vouchers", description="Endpoints para gesti\u00f3n de vouchers")
public class VoucherController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherController.class);
    private final VoucherService voucherService;

    @GetMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO','ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessEmpresa(#empresaId)")
    @Operation(summary="Listar vouchers", description="Obtiene la lista de vouchers con filtros opcionales")
    public ResponseEntity<Map<String, Object>> listarVouchers(@P(value="empresaId") @RequestParam(required=false) Long empresaId, @RequestParam(required=false) String busqueda, @RequestParam(required=false) Voucher.EstadoVoucher estado, @RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="10") int size) {
        try {
            log.info("Listando vouchers con filtros - empresa: {}, p\u00e1gina: {}, tama\u00f1o: {}", new Object[]{empresaId, page, size});
            VoucherService.VoucherPageResult result = this.voucherService.listarVouchers(empresaId, busqueda, estado, page, size);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Vouchers obtenidos exitosamente");
            response.put("data", result.data());
            response.put("total", result.total());
            response.put("page", result.page());
            response.put("size", result.size());
            response.put("totalPages", result.totalPages());
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Solicitud inv\u00e1lida al listar vouchers: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception e) {
            log.error("Error al listar vouchers", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping(value={"/{codigoQr}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO','ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessVoucherByCodigo(#codigoQr)")
    @Operation(summary="Obtener voucher por QR", description="Obtiene un voucher espec\u00edfico por su c\u00f3digo QR")
    public ResponseEntity<Map<String, Object>> obtenerVoucherPorQr(@P(value="codigoQr") @PathVariable String codigoQr) {
        try {
            log.info("Obteniendo voucher con c\u00f3digo QR: {}", (Object)codigoQr);
            VoucherResponse voucherResponse = this.voucherService.obtenerPorCodigoQr(codigoQr);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Voucher obtenido exitosamente");
            response.put("data", voucherResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Voucher no encontrado: {}", (Object)e.getMessage());
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            log.error("Error al obtener voucher con c\u00f3digo QR: {}", (Object)codigoQr, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @PutMapping(value={"/{codigoQr}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO','ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessVoucherByCodigo(#codigoQr)")
    @Operation(summary="Actualizar voucher", description="Actualiza el estado de un voucher espec\u00edfico")
    public ResponseEntity<Map<String, Object>> actualizarVoucher(@P(value="codigoQr") @PathVariable String codigoQr, @Valid @RequestBody VoucherUpdateRequest request) {
        try {
            log.info("Actualizando voucher con c\u00f3digo QR: {}", (Object)codigoQr);
            VoucherResponse voucherResponse = this.voucherService.actualizarEstado(codigoQr, request.getEstado());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Voucher actualizado exitosamente");
            response.put("data", voucherResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error de validaci\u00f3n al actualizar voucher: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al actualizar voucher con c\u00f3digo QR: {}", (Object)codigoQr, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @DeleteMapping(value={"/{codigoQr}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO','ADMINISTRADOR','SUPERADMINISTRADOR') and @tenantSecurity.canAccessVoucherByCodigo(#codigoQr)")
    @Operation(summary="Cancelar voucher", description="Cancela un voucher cambiando su estado a 'Cancelado'")
    public ResponseEntity<Map<String, Object>> cancelarVoucher(@P(value="codigoQr") @PathVariable String codigoQr) {
        try {
            log.info("Cancelando voucher con c\u00f3digo QR: {}", (Object)codigoQr);
            VoucherResponse voucherResponse = this.voucherService.cancelar(codigoQr);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Voucher cancelado exitosamente");
            response.put("data", voucherResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error al cancelar voucher: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al cancelar voucher con c\u00f3digo QR: {}", (Object)codigoQr, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @Generated
    public VoucherController(VoucherService voucherService) {
        this.voucherService = voucherService;
    }
}

