/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.Cliente;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ClienteRepository
extends JpaRepository<Cliente, Long> {
    public Optional<Cliente> findByEmail(String var1);

    public Optional<Cliente> findByDni(String var1);

    public boolean existsByEmail(String var1);

    public boolean existsByDni(String var1);

    @Query(value="SELECT c FROM Cliente c WHERE c.empresa.idEmpresa = :empresaId AND c.estado = true AND c.deletedAt IS NULL")
    public List<Cliente> findByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="SELECT c FROM Cliente c WHERE c.empresa.idEmpresa = :empresaId AND c.estado = true AND c.deletedAt IS NULL ORDER BY c.createdAt DESC")
    public List<Cliente> findByEmpresaIdOrderByCreatedAtDesc(@Param(value="empresaId") Long var1);

    @Query(value="SELECT c FROM Cliente c WHERE c.empresa.idEmpresa = :empresaId AND c.estado = true AND c.deletedAt IS NULL AND (LOWER(c.nombre) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(c.apellido) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(c.email) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR c.dni LIKE CONCAT('%', :busqueda, '%'))")
    public List<Cliente> findByEmpresaIdAndBusqueda(@Param(value="empresaId") Long var1, @Param(value="busqueda") String var2);

    @Query(value="SELECT COUNT(c) > 0 FROM Cliente c WHERE c.empresa.idEmpresa = :empresaId AND c.email = :email AND c.idCliente != :excludeId")
    public boolean existsByEmpresaIdAndEmailAndIdNot(@Param(value="empresaId") Long var1, @Param(value="email") String var2, @Param(value="excludeId") Long var3);

    @Query(value="SELECT COUNT(c) > 0 FROM Cliente c WHERE c.empresa.idEmpresa = :empresaId AND c.dni = :dni AND c.idCliente != :excludeId")
    public boolean existsByEmpresaIdAndDniAndIdNot(@Param(value="empresaId") Long var1, @Param(value="dni") String var2, @Param(value="excludeId") Long var3);

    @Query(value="SELECT COUNT(c) FROM Cliente c WHERE c.empresa.idEmpresa = :empresaId AND c.estado = true AND c.deletedAt IS NULL")
    public Long countByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="SELECT c.nivelMembresia, COUNT(c) FROM Cliente c WHERE c.empresa.idEmpresa = :empresaId AND c.estado = true AND c.deletedAt IS NULL GROUP BY c.nivelMembresia")
    public List<Object[]> countClientesByNivelMembresia(@Param(value="empresaId") Long var1);

    @Query(value="SELECT c.empresa.idEmpresa FROM Cliente c WHERE c.idCliente = :id")
    public Optional<Long> findEmpresaIdById(@Param(value="id") Long var1);
}

