/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.PaqueteTuristico;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PaqueteTuristicoRepository
extends JpaRepository<PaqueteTuristico, Long> {
    public List<PaqueteTuristico> findByEmpresaIdEmpresa(Long var1);

    public List<PaqueteTuristico> findByEmpresaIdEmpresaAndEstado(Long var1, Boolean var2);

    public List<PaqueteTuristico> findByEmpresaIdEmpresaOrderByCreatedAtDesc(Long var1);

    @Query(value="SELECT p FROM PaqueteTuristico p WHERE p.empresa.idEmpresa = :empresaId AND (LOWER(p.nombrePaquete) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(p.descripcion) LIKE LOWER(CONCAT('%', :busqueda, '%')))")
    public List<PaqueteTuristico> findByEmpresaIdAndBusqueda(@Param(value="empresaId") Long var1, @Param(value="busqueda") String var2);

    public List<PaqueteTuristico> findByEmpresaIdEmpresaAndPrecioTotalBetween(Long var1, BigDecimal var2, BigDecimal var3);

    public List<PaqueteTuristico> findByEmpresaIdEmpresaAndDuracionDiasBetween(Long var1, Integer var2, Integer var3);

    public List<PaqueteTuristico> findByEmpresaIdEmpresaAndPromocionAndEstado(Long var1, Boolean var2, Boolean var3);

    public boolean existsByEmpresaIdEmpresaAndNombrePaqueteAndIdPaqueteNot(Long var1, String var2, Long var3);

    public long countByEmpresaIdEmpresa(Long var1);

    public long countByEmpresaIdEmpresaAndEstado(Long var1, Boolean var2);

    @Query(value="SELECT SUM(p.precioTotal) FROM PaqueteTuristico p WHERE p.empresa.idEmpresa = :empresaId AND p.estado = true")
    public BigDecimal sumPrecioTotalByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="SELECT DISTINCT p FROM PaqueteTuristico p LEFT JOIN FETCH p.serviciosIncluidos ps LEFT JOIN FETCH ps.servicio s WHERE p.empresa.idEmpresa = :empresaId AND p.estado = true ORDER BY p.nombrePaquete")
    public List<PaqueteTuristico> findPaquetesConServiciosByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="SELECT p FROM PaqueteTuristico p WHERE p.empresa.idEmpresa = :empresaId AND p.estado = true AND p.deletedAt IS NULL AND EXISTS (SELECT 1 FROM p.serviciosIncluidos ps WHERE ps.servicio.estado = true)")
    public List<PaqueteTuristico> findPaquetesDisponiblesByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="SELECT p FROM PaqueteTuristico p WHERE p.empresa.idEmpresa = :empresaId AND p.estado = true AND (p.precioTotal - (p.precioTotal * p.descuento / 100)) BETWEEN :precioMin AND :precioMax")
    public List<PaqueteTuristico> findByEmpresaIdAndPrecioFinalBetween(@Param(value="empresaId") Long var1, @Param(value="precioMin") BigDecimal var2, @Param(value="precioMax") BigDecimal var3);

    @Query(value="SELECT p.empresa.idEmpresa FROM PaqueteTuristico p WHERE p.idPaquete = :id AND p.deletedAt IS NULL")
    public Optional<Long> findEmpresaIdById(@Param(value="id") Long var1);
}

