/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.Usuario;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface UsuarioRepository
extends JpaRepository<Usuario, Long> {
    public Optional<Usuario> findByEmail(String var1);

    public Optional<Usuario> findByDni(String var1);

    public boolean existsByEmail(String var1);

    public boolean existsByDni(String var1);

    @Query(value="SELECT u FROM Usuario u LEFT JOIN FETCH u.rol r LEFT JOIN FETCH u.empresa LEFT JOIN FETCH r.permisos WHERE u.email = :email AND u.estado = 1")
    public Optional<Usuario> findByEmailWithRolAndEmpresa(@Param(value="email") String var1);

    @Query(value="SELECT u FROM Usuario u LEFT JOIN FETCH u.permisos WHERE u.idUsuario = :idUsuario")
    public Optional<Usuario> findByIdWithPermisos(@Param(value="idUsuario") Long var1);

    @Query(value="SELECT u FROM Usuario u WHERE u.deletedAt IS NULL ORDER BY u.createdAt DESC")
    public List<Usuario> findAllActivos();

    @Query(value="SELECT u FROM Usuario u WHERE u.deletedAt IS NULL AND (:empresaId IS NULL OR u.empresa.idEmpresa = :empresaId) AND (:rolId IS NULL OR u.rol.idRol = :rolId) AND (:estado IS NULL OR u.estado = :estado) AND (:busqueda IS NULL OR LOWER(u.nombre) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(u.apellido) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(u.email) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR u.dni LIKE CONCAT('%', :busqueda, '%')) ORDER BY u.createdAt DESC")
    public List<Usuario> findByFiltros(@Param(value="busqueda") String var1, @Param(value="estado") Integer var2, @Param(value="empresaId") Long var3, @Param(value="rolId") Long var4);

    @Query(value="SELECT u FROM Usuario u LEFT JOIN FETCH u.rol LEFT JOIN FETCH u.empresa WHERE u.idUsuario = :id AND u.deletedAt IS NULL")
    public Optional<Usuario> findActivoById(@Param(value="id") Long var1);

    public boolean existsByEmailAndIdUsuarioNot(String var1, Long var2);

    public boolean existsByDniAndIdUsuarioNot(String var1, Long var2);

    @Query(value="SELECT u.empresa.idEmpresa FROM Usuario u WHERE u.idUsuario = :id AND u.deletedAt IS NULL")
    public Optional<Long> findEmpresaIdById(@Param(value="id") Long var1);
}

