/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.security;

import com.sistema.turistico.security.AuthenticatedUser;
import com.sistema.turistico.util.JwtUtil;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationFilter.class);
    private final JwtUtil jwtUtil;
    private final UserDetailsService userDetailsService;

    protected boolean shouldNotFilter(HttpServletRequest request) {
        String path = request.getRequestURI();
        return path.startsWith("/auth/") || path.equals("/health") || path.startsWith("/swagger-ui/") || path.startsWith("/v3/api-docs/");
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String username;
            UserDetails userDetails;
            String jwt = this.getJwtFromRequest(request);
            if (StringUtils.hasText((String)jwt) && this.jwtUtil.validateToken(jwt) && (userDetails = this.userDetailsService.loadUserByUsername(username = this.jwtUtil.getUsernameFromToken(jwt))) != null) {
                Long userId = this.jwtUtil.getUserIdFromToken(jwt);
                Long empresaId = this.jwtUtil.getEmpresaIdFromToken(jwt);
                AuthenticatedUser principal = AuthenticatedUser.of((Long)userId, (Long)empresaId, (UserDetails)userDetails);
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)principal, null, principal.getAuthorities());
                authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            }
        }
        catch (Exception ex) {
            log.error("No se pudo establecer la autenticaci\u00f3n del usuario en el contexto de seguridad", (Throwable)ex);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getJwtFromRequest(HttpServletRequest request) {
        String bearerToken = request.getHeader("Authorization");
        if (StringUtils.hasText((String)bearerToken) && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7);
        }
        return null;
    }

    @Generated
    public JwtAuthenticationFilter(JwtUtil jwtUtil, UserDetailsService userDetailsService) {
        this.jwtUtil = jwtUtil;
        this.userDetailsService = userDetailsService;
    }
}

