/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.security;

import com.sistema.turistico.security.TenantContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TenantAuditLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantAuditLogger.class);

    public void recordAccessAttempt(String resourceType, Object resourceId, Long currentEmpresaId, Long resourceEmpresaId, boolean allowed) {
        if (allowed || resourceType == null) {
            return;
        }
        Long currentUserId = TenantContext.getUserId().orElse(null);
        log.warn("Acceso denegado por tenant: user={} empresaActual={} recurso={} recursoId={} empresaRecurso={}", new Object[]{currentUserId, currentEmpresaId, resourceType, resourceId, resourceEmpresaId});
    }

    public void recordMissingResource(String resourceType, Object resourceId, Long currentEmpresaId) {
        Long currentUserId = TenantContext.getUserId().orElse(null);
        log.warn("Recurso no encontrado o sin empresa asociada: user={} empresaActual={} recurso={} recursoId={}", new Object[]{currentUserId, currentEmpresaId, resourceType, resourceId});
    }
}

