/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.security;

import com.sistema.turistico.entity.PaqueteTuristico;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.ServicioTuristico;
import com.sistema.turistico.repository.CajaRepository;
import com.sistema.turistico.repository.ClienteRepository;
import com.sistema.turistico.repository.PagoReservaRepository;
import com.sistema.turistico.repository.PaqueteTuristicoRepository;
import com.sistema.turistico.repository.ReservaRepository;
import com.sistema.turistico.repository.ServicioTuristicoRepository;
import com.sistema.turistico.repository.SucursalRepository;
import com.sistema.turistico.repository.UsuarioRepository;
import com.sistema.turistico.repository.VentaRepository;
import com.sistema.turistico.repository.VoucherRepository;
import com.sistema.turistico.security.TenantAuditLogger;
import com.sistema.turistico.security.TenantContext;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component(value="tenantSecurity")
public class TenantSecurity {
    private final SucursalRepository sucursalRepository;
    private final UsuarioRepository usuarioRepository;
    private final ServicioTuristicoRepository servicioTuristicoRepository;
    private final PaqueteTuristicoRepository paqueteTuristicoRepository;
    private final ReservaRepository reservaRepository;
    private final VentaRepository ventaRepository;
    private final CajaRepository cajaRepository;
    private final ClienteRepository clienteRepository;
    private final PagoReservaRepository pagoReservaRepository;
    private final VoucherRepository voucherRepository;
    private final TenantAuditLogger tenantAuditLogger;

    public boolean canAccessEmpresa(Long empresaId) {
        if (TenantContext.isSuperAdmin()) {
            return true;
        }
        Long currentEmpresaId = TenantContext.requireEmpresaId();
        return empresaId == null || Objects.equals(currentEmpresaId, empresaId);
    }

    public boolean canManageEmpresa(Long empresaId) {
        if (TenantContext.isSuperAdmin()) {
            return true;
        }
        Long currentEmpresaId = TenantContext.requireEmpresaId();
        if (empresaId == null) {
            return true;
        }
        return Objects.equals(currentEmpresaId, empresaId);
    }

    public boolean canAccessUser(Long userId) {
        if (TenantContext.isSuperAdmin()) {
            return true;
        }
        Long currentUserId = TenantContext.requireUserId();
        return userId == null || Objects.equals(currentUserId, userId);
    }

    public boolean isSuperAdmin() {
        return TenantContext.isSuperAdmin();
    }

    public boolean canAccessSucursal(Long sucursalId) {
        if (sucursalId == null || TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaActual = TenantContext.requireEmpresaId();
        return this.checkOwnership(this.sucursalRepository.findEmpresaIdById(sucursalId), empresaActual, "Sucursal", (Object)sucursalId);
    }

    public boolean canAccessUsuario(Long usuarioId) {
        if (usuarioId == null || TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaActual = TenantContext.requireEmpresaId();
        return this.checkOwnership(this.usuarioRepository.findEmpresaIdById(usuarioId), empresaActual, "Usuario", (Object)usuarioId);
    }

    public boolean canManageServicio(ServicioTuristico servicio) {
        if (TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaId = null;
        if (servicio != null && servicio.getEmpresa() != null) {
            empresaId = servicio.getEmpresa().getIdEmpresa();
        }
        return this.canManageEmpresa(empresaId);
    }

    public boolean canAccessServicio(Long servicioId) {
        if (servicioId == null || TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaActual = TenantContext.requireEmpresaId();
        return this.checkOwnership(this.servicioTuristicoRepository.findEmpresaIdById(servicioId), empresaActual, "ServicioTuristico", (Object)servicioId);
    }

    public boolean canManagePaquete(PaqueteTuristico paquete) {
        if (TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaId = null;
        if (paquete != null && paquete.getEmpresa() != null) {
            empresaId = paquete.getEmpresa().getIdEmpresa();
        }
        return this.canManageEmpresa(empresaId);
    }

    public boolean canAccessPaquete(Long paqueteId) {
        if (paqueteId == null || TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaActual = TenantContext.requireEmpresaId();
        return this.checkOwnership(this.paqueteTuristicoRepository.findEmpresaIdById(paqueteId), empresaActual, "PaqueteTuristico", (Object)paqueteId);
    }

    public boolean canManageReserva(Reserva reserva) {
        if (TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaId = null;
        if (reserva != null && reserva.getEmpresa() != null) {
            empresaId = reserva.getEmpresa().getIdEmpresa();
        }
        return this.canManageEmpresa(empresaId);
    }

    public boolean canAccessReserva(Long reservaId) {
        if (reservaId == null || TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaActual = TenantContext.requireEmpresaId();
        return this.checkOwnership(this.reservaRepository.findEmpresaIdById(reservaId), empresaActual, "Reserva", (Object)reservaId);
    }

    public boolean canAccessVenta(Long ventaId) {
        if (ventaId == null || TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaActual = TenantContext.requireEmpresaId();
        return this.checkOwnership(this.ventaRepository.findEmpresaIdById(ventaId), empresaActual, "Venta", (Object)ventaId);
    }

    public boolean canAccessCaja(Long cajaId) {
        if (cajaId == null || TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaActual = TenantContext.requireEmpresaId();
        return this.checkOwnership(this.cajaRepository.findEmpresaIdById(cajaId), empresaActual, "Caja", (Object)cajaId);
    }

    public boolean canAccessCliente(Long clienteId) {
        if (clienteId == null || TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaActual = TenantContext.requireEmpresaId();
        return this.checkOwnership(this.clienteRepository.findEmpresaIdById(clienteId), empresaActual, "Cliente", (Object)clienteId);
    }

    public boolean canAccessPago(Long pagoId) {
        if (pagoId == null || TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaActual = TenantContext.requireEmpresaId();
        return this.checkOwnership(this.pagoReservaRepository.findEmpresaIdById(pagoId), empresaActual, "PagoReserva", (Object)pagoId);
    }

    public boolean canAccessVoucherByCodigo(String codigoQr) {
        if (codigoQr == null || TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaActual = TenantContext.requireEmpresaId();
        return this.checkOwnership(this.voucherRepository.findEmpresaIdByCodigoQr(codigoQr), empresaActual, "Voucher", (Object)codigoQr);
    }

    private boolean checkOwnership(Optional<Long> resourceEmpresaId, Long currentEmpresaId, String resourceType, Object resourceId) {
        if (resourceEmpresaId.isEmpty()) {
            this.tenantAuditLogger.recordMissingResource(resourceType, resourceId, currentEmpresaId);
            return false;
        }
        boolean allowed = Objects.equals(currentEmpresaId, resourceEmpresaId.get());
        this.tenantAuditLogger.recordAccessAttempt(resourceType, resourceId, currentEmpresaId, resourceEmpresaId.get(), allowed);
        return allowed;
    }

    @Generated
    public TenantSecurity(SucursalRepository sucursalRepository, UsuarioRepository usuarioRepository, ServicioTuristicoRepository servicioTuristicoRepository, PaqueteTuristicoRepository paqueteTuristicoRepository, ReservaRepository reservaRepository, VentaRepository ventaRepository, CajaRepository cajaRepository, ClienteRepository clienteRepository, PagoReservaRepository pagoReservaRepository, VoucherRepository voucherRepository, TenantAuditLogger tenantAuditLogger) {
        this.sucursalRepository = sucursalRepository;
        this.usuarioRepository = usuarioRepository;
        this.servicioTuristicoRepository = servicioTuristicoRepository;
        this.paqueteTuristicoRepository = paqueteTuristicoRepository;
        this.reservaRepository = reservaRepository;
        this.ventaRepository = ventaRepository;
        this.cajaRepository = cajaRepository;
        this.clienteRepository = clienteRepository;
        this.pagoReservaRepository = pagoReservaRepository;
        this.voucherRepository = voucherRepository;
        this.tenantAuditLogger = tenantAuditLogger;
    }
}

