/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.AsignacionPersonal;
import java.sql.Date;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface AsignacionPersonalRepository
extends JpaRepository<AsignacionPersonal, Long> {
    @Query(value="SELECT a FROM AsignacionPersonal a WHERE a.reserva.idReserva = :reservaId")
    public List<AsignacionPersonal> findByReservaId(@Param(value="reservaId") Long var1);

    @Query(value="SELECT a FROM AsignacionPersonal a WHERE a.personal.idPersonal = :personalId")
    public List<AsignacionPersonal> findByPersonalId(@Param(value="personalId") Long var1);

    @Query(value="SELECT a FROM AsignacionPersonal a WHERE a.fechaAsignacion = :fecha")
    public List<AsignacionPersonal> findByFechaAsignacion(@Param(value="fecha") Date var1);

    @Query(value="SELECT a FROM AsignacionPersonal a WHERE a.fechaAsignacion BETWEEN :fechaInicio AND :fechaFin")
    public List<AsignacionPersonal> findByFechaAsignacionBetween(@Param(value="fechaInicio") Date var1, @Param(value="fechaFin") Date var2);

    @Query(value="SELECT a FROM AsignacionPersonal a WHERE a.estado = :estado")
    public List<AsignacionPersonal> findByEstado(@Param(value="estado") AsignacionPersonal.EstadoAsignacion var1);

    @Query(value="SELECT COUNT(a) > 0 FROM AsignacionPersonal a WHERE a.personal.idPersonal = :personalId AND a.fechaAsignacion = :fecha AND a.estado = 'Asignado'")
    public boolean existsByPersonalAndFecha(@Param(value="personalId") Long var1, @Param(value="fecha") Date var2);

    @Query(value="SELECT COUNT(a) FROM AsignacionPersonal a WHERE a.personal.idPersonal = :personalId AND a.estado = 'Asignado'")
    public Long countAsignacionesActivasByPersonal(@Param(value="personalId") Long var1);
}

