/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.MovimientoCajaRequest;
import com.sistema.turistico.dto.PagoReservaRequest;
import com.sistema.turistico.entity.Caja;
import com.sistema.turistico.entity.MovimientoCaja;
import com.sistema.turistico.entity.PagoReserva;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.Usuario;
import com.sistema.turistico.repository.PagoReservaRepository;
import com.sistema.turistico.service.CajaService;
import com.sistema.turistico.service.ReservaService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PagoReservaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PagoReservaService.class);
    private static final Set<String> METODOS_VALIDOS = Set.of("Efectivo", "Tarjeta Cr\u00e9dito", "Tarjeta D\u00e9bito", "Transferencia", "Yape/Plin", "Otros");
    private final PagoReservaRepository pagoReservaRepository;
    private final ReservaService reservaService;
    private final CajaService cajaService;
    @PersistenceContext
    private EntityManager entityManager;

    public PagoReserva registrarPago(Long reservaId, PagoReservaRequest request) {
        log.info("Registrando pago para reserva {} por usuario {}", (Object)reservaId, (Object)request.getUsuarioId());
        this.validarMetodoPago(request.getMetodoPago());
        Reserva reserva = (Reserva)this.reservaService.findById(reservaId).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        Caja caja = this.cajaService.obtenerCajaActiva(request.getCajaId());
        if (!reserva.getEmpresa().getIdEmpresa().equals(caja.getEmpresa().getIdEmpresa())) {
            throw new IllegalArgumentException("La caja seleccionada no pertenece a la misma empresa de la reserva");
        }
        BigDecimal totalReserva = reserva.getPrecioFinal();
        BigDecimal acumuladoAnterior = this.pagoReservaRepository.sumMontosActivosPorReserva(reservaId);
        BigDecimal saldoPendiente = totalReserva.subtract(acumuladoAnterior);
        if (request.getMontoPagado().compareTo(saldoPendiente) > 0) {
            throw new IllegalArgumentException("El monto excede el saldo pendiente de la reserva");
        }
        PagoReserva pago = new PagoReserva();
        pago.setReserva(reserva);
        pago.setUsuario((Usuario)this.entityManager.getReference(Usuario.class, (Object)request.getUsuarioId()));
        pago.setMontoPagado(request.getMontoPagado());
        pago.setMetodoPago(this.normalizarMetodoPago(request.getMetodoPago()));
        pago.setNumeroOperacion(request.getNumeroOperacion());
        pago.setComprobante(request.getComprobante());
        pago.setFechaPago(request.getFechaPago());
        pago.setObservaciones(request.getObservaciones());
        pago.setEstado(Boolean.TRUE);
        PagoReserva pagoGuardado = (PagoReserva)this.pagoReservaRepository.save((Object)pago);
        MovimientoCajaRequest movimientoRequest = new MovimientoCajaRequest();
        movimientoRequest.setTipoMovimiento(MovimientoCaja.TipoMovimiento.Ingreso);
        movimientoRequest.setMonto(pagoGuardado.getMontoPagado());
        movimientoRequest.setDescripcion("Ingreso por pago de reserva " + reserva.getCodigoReserva());
        this.cajaService.registrarMovimiento(caja.getIdCaja(), movimientoRequest);
        BigDecimal totalPagado = acumuladoAnterior.add(pagoGuardado.getMontoPagado());
        Reserva.EstadoReserva nuevoEstado = this.determinarEstadoFinanciero(totalReserva, totalPagado);
        this.reservaService.actualizarEstadoFinanciero(reserva, nuevoEstado);
        return pagoGuardado;
    }

    @Transactional(readOnly=true)
    public List<PagoReserva> listarPagosReserva(Long reservaId) {
        return this.pagoReservaRepository.findByReserva_IdReservaOrderByFechaPagoAsc(reservaId);
    }

    @Transactional(readOnly=true)
    public List<PagoReserva> listarPagosActivosReserva(Long reservaId) {
        return this.pagoReservaRepository.findByReserva_IdReservaAndEstadoTrueOrderByFechaPagoAsc(reservaId);
    }

    @Transactional(readOnly=true)
    public List<PagoReserva> listarPagosPorFiltros(Long empresaId, String metodoPago, Boolean estado, LocalDate fechaDesde, LocalDate fechaHasta) {
        String metodoNormalizado;
        String string = metodoNormalizado = metodoPago != null ? this.normalizarMetodoPago(metodoPago) : null;
        if (metodoNormalizado != null) {
            this.validarMetodoPago(metodoNormalizado);
        }
        if (fechaDesde != null && fechaHasta != null && fechaHasta.isBefore(fechaDesde)) {
            throw new IllegalArgumentException("El rango de fechas es inv\u00e1lido");
        }
        return this.pagoReservaRepository.findByFiltros(empresaId, metodoNormalizado, estado, fechaDesde, fechaHasta);
    }

    public PagoReserva anularPago(Long reservaId, Long pagoId, Long cajaId, String motivo) {
        log.info("Anulando pago {} de reserva {}", (Object)pagoId, (Object)reservaId);
        Caja caja = this.cajaService.obtenerCajaActiva(cajaId);
        PagoReserva pago = (PagoReserva)this.pagoReservaRepository.findByIdPagoAndReserva_IdReservaAndEstadoTrue(pagoId, reservaId).orElseThrow(() -> new IllegalArgumentException("El pago indicado no est\u00e1 activo"));
        if (!pago.getReserva().getEmpresa().getIdEmpresa().equals(caja.getEmpresa().getIdEmpresa())) {
            throw new IllegalArgumentException("La caja seleccionada no pertenece a la empresa de la reserva");
        }
        pago.setEstado(Boolean.FALSE);
        if (motivo != null && !motivo.isBlank()) {
            String observaciones = pago.getObservaciones();
            String anotacion = "Anulado: " + motivo + " (" + String.valueOf(LocalDateTime.now()) + ")";
            pago.setObservaciones(observaciones == null ? anotacion : observaciones + " | " + anotacion);
        }
        PagoReserva pagoAnulado = (PagoReserva)this.pagoReservaRepository.save((Object)pago);
        MovimientoCajaRequest movimientoRequest = new MovimientoCajaRequest();
        movimientoRequest.setTipoMovimiento(MovimientoCaja.TipoMovimiento.Egreso);
        movimientoRequest.setMonto(pagoAnulado.getMontoPagado());
        movimientoRequest.setDescripcion("Reverso pago reserva " + pago.getReserva().getCodigoReserva());
        this.cajaService.registrarMovimiento(caja.getIdCaja(), movimientoRequest);
        BigDecimal totalPagado = this.pagoReservaRepository.sumMontosActivosPorReserva(reservaId);
        BigDecimal totalReserva = pago.getReserva().getPrecioFinal();
        Reserva.EstadoReserva nuevoEstado = this.determinarEstadoFinanciero(totalReserva, totalPagado);
        this.reservaService.actualizarEstadoFinanciero(pago.getReserva(), nuevoEstado);
        return pagoAnulado;
    }

    @Transactional(readOnly=true)
    public PagoReserva obtenerPago(Long pagoId) {
        return (PagoReserva)this.pagoReservaRepository.findById((Object)pagoId).orElseThrow(() -> new IllegalArgumentException("Pago no encontrado"));
    }

    public PagoReserva actualizarPago(Long pagoId, PagoReservaRequest request) {
        log.info("Actualizando pago {}", (Object)pagoId);
        PagoReserva pago = (PagoReserva)this.pagoReservaRepository.findById((Object)pagoId).orElseThrow(() -> new IllegalArgumentException("Pago no encontrado"));
        if (request.getMetodoPago() != null) {
            this.validarMetodoPago(request.getMetodoPago());
            pago.setMetodoPago(this.normalizarMetodoPago(request.getMetodoPago()));
        }
        if (request.getNumeroOperacion() != null) {
            pago.setNumeroOperacion(request.getNumeroOperacion());
        }
        if (request.getComprobante() != null) {
            pago.setComprobante(request.getComprobante());
        }
        if (request.getFechaPago() != null) {
            pago.setFechaPago(request.getFechaPago());
        }
        if (request.getObservaciones() != null) {
            pago.setObservaciones(request.getObservaciones());
        }
        return (PagoReserva)this.pagoReservaRepository.save((Object)pago);
    }

    @Transactional(readOnly=true)
    public BigDecimal obtenerSaldoPendiente(Long reservaId) {
        Reserva reserva = (Reserva)this.reservaService.findById(reservaId).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        BigDecimal pagado = this.pagoReservaRepository.sumMontosActivosPorReserva(reservaId);
        return reserva.getPrecioFinal().subtract(pagado);
    }

    private Reserva.EstadoReserva determinarEstadoFinanciero(BigDecimal totalReserva, BigDecimal totalPagado) {
        if (totalPagado.compareTo(BigDecimal.ZERO) <= 0) {
            return Reserva.EstadoReserva.Confirmada;
        }
        if (totalPagado.compareTo(totalReserva) >= 0) {
            return Reserva.EstadoReserva.Pagada;
        }
        return Reserva.EstadoReserva.PagoParcial;
    }

    private void validarMetodoPago(String metodo) {
        if (metodo == null || metodo.trim().isEmpty()) {
            throw new IllegalArgumentException("El m\u00e9todo de pago es obligatorio");
        }
        String metodoNormalizado = this.normalizarMetodoPago(metodo);
        if (!METODOS_VALIDOS.contains(metodoNormalizado)) {
            throw new IllegalArgumentException("M\u00e9todo de pago no soportado: " + metodo + ". M\u00e9todos v\u00e1lidos: " + String.valueOf(METODOS_VALIDOS));
        }
    }

    private String normalizarMetodoPago(String metodoPago) {
        if (metodoPago == null) {
            return null;
        }
        String trimmed = metodoPago.trim();
        if (trimmed.length() > 1) {
            return trimmed.substring(0, 1).toUpperCase() + trimmed.substring(1).toLowerCase();
        }
        return trimmed.toUpperCase();
    }

    @Generated
    public PagoReservaService(PagoReservaRepository pagoReservaRepository, ReservaService reservaService, CajaService cajaService) {
        this.pagoReservaRepository = pagoReservaRepository;
        this.reservaService = reservaService;
        this.cajaService = cajaService;
    }
}

