/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.entity.Personal;
import com.sistema.turistico.repository.PersonalRepository;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PersonalService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PersonalService.class);
    private final PersonalRepository personalRepository;

    @Transactional
    public Personal crearPersonal(Personal personal) {
        log.info("Creando nuevo personal: {} {}", (Object)personal.getNombre(), (Object)personal.getApellido());
        if (this.personalRepository.findByDniAndEmpresaId(personal.getDni(), personal.getEmpresa().getIdEmpresa()).isPresent()) {
            throw new IllegalArgumentException("Ya existe personal con este DNI en la empresa");
        }
        if (personal.getEmail() != null && !personal.getEmail().trim().isEmpty() && this.personalRepository.findByEmailAndEmpresaId(personal.getEmail(), personal.getEmpresa().getIdEmpresa()).isPresent()) {
            throw new IllegalArgumentException("Ya existe personal con este email en la empresa");
        }
        return (Personal)this.personalRepository.save((Object)personal);
    }

    @Transactional(readOnly=true)
    public Optional<Personal> obtenerPersonalPorId(Long id) {
        return this.personalRepository.findById((Object)id);
    }

    @Transactional(readOnly=true)
    public List<Personal> listarPersonalPorEmpresa(Long empresaId) {
        return this.personalRepository.findByEmpresaId(empresaId);
    }

    @Transactional(readOnly=true)
    public List<Personal> listarPersonalConFiltros(Long empresaId, Long sucursalId, Personal.Cargo cargo, Boolean estado, String busqueda) {
        return this.personalRepository.findWithFilters(empresaId, sucursalId, cargo, estado, busqueda);
    }

    @Transactional
    public Personal actualizarPersonal(Long id, Personal personalActualizado) {
        log.info("Actualizando personal ID: {}", (Object)id);
        Personal personalExistente = (Personal)this.personalRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Personal no encontrado"));
        if (!personalExistente.getDni().equals(personalActualizado.getDni()) && this.personalRepository.existsByDniAndEmpresaIdAndIdNot(personalActualizado.getDni(), personalExistente.getEmpresa().getIdEmpresa(), id)) {
            throw new IllegalArgumentException("Ya existe personal con este DNI en la empresa");
        }
        if (personalActualizado.getEmail() != null && !personalActualizado.getEmail().trim().isEmpty() && !personalActualizado.getEmail().equals(personalExistente.getEmail()) && this.personalRepository.existsByEmailAndEmpresaIdAndIdNot(personalActualizado.getEmail(), personalExistente.getEmpresa().getIdEmpresa(), id)) {
            throw new IllegalArgumentException("Ya existe personal con este email en la empresa");
        }
        personalExistente.setNombre(personalActualizado.getNombre());
        personalExistente.setApellido(personalActualizado.getApellido());
        personalExistente.setDni(personalActualizado.getDni());
        personalExistente.setFechaNacimiento(personalActualizado.getFechaNacimiento());
        personalExistente.setTelefono(personalActualizado.getTelefono());
        personalExistente.setEmail(personalActualizado.getEmail());
        personalExistente.setDireccion(personalActualizado.getDireccion());
        personalExistente.setCargo(personalActualizado.getCargo());
        personalExistente.setFechaIngreso(personalActualizado.getFechaIngreso());
        personalExistente.setTurno(personalActualizado.getTurno());
        personalExistente.setSueldo(personalActualizado.getSueldo());
        personalExistente.setFoto(personalActualizado.getFoto());
        personalExistente.setEstado(personalActualizado.getEstado());
        personalExistente.setSucursal(personalActualizado.getSucursal());
        return (Personal)this.personalRepository.save((Object)personalExistente);
    }

    @Transactional
    public void eliminarPersonal(Long id) {
        log.info("Desactivando personal ID: {}", (Object)id);
        Personal personal = (Personal)this.personalRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Personal no encontrado"));
        personal.setEstado(Boolean.valueOf(false));
        this.personalRepository.save((Object)personal);
    }

    @Transactional(readOnly=true)
    public List<Personal> obtenerPersonalPorCargo(Long empresaId, Personal.Cargo cargo) {
        return this.personalRepository.findByCargoAndEmpresaId(cargo, empresaId);
    }

    @Transactional(readOnly=true)
    public Long contarPersonalActivo(Long empresaId) {
        return this.personalRepository.countActivoByEmpresaId(empresaId);
    }

    @Generated
    public PersonalService(PersonalRepository personalRepository) {
        this.personalRepository = personalRepository;
    }
}

