/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.ReservaResponse;
import com.sistema.turistico.dto.ReservaUpdateRequest;
import com.sistema.turistico.dto.VoucherResponse;
import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.ServicioTuristico;
import com.sistema.turistico.entity.Voucher;
import com.sistema.turistico.repository.ReservaRepository;
import com.sistema.turistico.service.ClienteService;
import com.sistema.turistico.service.ServicioTuristicoService;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ReservaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReservaService.class);
    private final ReservaRepository reservaRepository;
    private final ClienteService clienteService;
    private final ServicioTuristicoService servicioService;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sistema$turistico$entity$Reserva$EstadoReserva;

    public Reserva create(Reserva reserva) {
        log.info("Creando nueva reserva para cliente ID: {}", (Object)reserva.getCliente().getIdCliente());
        Cliente cliente = (Cliente)this.clienteService.findById(reserva.getCliente().getIdCliente()).orElseThrow(() -> new IllegalArgumentException("Cliente no encontrado"));
        if (!cliente.isActivo()) {
            throw new IllegalArgumentException("El cliente no est\u00e1 activo");
        }
        if (reserva.getServicio() == null && reserva.getIdPaquete() == null) {
            throw new IllegalArgumentException("Debe especificar un servicio o paquete para la reserva");
        }
        if (reserva.getServicio() != null && reserva.getIdPaquete() != null) {
            throw new IllegalArgumentException("No puede especificar tanto servicio como paquete");
        }
        if (reserva.getServicio() != null) {
            ServicioTuristico servicio = (ServicioTuristico)this.servicioService.findById(reserva.getServicio().getIdServicio()).orElseThrow(() -> new IllegalArgumentException("Servicio no encontrado"));
            if (!servicio.isActivo()) {
                throw new IllegalArgumentException("El servicio no est\u00e1 disponible");
            }
            if (!servicio.tieneDisponibilidad(reserva.getNumeroPersonas())) {
                throw new IllegalArgumentException("No hay capacidad suficiente para el n\u00famero de personas solicitado");
            }
            reserva.setPrecioTotal(servicio.calcularPrecioTotal(reserva.getNumeroPersonas()));
        }
        this.validarFechas(reserva);
        reserva.setCodigoReserva(this.generarCodigoReserva());
        if (this.reservaRepository.existsByEmpresaIdAndCodigoReservaAndIdNot(reserva.getEmpresa().getIdEmpresa(), reserva.getCodigoReserva(), Long.valueOf(0L))) {
            throw new IllegalArgumentException("Error interno: c\u00f3digo de reserva duplicado, intente nuevamente");
        }
        if (reserva.getIdPromocion() != null) {
            reserva.setDescuentoAplicado(BigDecimal.ZERO);
        }
        reserva.setEstado(Reserva.EstadoReserva.Pendiente);
        reserva.setEvaluada(Boolean.valueOf(false));
        Reserva savedReserva = (Reserva)this.reservaRepository.save((Object)reserva);
        log.info("Reserva creada exitosamente con c\u00f3digo: {}", (Object)savedReserva.getCodigoReserva());
        return savedReserva;
    }

    @Transactional(readOnly=true)
    public Optional<Reserva> findById(Long id) {
        log.debug("Buscando reserva con ID: {}", (Object)id);
        return this.reservaRepository.findById((Object)id);
    }

    @Transactional(readOnly=true)
    public List<Reserva> findByEmpresaId(Long empresaId) {
        log.debug("Listando reservas de empresa ID: {}", (Object)empresaId);
        return this.reservaRepository.findByEmpresaId(empresaId);
    }

    @Transactional(readOnly=true)
    public List<Reserva> findByEmpresaIdAndClienteId(Long empresaId, Long clienteId) {
        log.debug("Listando reservas de empresa {} y cliente {}", (Object)empresaId, (Object)clienteId);
        return this.reservaRepository.findByEmpresaIdAndClienteId(empresaId, clienteId);
    }

    @Transactional(readOnly=true)
    public List<Reserva> findByEmpresaIdAndEstado(Long empresaId, Reserva.EstadoReserva estado) {
        log.debug("Listando reservas de empresa {} con estado {}", (Object)empresaId, (Object)estado);
        return this.reservaRepository.findByEmpresaIdAndEstado(empresaId, estado);
    }

    @Transactional(readOnly=true)
    public List<Reserva> findByEmpresaIdAndBusqueda(Long empresaId, String busqueda) {
        log.debug("Buscando reservas en empresa {} con t\u00e9rmino: {}", (Object)empresaId, (Object)busqueda);
        if (busqueda == null || busqueda.trim().isEmpty()) {
            return this.reservaRepository.findByEmpresaIdOrderByCreatedAtDesc(empresaId);
        }
        return this.reservaRepository.findByEmpresaIdAndBusqueda(empresaId, busqueda.trim());
    }

    public Reserva update(Long id, ReservaUpdateRequest request) {
        log.info("Actualizando reserva ID: {}", (Object)id);
        Reserva reservaExistente = (Reserva)this.reservaRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        if (!reservaExistente.isActiva()) {
            throw new IllegalArgumentException("No se puede modificar una reserva cancelada o completada");
        }
        if (request.getEstado() == null && request.getObservaciones() == null) {
            throw new IllegalArgumentException("Debe proporcionar al menos un campo para actualizar");
        }
        if (request.getObservaciones() != null) {
            reservaExistente.setObservaciones(request.getObservaciones());
        }
        if (request.getEstado() != null && request.getEstado() != reservaExistente.getEstado()) {
            this.validarCambioEstado(reservaExistente.getEstado(), request.getEstado());
            reservaExistente.setEstado(request.getEstado());
        }
        Reserva updatedReserva = (Reserva)this.reservaRepository.save((Object)reservaExistente);
        log.info("Reserva actualizada exitosamente: {}", (Object)updatedReserva.getIdReserva());
        return updatedReserva;
    }

    public ReservaResponse toResponse(Reserva reserva) {
        ReservaResponse response = new ReservaResponse();
        response.setIdReserva(reserva.getIdReserva());
        response.setCodigoReserva(reserva.getCodigoReserva());
        response.setFechaReserva(reserva.getFechaReserva() != null ? reserva.getFechaReserva().toString() : null);
        response.setFechaServicio(reserva.getFechaServicio() != null ? reserva.getFechaServicio().toString() : null);
        response.setNumeroPersonas(reserva.getNumeroPersonas());
        response.setPrecioTotal(reserva.getPrecioTotal());
        response.setDescuentoAplicado(reserva.getDescuentoAplicado());
        response.setEstado(reserva.getEstado().toString());
        response.setObservaciones(reserva.getObservaciones());
        response.setEvaluada(reserva.getEvaluada());
        response.setCreatedAt(reserva.getCreatedAt());
        response.setUpdatedAt(reserva.getUpdatedAt());
        if (reserva.getCliente() != null) {
            response.setIdCliente(reserva.getCliente().getIdCliente());
            response.setNombreCliente(reserva.getCliente().getNombre());
            response.setApellidoCliente(reserva.getCliente().getApellido());
            response.setEmailCliente(reserva.getCliente().getEmail());
        }
        if (reserva.getServicio() != null) {
            response.setIdServicio(reserva.getServicio().getIdServicio());
            response.setNombreServicio(reserva.getServicio().getNombreServicio());
            response.setTipoServicio(reserva.getServicio().getTipoServicio() != null ? reserva.getServicio().getTipoServicio().toString() : null);
        }
        if (reserva.getUsuario() != null) {
            response.setIdUsuario(reserva.getUsuario().getIdUsuario());
            response.setNombreUsuario(reserva.getUsuario().getNombre());
            response.setApellidoUsuario(reserva.getUsuario().getApellido());
        }
        return response;
    }

    public VoucherResponse toVoucherResponse(Voucher voucher) {
        VoucherResponse response = new VoucherResponse();
        response.setIdVoucher(voucher.getIdVoucher());
        response.setCodigoQr(voucher.getCodigoQr());
        response.setFechaEmision(voucher.getFechaEmision() != null ? voucher.getFechaEmision().toString() : null);
        response.setFechaExpiracion(voucher.getFechaExpiracion() != null ? voucher.getFechaExpiracion().toString() : null);
        response.setEstado(voucher.getEstado().toString());
        response.setCreatedAt(voucher.getCreatedAt());
        response.setUpdatedAt(voucher.getUpdatedAt());
        if (voucher.getReserva() != null) {
            Reserva reserva = voucher.getReserva();
            response.setIdReserva(reserva.getIdReserva());
            response.setCodigoReserva(reserva.getCodigoReserva());
            response.setFechaServicio(reserva.getFechaServicio() != null ? reserva.getFechaServicio().toString() : null);
            response.setNumeroPersonas(reserva.getNumeroPersonas());
            if (reserva.getCliente() != null) {
                response.setIdCliente(reserva.getCliente().getIdCliente());
                response.setNombreCliente(reserva.getCliente().getNombre());
                response.setApellidoCliente(reserva.getCliente().getApellido());
                response.setEmailCliente(reserva.getCliente().getEmail());
            }
            if (reserva.getServicio() != null) {
                response.setIdServicio(reserva.getServicio().getIdServicio());
                response.setNombreServicio(reserva.getServicio().getNombreServicio());
                response.setTipoServicio(reserva.getServicio().getTipoServicio() != null ? reserva.getServicio().getTipoServicio().toString() : null);
            }
        }
        return response;
    }

    public Reserva cancel(Long id) {
        log.info("Cancelando reserva ID: {}", (Object)id);
        Reserva reserva = (Reserva)this.reservaRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        if (!reserva.puedeCancelarse()) {
            throw new IllegalArgumentException("La reserva no puede ser cancelada");
        }
        reserva.setEstado(Reserva.EstadoReserva.Cancelada);
        Reserva cancelledReserva = (Reserva)this.reservaRepository.save((Object)reserva);
        log.info("Reserva cancelada exitosamente: {}", (Object)cancelledReserva.getIdReserva());
        return cancelledReserva;
    }

    public void delete(Long id) {
        log.info("Eliminando reserva ID: {} (soft delete)", (Object)id);
        Reserva reserva = (Reserva)this.reservaRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        if (reserva.getEstado() == Reserva.EstadoReserva.Completada) {
            throw new IllegalArgumentException("No se puede eliminar una reserva completada");
        }
        reserva.setDeletedAt(LocalDateTime.now());
        this.reservaRepository.save((Object)reserva);
        log.info("Reserva eliminada exitosamente: {}", (Object)id);
    }

    public Reserva completar(Long id) {
        log.info("Completando reserva ID {}", (Object)id);
        Reserva reserva = (Reserva)this.reservaRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        if (reserva.getEstado() != Reserva.EstadoReserva.Pagada) {
            throw new IllegalArgumentException("Solo se pueden completar reservas pagadas");
        }
        reserva.setEstado(Reserva.EstadoReserva.Completada);
        Reserva completedReserva = (Reserva)this.reservaRepository.save((Object)reserva);
        log.info("Reserva completada exitosamente: {}", (Object)completedReserva.getIdReserva());
        return completedReserva;
    }

    public Reserva marcarComoEvaluada(Long id) {
        log.info("Marcando reserva ID {} como evaluada", (Object)id);
        Reserva reserva = (Reserva)this.reservaRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        if (!reserva.puedeEvaluarse()) {
            throw new IllegalArgumentException("La reserva no puede ser evaluada");
        }
        reserva.setEvaluada(Boolean.valueOf(true));
        Reserva evaluatedReserva = (Reserva)this.reservaRepository.save((Object)reserva);
        log.info("Reserva marcada como evaluada: {}", (Object)evaluatedReserva.getIdReserva());
        return evaluatedReserva;
    }

    private String generarCodigoReserva() {
        return "RES-" + UUID.randomUUID().toString().substring(0, 8).toUpperCase();
    }

    private void validarFechas(Reserva reserva) {
        LocalDate hoy = LocalDate.now();
        LocalDate fechaServicio = reserva.getFechaServicio().toLocalDate();
        if (fechaServicio.isBefore(hoy)) {
            throw new IllegalArgumentException("La fecha de servicio no puede ser anterior a hoy");
        }
        LocalDate fechaReserva = reserva.getFechaReserva().toLocalDate();
        if (fechaReserva.isAfter(hoy.plusYears(1L))) {
            throw new IllegalArgumentException("La fecha de reserva no puede ser m\u00e1s de 1 a\u00f1o en el futuro");
        }
    }

    /*
     * Exception decompiling
     */
    private void validarCambioEstado(Reserva.EstadoReserva estadoActual, Reserva.EstadoReserva estadoNuevo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Reserva actualizarEstadoFinanciero(Reserva reserva, Reserva.EstadoReserva nuevoEstado) {
        this.validarCambioEstado(reserva.getEstado(), nuevoEstado);
        reserva.setEstado(nuevoEstado);
        return (Reserva)this.reservaRepository.save((Object)reserva);
    }

    public Reserva actualizarEstadoFinanciero(Long reservaId, Reserva.EstadoReserva nuevoEstado) {
        Reserva reserva = (Reserva)this.reservaRepository.findById((Object)reservaId).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        return this.actualizarEstadoFinanciero(reserva, nuevoEstado);
    }

    @Transactional(readOnly=true)
    public Long countByEmpresaId(Long empresaId) {
        return this.reservaRepository.countByEmpresaId(empresaId);
    }

    @Transactional(readOnly=true)
    public List<Reserva> findReservasProximas(Long empresaId) {
        Date hoy = Date.valueOf(LocalDate.now());
        Date enUnaSemana = Date.valueOf(LocalDate.now().plusDays(7L));
        return this.reservaRepository.findReservasProximas(empresaId, hoy, enUnaSemana);
    }

    @Generated
    public ReservaService(ReservaRepository reservaRepository, ClienteService clienteService, ServicioTuristicoService servicioService) {
        this.reservaRepository = reservaRepository;
        this.clienteService = clienteService;
        this.servicioService = servicioService;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sistema$turistico$entity$Reserva$EstadoReserva() {
        if ($SWITCH_TABLE$com$sistema$turistico$entity$Reserva$EstadoReserva != null) {
            return $SWITCH_TABLE$com$sistema$turistico$entity$Reserva$EstadoReserva;
        }
        int[] nArray = new int[Reserva.EstadoReserva.values().length];
        try {
            nArray[Reserva.EstadoReserva.Cancelada.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Reserva.EstadoReserva.Completada.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Reserva.EstadoReserva.Confirmada.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Reserva.EstadoReserva.Pagada.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Reserva.EstadoReserva.PagoParcial.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Reserva.EstadoReserva.Pendiente.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sistema$turistico$entity$Reserva$EstadoReserva = nArray;
        return nArray;
    }
}

