/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Caja;
import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.Usuario;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="ventas")
public class Venta {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_venta")
    private Long idVenta;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa", nullable=false)
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_cliente")
    private Cliente cliente;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_reserva")
    private Reserva reserva;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_usuario", nullable=false)
    private Usuario usuario;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_caja", nullable=false)
    private Caja caja;
    @Column(name="fecha_hora", nullable=false)
    private LocalDateTime fechaHora;
    @NotNull
    @DecimalMin(value="0.01", message="El monto total debe ser mayor a 0")
    @Digits(integer=10, fraction=2)
    @Column(name="monto_total", nullable=false, precision=10, scale=2)
    private @NotNull @DecimalMin(value="0.01", message="El monto total debe ser mayor a 0") @Digits(integer=10, fraction=2) BigDecimal montoTotal;
    @Column(name="metodo_pago", nullable=false, length=50)
    private String metodoPago;
    @Column(name="numero_operacion", length=100)
    private String numeroOperacion;
    @Column(name="comprobante", length=100)
    private String comprobante;
    @Digits(integer=10, fraction=2)
    @Column(name="descuento", precision=10, scale=2)
    private @Digits(integer=10, fraction=2) BigDecimal descuento = BigDecimal.ZERO;
    @Digits(integer=10, fraction=2)
    @Column(name="propina", precision=10, scale=2)
    private @Digits(integer=10, fraction=2) BigDecimal propina = BigDecimal.ZERO;
    @Column(name="observaciones", columnDefinition="TEXT")
    private String observaciones;
    @Column(name="estado", nullable=false)
    private Boolean estado = Boolean.TRUE;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at")
    private LocalDateTime updatedAt;

    @Generated
    public Long getIdVenta() {
        return this.idVenta;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Cliente getCliente() {
        return this.cliente;
    }

    @Generated
    public Reserva getReserva() {
        return this.reserva;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public Caja getCaja() {
        return this.caja;
    }

    @Generated
    public LocalDateTime getFechaHora() {
        return this.fechaHora;
    }

    @Generated
    public BigDecimal getMontoTotal() {
        return this.montoTotal;
    }

    @Generated
    public String getMetodoPago() {
        return this.metodoPago;
    }

    @Generated
    public String getNumeroOperacion() {
        return this.numeroOperacion;
    }

    @Generated
    public String getComprobante() {
        return this.comprobante;
    }

    @Generated
    public BigDecimal getDescuento() {
        return this.descuento;
    }

    @Generated
    public BigDecimal getPropina() {
        return this.propina;
    }

    @Generated
    public String getObservaciones() {
        return this.observaciones;
    }

    @Generated
    public Boolean getEstado() {
        return this.estado;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public void setIdVenta(Long idVenta) {
        this.idVenta = idVenta;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    @Generated
    public void setReserva(Reserva reserva) {
        this.reserva = reserva;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setCaja(Caja caja) {
        this.caja = caja;
    }

    @Generated
    public void setFechaHora(LocalDateTime fechaHora) {
        this.fechaHora = fechaHora;
    }

    @Generated
    public void setMontoTotal(BigDecimal montoTotal) {
        this.montoTotal = montoTotal;
    }

    @Generated
    public void setMetodoPago(String metodoPago) {
        this.metodoPago = metodoPago;
    }

    @Generated
    public void setNumeroOperacion(String numeroOperacion) {
        this.numeroOperacion = numeroOperacion;
    }

    @Generated
    public void setComprobante(String comprobante) {
        this.comprobante = comprobante;
    }

    @Generated
    public void setDescuento(BigDecimal descuento) {
        this.descuento = descuento;
    }

    @Generated
    public void setPropina(BigDecimal propina) {
        this.propina = propina;
    }

    @Generated
    public void setObservaciones(String observaciones) {
        this.observaciones = observaciones;
    }

    @Generated
    public void setEstado(Boolean estado) {
        this.estado = estado;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public String toString() {
        return "Venta(idVenta=" + String.valueOf(this.getIdVenta()) + ", empresa=" + String.valueOf(this.getEmpresa()) + ", cliente=" + String.valueOf(this.getCliente()) + ", reserva=" + String.valueOf(this.getReserva()) + ", usuario=" + String.valueOf(this.getUsuario()) + ", caja=" + String.valueOf(this.getCaja()) + ", fechaHora=" + String.valueOf(this.getFechaHora()) + ", montoTotal=" + String.valueOf(this.getMontoTotal()) + ", metodoPago=" + this.getMetodoPago() + ", numeroOperacion=" + this.getNumeroOperacion() + ", comprobante=" + this.getComprobante() + ", descuento=" + String.valueOf(this.getDescuento()) + ", propina=" + String.valueOf(this.getPropina()) + ", observaciones=" + this.getObservaciones() + ", estado=" + String.valueOf(this.getEstado()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }

    @Generated
    public Venta() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Venta)) {
            return false;
        }
        Venta other = (Venta)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idVenta = this.getIdVenta();
        Long other$idVenta = other.getIdVenta();
        return !(this$idVenta == null ? other$idVenta != null : !((Object)this$idVenta).equals(other$idVenta));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Venta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idVenta = this.getIdVenta();
        result = result * 59 + ($idVenta == null ? 43 : ((Object)$idVenta).hashCode());
        return result;
    }
}

