/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.Empresa;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EmpresaRepository
extends JpaRepository<Empresa, Long> {
    @Query(value="SELECT e FROM Empresa e WHERE e.deletedAt IS NULL ORDER BY e.createdAt DESC")
    public List<Empresa> findAllActivas();

    @Query(value="SELECT e FROM Empresa e WHERE e.deletedAt IS NULL AND (:estado IS NULL OR e.estado = :estado) AND (:busqueda IS NULL OR LOWER(e.nombreEmpresa) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(e.email) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR e.ruc LIKE CONCAT('%', :busqueda, '%')) ORDER BY e.createdAt DESC")
    public List<Empresa> findByFiltros(@Param(value="busqueda") String var1, @Param(value="estado") Integer var2);

    @Query(value="SELECT e FROM Empresa e WHERE e.idEmpresa = :id AND e.deletedAt IS NULL")
    public Optional<Empresa> findActivaById(@Param(value="id") Long var1);

    public boolean existsByRuc(String var1);

    public boolean existsByEmail(String var1);

    public boolean existsByRucAndIdEmpresaNot(String var1, Long var2);

    public boolean existsByEmailAndIdEmpresaNot(String var1, Long var2);
}

