/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.RolRequest;
import com.sistema.turistico.dto.RolResponse;
import com.sistema.turistico.entity.Rol;
import com.sistema.turistico.repository.RolRepository;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RolService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RolService.class);
    private final RolRepository rolRepository;

    public Rol crear(RolRequest request) {
        log.info("Creando rol con nombre {}", (Object)request.getNombreRol());
        String nombre = request.getNombreRol().trim();
        if (this.rolRepository.existsByNombreRol(nombre)) {
            throw new IllegalArgumentException("Ya existe un rol con este nombre");
        }
        Integer estado = request.getEstado();
        if (estado != null && estado != 0 && estado != 1) {
            throw new IllegalArgumentException("El estado del rol debe ser 0 (Inactivo) o 1 (Activo)");
        }
        Rol rol = new Rol();
        rol.setNombreRol(nombre);
        rol.setDescripcion(request.getDescripcion() != null ? request.getDescripcion().trim() : null);
        rol.setEstado(Integer.valueOf(estado != null ? estado : 1));
        rol.setDeletedAt(null);
        Rol creado = (Rol)this.rolRepository.save((Object)rol);
        log.info("Rol creado exitosamente con ID {}", (Object)creado.getIdRol());
        return creado;
    }

    @Transactional(readOnly=true)
    public List<Rol> listar(String busqueda, Integer estado) {
        String criterio;
        String string = criterio = busqueda != null && !busqueda.trim().isEmpty() ? busqueda.trim() : null;
        if (criterio == null && estado == null) {
            return this.rolRepository.findAllActivos();
        }
        return this.rolRepository.findByFiltros(criterio, estado);
    }

    @Transactional(readOnly=true)
    public Rol obtenerPorId(Long id) {
        return (Rol)this.rolRepository.findActivoById(id).orElseThrow(() -> new IllegalArgumentException("Rol no encontrado"));
    }

    public Rol actualizar(Long id, RolRequest request) {
        log.info("Actualizando rol {}", (Object)id);
        Rol existente = this.obtenerPorId(id);
        String nombre = request.getNombreRol().trim();
        if (!existente.getNombreRol().equalsIgnoreCase(nombre) && this.rolRepository.existsByNombreRolAndIdRolNot(nombre, id)) {
            throw new IllegalArgumentException("Ya existe un rol con este nombre");
        }
        Integer estado = request.getEstado();
        if (estado != null && estado != 0 && estado != 1) {
            throw new IllegalArgumentException("El estado del rol debe ser 0 (Inactivo) o 1 (Activo)");
        }
        existente.setNombreRol(nombre);
        existente.setDescripcion(request.getDescripcion() != null ? request.getDescripcion().trim() : null);
        if (estado != null) {
            existente.setEstado(estado);
        }
        Rol actualizado = (Rol)this.rolRepository.save((Object)existente);
        log.info("Rol actualizado exitosamente {}", (Object)actualizado.getIdRol());
        return actualizado;
    }

    public void eliminar(Long id) {
        log.info("Eliminando rol (soft delete) {}", (Object)id);
        Rol rol = this.obtenerPorId(id);
        rol.setEstado(Integer.valueOf(0));
        rol.setDeletedAt(LocalDateTime.now());
        this.rolRepository.save((Object)rol);
    }

    @Transactional(readOnly=true)
    public RolResponse toResponse(Rol rol) {
        return new RolResponse(rol.getIdRol(), rol.getNombreRol(), rol.getDescripcion(), rol.getEstado(), rol.getCreatedAt() != null ? rol.getCreatedAt().toString() : null, rol.getUpdatedAt() != null ? rol.getUpdatedAt().toString() : null, rol.getDeletedAt() != null ? rol.getDeletedAt().toString() : null);
    }

    @Generated
    public RolService(RolRepository rolRepository) {
        this.rolRepository = rolRepository;
    }
}

