/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.security;

import com.sistema.turistico.security.AuthenticatedUser;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public final class TenantContext {
    private TenantContext() {
    }

    public static Optional<AuthenticatedUser> getAuthenticatedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return Optional.empty();
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof AuthenticatedUser) {
            AuthenticatedUser authenticatedUser = (AuthenticatedUser)principal;
            return Optional.of(authenticatedUser);
        }
        return Optional.empty();
    }

    public static Optional<Long> getEmpresaId() {
        return TenantContext.getAuthenticatedUser().map(AuthenticatedUser::getEmpresaId);
    }

    public static Optional<Long> getUserId() {
        return TenantContext.getAuthenticatedUser().map(AuthenticatedUser::getUserId);
    }

    public static Long requireEmpresaId() {
        return (Long)TenantContext.getEmpresaId().orElseThrow(() -> new IllegalStateException("No se pudo determinar la empresa del usuario autenticado"));
    }

    public static Long requireUserId() {
        return (Long)TenantContext.getUserId().orElseThrow(() -> new IllegalStateException("No se pudo determinar el usuario autenticado"));
    }

    public static boolean hasAuthority(String authority) {
        if (authority == null || authority.isBlank()) {
            return false;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return false;
        }
        return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(auth -> auth != null && auth.equalsIgnoreCase(authority));
    }

    public static boolean hasRole(String role) {
        if (role == null || role.isBlank()) {
            return false;
        }
        String formatted = role.startsWith("ROLE_") ? role : "ROLE_" + role.toUpperCase();
        return TenantContext.hasAuthority((String)formatted);
    }

    public static boolean isSuperAdmin() {
        return TenantContext.hasRole((String)"SUPERADMINISTRADOR");
    }

    public static Long resolveEmpresaId(Long explicitEmpresaId) {
        if (TenantContext.isSuperAdmin()) {
            return explicitEmpresaId;
        }
        Long currentEmpresa = TenantContext.requireEmpresaId();
        if (explicitEmpresaId != null && !explicitEmpresaId.equals(currentEmpresa)) {
            throw new IllegalArgumentException("No tiene acceso a la empresa solicitada");
        }
        return currentEmpresa;
    }

    public static Long requireEmpresaIdOrCurrent(Long explicitEmpresaId) {
        return TenantContext.requireEmpresaIdOrCurrent((Long)explicitEmpresaId, (String)"La empresa es obligatoria para esta operaci\u00f3n");
    }

    public static Long requireEmpresaIdOrCurrent(Long explicitEmpresaId, String message) {
        Long resolved = TenantContext.resolveEmpresaId((Long)explicitEmpresaId);
        if (resolved == null) {
            throw new IllegalArgumentException(message != null ? message : "La empresa es obligatoria para esta operaci\u00f3n");
        }
        return resolved;
    }
}

