/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.entity.Permiso;
import com.sistema.turistico.entity.Usuario;
import com.sistema.turistico.repository.UsuarioRepository;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserDetailsServiceImpl
implements UserDetailsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserDetailsServiceImpl.class);
    private final UsuarioRepository usuarioRepository;

    @Transactional(readOnly=true)
    public UserDetails loadUserByUsername(String email) throws UsernameNotFoundException {
        Usuario usuario = (Usuario)this.usuarioRepository.findByEmailWithRolAndEmpresa(email).orElseThrow(() -> new UsernameNotFoundException("Usuario no encontrado: " + email));
        if (usuario.getEstado() != 1) {
            throw new UsernameNotFoundException("Usuario inactivo: " + email);
        }
        if (usuario.getBloqueadoHasta() != null && usuario.getBloqueadoHasta().isAfter(LocalDateTime.now())) {
            throw new UsernameNotFoundException("Usuario bloqueado temporalmente: " + email);
        }
        List authorities = this.getAuthoritiesForUser(usuario);
        return User.builder().username(usuario.getEmail()).password(usuario.getPasswordHash()).authorities((Collection)authorities).accountExpired(false).accountLocked(false).credentialsExpired(false).disabled(false).build();
    }

    private List<GrantedAuthority> getAuthoritiesForUser(Usuario usuario) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        if (usuario.getRol() != null) {
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_" + usuario.getRol().getNombreRol().toUpperCase()));
        }
        if (usuario.getRol() != null && usuario.getRol().getPermisos() != null && !usuario.getRol().getPermisos().isEmpty()) {
            for (Permiso permiso : usuario.getRol().getPermisos()) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_" + permiso.getNombrePermiso().toUpperCase()));
            }
        }
        return authorities;
    }

    @Generated
    public UserDetailsServiceImpl(UsuarioRepository usuarioRepository) {
        this.usuarioRepository = usuarioRepository;
    }
}

