/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.exception;

import jakarta.persistence.EntityNotFoundException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

@RestControllerAdvice
public class GlobalExceptionHandler {
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<Map<String, Object>> handleValidationExceptions(MethodArgumentNotValidException ex) {
        HashMap errors = new HashMap();
        ex.getBindingResult().getAllErrors().forEach(error -> {
            String fieldName = ((FieldError)error).getField();
            String errorMessage = error.getDefaultMessage();
            errors.put(fieldName, errorMessage);
        });
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("timestamp", LocalDateTime.now());
        response.put("status", HttpStatus.BAD_REQUEST.value());
        response.put("error", "Validation Error");
        response.put("message", "Errores de validaci\u00f3n en los campos");
        response.put("errors", errors);
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<Map<String, Object>> handleEntityNotFoundException(EntityNotFoundException ex, WebRequest request) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("timestamp", LocalDateTime.now());
        response.put("status", HttpStatus.NOT_FOUND.value());
        response.put("error", "Not Found");
        response.put("message", ex.getMessage());
        response.put("path", request.getDescription(false).replace("uri=", ""));
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={BadCredentialsException.class})
    public ResponseEntity<Map<String, Object>> handleBadCredentialsException(BadCredentialsException ex, WebRequest request) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("timestamp", LocalDateTime.now());
        response.put("status", HttpStatus.UNAUTHORIZED.value());
        response.put("error", "Unauthorized");
        response.put("message", "Credenciales inv\u00e1lidas");
        response.put("path", request.getDescription(false).replace("uri=", ""));
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<Map<String, Object>> handleAccessDeniedException(AccessDeniedException ex, WebRequest request) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("timestamp", LocalDateTime.now());
        response.put("status", HttpStatus.FORBIDDEN.value());
        response.put("error", "Forbidden");
        response.put("message", "No tienes permisos para acceder a este recurso");
        response.put("path", request.getDescription(false).replace("uri=", ""));
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public ResponseEntity<Map<String, Object>> handleAuthenticationException(AuthenticationException ex, WebRequest request) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("timestamp", LocalDateTime.now());
        response.put("status", HttpStatus.UNAUTHORIZED.value());
        response.put("error", "Unauthorized");
        response.put("message", "Autenticaci\u00f3n requerida");
        response.put("path", request.getDescription(false).replace("uri=", ""));
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<Map<String, Object>> handleIllegalArgumentException(IllegalArgumentException ex, WebRequest request) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("timestamp", LocalDateTime.now());
        response.put("status", HttpStatus.BAD_REQUEST.value());
        response.put("error", "Bad Request");
        response.put("message", ex.getMessage());
        response.put("path", request.getDescription(false).replace("uri=", ""));
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Map<String, Object>> handleGlobalException(Exception ex, WebRequest request) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("timestamp", LocalDateTime.now());
        response.put("status", HttpStatus.INTERNAL_SERVER_ERROR.value());
        response.put("error", "Internal Server Error");
        response.put("message", "Ha ocurrido un error interno del servidor");
        response.put("path", request.getDescription(false).replace("uri=", ""));
        ex.printStackTrace();
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

