/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.EmpresaRequest;
import com.sistema.turistico.dto.EmpresaResponse;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.service.EmpresaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/empresas"})
@Tag(name="Empresas", description="Endpoints para gesti\u00f3n de empresas")
public class EmpresaController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmpresaController.class);
    private final EmpresaService empresaService;

    @PostMapping
    @PreAuthorize(value="hasRole('SUPERADMINISTRADOR')")
    @Operation(summary="Crear empresa", description="Crea una nueva empresa")
    public ResponseEntity<Map<String, Object>> crearEmpresa(@Valid @RequestBody EmpresaRequest request) {
        try {
            log.info("Solicitando creaci\u00f3n de empresa");
            Empresa empresa = this.empresaService.crear(request);
            EmpresaResponse data = this.empresaService.toResponse(empresa);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Empresa creada exitosamente");
            response.put("data", data);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al crear empresa: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error interno al crear empresa", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping
    @PreAuthorize(value="hasRole('SUPERADMINISTRADOR')")
    @Operation(summary="Listar empresas", description="Obtiene la lista de empresas (solo para administradores)")
    public ResponseEntity<Map<String, Object>> listarEmpresas(@RequestParam(required=false) String busqueda, @RequestParam(required=false) Integer estado) {
        try {
            log.info("Listando empresas con filtros: busqueda={}, estado={}", (Object)busqueda, (Object)estado);
            List empresas = this.empresaService.listar(busqueda, estado);
            List<EmpresaResponse> data = empresas.stream().map(arg_0 -> ((EmpresaService)this.empresaService).toResponse(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Empresas obtenidas exitosamente");
            response.put("data", data);
            response.put("total", data.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar empresas", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasRole('SUPERADMINISTRADOR')")
    @Operation(summary="Obtener empresa", description="Obtiene una empresa por su identificador")
    public ResponseEntity<Map<String, Object>> obtenerEmpresa(@PathVariable Long id) {
        try {
            log.info("Obteniendo empresa {}", (Object)id);
            Empresa empresa = this.empresaService.obtenerPorId(id);
            EmpresaResponse data = this.empresaService.toResponse(empresa);
            return ResponseEntity.ok(Map.of("success", true, "message", "Empresa obtenida exitosamente", "data", data));
        }
        catch (IllegalArgumentException ex) {
            log.warn("Empresa no encontrada: {}", (Object)ex.getMessage());
            return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener empresa {}", (Object)id, (Object)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasRole('SUPERADMINISTRADOR')")
    @Operation(summary="Actualizar empresa", description="Actualiza los datos de una empresa")
    public ResponseEntity<Map<String, Object>> actualizarEmpresa(@PathVariable Long id, @Valid @RequestBody EmpresaRequest request) {
        try {
            log.info("Actualizando empresa {}", (Object)id);
            Empresa empresa = this.empresaService.actualizar(id, request);
            EmpresaResponse data = this.empresaService.toResponse(empresa);
            return ResponseEntity.ok(Map.of("success", true, "message", "Empresa actualizada exitosamente", "data", data));
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al actualizar empresa: {}", (Object)ex.getMessage());
            if ("Empresa no encontrada".equalsIgnoreCase(ex.getMessage())) {
                return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
            }
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error interno al actualizar empresa {}", (Object)id, (Object)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasRole('SUPERADMINISTRADOR')")
    @Operation(summary="Eliminar empresa", description="Realiza un borrado l\u00f3gico de una empresa")
    public ResponseEntity<Map<String, Object>> eliminarEmpresa(@PathVariable Long id) {
        try {
            log.info("Eliminando empresa {}", (Object)id);
            this.empresaService.eliminar(id);
            return ResponseEntity.ok(Map.of("success", true, "message", "Empresa eliminada exitosamente"));
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al eliminar empresa: {}", (Object)ex.getMessage());
            if ("Empresa no encontrada".equalsIgnoreCase(ex.getMessage())) {
                return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
            }
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error interno al eliminar empresa {}", (Object)id, (Object)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @Generated
    public EmpresaController(EmpresaService empresaService) {
        this.empresaService = empresaService;
    }
}

