/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.Voucher;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="vouchers")
public class Voucher {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_voucher")
    private Long idVoucher;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_reserva", nullable=false)
    private Reserva reserva;
    @Column(name="codigo_qr", length=255)
    private String codigoQr;
    @Column(name="fecha_emision", nullable=false)
    private LocalDate fechaEmision;
    @Column(name="fecha_expiracion")
    private LocalDate fechaExpiracion;
    @Enumerated(value=EnumType.STRING)
    @Column(name="estado", nullable=false)
    private EstadoVoucher estado = EstadoVoucher.Emitido;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at")
    private LocalDateTime updatedAt;

    @Generated
    public Long getIdVoucher() {
        return this.idVoucher;
    }

    @Generated
    public Reserva getReserva() {
        return this.reserva;
    }

    @Generated
    public String getCodigoQr() {
        return this.codigoQr;
    }

    @Generated
    public LocalDate getFechaEmision() {
        return this.fechaEmision;
    }

    @Generated
    public LocalDate getFechaExpiracion() {
        return this.fechaExpiracion;
    }

    @Generated
    public EstadoVoucher getEstado() {
        return this.estado;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public void setIdVoucher(Long idVoucher) {
        this.idVoucher = idVoucher;
    }

    @Generated
    public void setReserva(Reserva reserva) {
        this.reserva = reserva;
    }

    @Generated
    public void setCodigoQr(String codigoQr) {
        this.codigoQr = codigoQr;
    }

    @Generated
    public void setFechaEmision(LocalDate fechaEmision) {
        this.fechaEmision = fechaEmision;
    }

    @Generated
    public void setFechaExpiracion(LocalDate fechaExpiracion) {
        this.fechaExpiracion = fechaExpiracion;
    }

    @Generated
    public void setEstado(EstadoVoucher estado) {
        this.estado = estado;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public String toString() {
        return "Voucher(idVoucher=" + String.valueOf(this.getIdVoucher()) + ", reserva=" + String.valueOf(this.getReserva()) + ", codigoQr=" + this.getCodigoQr() + ", fechaEmision=" + String.valueOf(this.getFechaEmision()) + ", fechaExpiracion=" + String.valueOf(this.getFechaExpiracion()) + ", estado=" + String.valueOf(this.getEstado()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }

    @Generated
    public Voucher() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Voucher)) {
            return false;
        }
        Voucher other = (Voucher)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idVoucher = this.getIdVoucher();
        Long other$idVoucher = other.getIdVoucher();
        return !(this$idVoucher == null ? other$idVoucher != null : !((Object)this$idVoucher).equals(other$idVoucher));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Voucher;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idVoucher = this.getIdVoucher();
        result = result * 59 + ($idVoucher == null ? 43 : ((Object)$idVoucher).hashCode());
        return result;
    }
}

