/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.Caja;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface CajaRepository
extends JpaRepository<Caja, Long> {
    public boolean existsBySucursal_IdSucursalAndEstado(Long var1, Caja.EstadoCaja var2);

    public Optional<Caja> findFirstBySucursal_IdSucursalAndEstadoOrderByCreatedAtDesc(Long var1, Caja.EstadoCaja var2);

    public List<Caja> findByEmpresa_IdEmpresaAndEstado(Long var1, Caja.EstadoCaja var2);

    @Query(value="SELECT c FROM Caja c WHERE c.empresa.idEmpresa = :empresaId AND (:fecha IS NULL OR c.fechaApertura = :fecha) ORDER BY c.createdAt DESC")
    public List<Caja> findByEmpresaAndFecha(@Param(value="empresaId") Long var1, @Param(value="fecha") LocalDate var2);

    @Query(value="SELECT c FROM Caja c WHERE (:empresaId IS NULL OR c.empresa.idEmpresa = :empresaId) AND (:sucursalId IS NULL OR c.sucursal.idSucursal = :sucursalId) AND (:estado IS NULL OR c.estado = :estado) ORDER BY c.createdAt DESC")
    public List<Caja> findByFilters(@Param(value="empresaId") Long var1, @Param(value="sucursalId") Long var2, @Param(value="estado") Caja.EstadoCaja var3);
}

