/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.MovimientoCaja;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MovimientoCajaRepository
extends JpaRepository<MovimientoCaja, Long> {
    public List<MovimientoCaja> findByCaja_IdCajaOrderByFechaHoraAsc(Long var1);

    @Query(value="SELECT m FROM MovimientoCaja m WHERE m.caja.idCaja = :cajaId AND (:tipo IS NULL OR m.tipoMovimiento = :tipo) AND (:inicio IS NULL OR m.fechaHora >= :inicio) AND (:fin IS NULL OR m.fechaHora <= :fin) ORDER BY m.fechaHora ASC")
    public List<MovimientoCaja> findByCajaAndFilters(@Param(value="cajaId") Long var1, @Param(value="tipo") MovimientoCaja.TipoMovimiento var2, @Param(value="inicio") LocalDateTime var3, @Param(value="fin") LocalDateTime var4);

    @Query(value="SELECT COALESCE(SUM(m.monto), 0) FROM MovimientoCaja m WHERE m.caja.idCaja = :cajaId AND m.tipoMovimiento = :tipo AND (:inicio IS NULL OR m.fechaHora >= :inicio) AND (:fin IS NULL OR m.fechaHora <= :fin)")
    public BigDecimal sumByCajaAndTipoAndRango(@Param(value="cajaId") Long var1, @Param(value="tipo") MovimientoCaja.TipoMovimiento var2, @Param(value="inicio") LocalDateTime var3, @Param(value="fin") LocalDateTime var4);

    public Optional<MovimientoCaja> findByIdMovimientoAndCaja_IdCaja(Long var1, Long var2);
}

