/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.AsignacionPersonalRequest;
import com.sistema.turistico.dto.AsignacionPersonalUpdateRequest;
import com.sistema.turistico.entity.AsignacionPersonal;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.Personal;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.repository.AsignacionPersonalRepository;
import com.sistema.turistico.repository.PersonalRepository;
import com.sistema.turistico.repository.ReservaRepository;
import com.sistema.turistico.security.TenantContext;
import java.sql.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AsignacionPersonalService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsignacionPersonalService.class);
    private final AsignacionPersonalRepository asignacionRepository;
    private final PersonalRepository personalRepository;
    private final ReservaRepository reservaRepository;

    @Transactional
    public AsignacionPersonal create(AsignacionPersonalRequest request) {
        Date fechaAsignacion;
        log.info("Creando asignaci\u00f3n de personal: {} para reserva {}", (Object)request.getIdPersonal(), (Object)request.getIdReserva());
        Personal personal = (Personal)this.personalRepository.findById((Object)request.getIdPersonal()).orElseThrow(() -> new IllegalArgumentException("Personal no encontrado"));
        if (!personal.isActivo()) {
            throw new IllegalArgumentException("El personal no est\u00e1 activo");
        }
        Reserva reserva = (Reserva)this.reservaRepository.findById((Object)request.getIdReserva()).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        Long empresaReserva = this.extractEmpresaId(reserva);
        this.ensureEmpresaAcceso(empresaReserva);
        this.ensureMismaEmpresa(personal, empresaReserva);
        Date date = fechaAsignacion = request.getFechaAsignacion() != null ? request.getFechaAsignacion() : reserva.getFechaServicio();
        if (this.asignacionRepository.existsByPersonalAndFecha(request.getIdPersonal(), fechaAsignacion)) {
            throw new IllegalArgumentException("El personal ya est\u00e1 asignado en esta fecha");
        }
        if (!fechaAsignacion.equals(reserva.getFechaServicio())) {
            throw new IllegalArgumentException("La fecha de asignaci\u00f3n debe coincidir con la fecha del servicio");
        }
        AsignacionPersonal asignacion = new AsignacionPersonal(personal, reserva, fechaAsignacion);
        asignacion.setObservaciones(request.getObservaciones());
        asignacion.setEstado(AsignacionPersonal.EstadoAsignacion.Asignado);
        return (AsignacionPersonal)this.asignacionRepository.save((Object)asignacion);
    }

    @Transactional
    public AsignacionPersonal create(AsignacionPersonal asignacion) {
        log.info("Creando asignaci\u00f3n de personal: {} para reserva {}", (Object)asignacion.getPersonal().getIdPersonal(), (Object)asignacion.getReserva().getIdReserva());
        Personal personal = (Personal)this.personalRepository.findById((Object)asignacion.getPersonal().getIdPersonal()).orElseThrow(() -> new IllegalArgumentException("Personal no encontrado"));
        if (!personal.isActivo()) {
            throw new IllegalArgumentException("El personal no est\u00e1 activo");
        }
        Reserva reserva = (Reserva)this.reservaRepository.findById((Object)asignacion.getReserva().getIdReserva()).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        Long empresaReserva = this.extractEmpresaId(reserva);
        this.ensureEmpresaAcceso(empresaReserva);
        this.ensureMismaEmpresa(personal, empresaReserva);
        if (this.asignacionRepository.existsByPersonalAndFecha(personal.getIdPersonal(), asignacion.getFechaAsignacion())) {
            throw new IllegalArgumentException("El personal ya est\u00e1 asignado en esta fecha");
        }
        if (!asignacion.getFechaAsignacion().equals(reserva.getFechaServicio())) {
            throw new IllegalArgumentException("La fecha de asignaci\u00f3n debe coincidir con la fecha del servicio");
        }
        asignacion.setEstado(AsignacionPersonal.EstadoAsignacion.Asignado);
        return (AsignacionPersonal)this.asignacionRepository.save((Object)asignacion);
    }

    public Optional<AsignacionPersonal> findById(Long id) {
        return this.asignacionRepository.findById((Object)id).map(asignacion -> {
            this.ensureAsignacionAcceso(asignacion);
            return asignacion;
        });
    }

    public List<AsignacionPersonal> findByReservaId(Long reservaId) {
        Reserva reserva = (Reserva)this.reservaRepository.findById((Object)reservaId).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        Long empresaReserva = this.extractEmpresaId(reserva);
        this.ensureEmpresaAcceso(empresaReserva);
        return this.asignacionRepository.findByReservaId(reservaId).stream().filter(arg_0 -> this.perteneceALaEmpresaActual(arg_0)).collect(Collectors.toList());
    }

    public List<AsignacionPersonal> findByPersonalId(Long personalId) {
        Personal personal = (Personal)this.personalRepository.findById((Object)personalId).orElseThrow(() -> new IllegalArgumentException("Personal no encontrado"));
        Long empresaPersonal = this.extractEmpresaId(personal);
        this.ensureEmpresaAcceso(empresaPersonal);
        return this.asignacionRepository.findByPersonalId(personalId).stream().filter(arg_0 -> this.perteneceALaEmpresaActual(arg_0)).collect(Collectors.toList());
    }

    public List<AsignacionPersonal> findByFecha(Date fecha) {
        return this.asignacionRepository.findByFechaAsignacion(fecha).stream().filter(arg_0 -> this.perteneceALaEmpresaActual(arg_0)).collect(Collectors.toList());
    }

    public List<AsignacionPersonal> findByFechaBetween(Date fechaInicio, Date fechaFin) {
        return this.asignacionRepository.findByFechaAsignacionBetween(fechaInicio, fechaFin).stream().filter(arg_0 -> this.perteneceALaEmpresaActual(arg_0)).collect(Collectors.toList());
    }

    @Transactional
    public AsignacionPersonal update(Long id, AsignacionPersonal asignacionActualizada) {
        log.info("Actualizando asignaci\u00f3n ID: {}", (Object)id);
        AsignacionPersonal asignacionExistente = (AsignacionPersonal)this.asignacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Asignaci\u00f3n no encontrada"));
        this.ensureAsignacionAcceso(asignacionExistente);
        if (asignacionActualizada.getObservaciones() != null) {
            asignacionExistente.setObservaciones(asignacionActualizada.getObservaciones());
        }
        return (AsignacionPersonal)this.asignacionRepository.save((Object)asignacionExistente);
    }

    @Transactional
    public AsignacionPersonal update(Long id, AsignacionPersonalUpdateRequest request) {
        log.info("Actualizando asignaci\u00f3n ID: {} con nuevo personal: {}", (Object)id, (Object)request.getIdPersonal());
        AsignacionPersonal asignacionExistente = (AsignacionPersonal)this.asignacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Asignaci\u00f3n no encontrada"));
        this.ensureAsignacionAcceso(asignacionExistente);
        if (!request.getIdPersonal().equals(asignacionExistente.getPersonal().getIdPersonal())) {
            Personal nuevoPersonal = (Personal)this.personalRepository.findById((Object)request.getIdPersonal()).orElseThrow(() -> new IllegalArgumentException("Nuevo personal no encontrado"));
            if (!nuevoPersonal.isActivo()) {
                throw new IllegalArgumentException("El nuevo personal no est\u00e1 activo");
            }
            this.ensureMismaEmpresa(nuevoPersonal, this.extractEmpresaId(asignacionExistente.getReserva()));
            if (this.asignacionRepository.existsByPersonalAndFecha(request.getIdPersonal(), asignacionExistente.getFechaAsignacion())) {
                throw new IllegalArgumentException("El nuevo personal ya est\u00e1 asignado en esta fecha");
            }
            asignacionExistente.setPersonal(nuevoPersonal);
        }
        asignacionExistente.setObservaciones(request.getObservaciones());
        return (AsignacionPersonal)this.asignacionRepository.save((Object)asignacionExistente);
    }

    @Transactional
    public AsignacionPersonal completar(Long id) {
        log.info("Marcando asignaci\u00f3n ID {} como completada", (Object)id);
        AsignacionPersonal asignacion = (AsignacionPersonal)this.asignacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Asignaci\u00f3n no encontrada"));
        this.ensureAsignacionAcceso(asignacion);
        if (asignacion.getEstado() != AsignacionPersonal.EstadoAsignacion.Asignado) {
            throw new IllegalArgumentException("Solo se pueden completar asignaciones en estado 'Asignado'");
        }
        asignacion.setEstado(AsignacionPersonal.EstadoAsignacion.Completado);
        return (AsignacionPersonal)this.asignacionRepository.save((Object)asignacion);
    }

    @Transactional
    public AsignacionPersonal cancelar(Long id, String motivo) {
        log.info("Cancelando asignaci\u00f3n ID: {}", (Object)id);
        AsignacionPersonal asignacion = (AsignacionPersonal)this.asignacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Asignaci\u00f3n no encontrada"));
        this.ensureAsignacionAcceso(asignacion);
        if (asignacion.getEstado() == AsignacionPersonal.EstadoAsignacion.Completado) {
            throw new IllegalArgumentException("No se puede cancelar una asignaci\u00f3n completada");
        }
        asignacion.setEstado(AsignacionPersonal.EstadoAsignacion.Cancelado);
        asignacion.setObservaciones(motivo != null ? motivo : "Cancelado por el sistema");
        return (AsignacionPersonal)this.asignacionRepository.save((Object)asignacion);
    }

    @Transactional
    public void delete(Long id) {
        log.info("Eliminando asignaci\u00f3n ID: {}", (Object)id);
        AsignacionPersonal asignacion = (AsignacionPersonal)this.asignacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Asignaci\u00f3n no encontrada"));
        this.ensureAsignacionAcceso(asignacion);
        this.asignacionRepository.delete((Object)asignacion);
    }

    @Transactional(readOnly=true)
    public boolean verificarDisponibilidadPersonal(Long personalId, Date fecha) {
        Personal personal = (Personal)this.personalRepository.findById((Object)personalId).orElseThrow(() -> new IllegalArgumentException("Personal no encontrado"));
        this.ensureEmpresaAcceso(this.extractEmpresaId(personal));
        return !this.asignacionRepository.existsByPersonalAndFecha(personalId, fecha);
    }

    public Long countAsignacionesActivasByPersonal(Long personalId) {
        Personal personal = (Personal)this.personalRepository.findById((Object)personalId).orElseThrow(() -> new IllegalArgumentException("Personal no encontrado"));
        this.ensureEmpresaAcceso(this.extractEmpresaId(personal));
        return this.asignacionRepository.countAsignacionesActivasByPersonal(personalId);
    }

    private void ensureAsignacionAcceso(AsignacionPersonal asignacion) {
        Long empresaReserva = this.extractEmpresaId(asignacion.getReserva());
        this.ensureEmpresaAcceso(empresaReserva);
    }

    private void ensureEmpresaAcceso(Long empresaId) {
        TenantContext.requireEmpresaIdOrCurrent((Long)empresaId, (String)"No tiene acceso a la empresa especificada");
    }

    private void ensureMismaEmpresa(Personal personal, Long empresaReserva) {
        Long empresaPersonal = this.extractEmpresaId(personal);
        if (!empresaPersonal.equals(empresaReserva)) {
            throw new IllegalArgumentException("El personal no pertenece a la empresa de la reserva");
        }
    }

    private Long extractEmpresaId(Reserva reserva) {
        if (reserva == null || reserva.getEmpresa() == null) {
            throw new IllegalArgumentException("La reserva no tiene una empresa asociada");
        }
        Empresa empresa = reserva.getEmpresa();
        if (empresa.getIdEmpresa() == null) {
            throw new IllegalArgumentException("La reserva no tiene una empresa v\u00e1lida");
        }
        return empresa.getIdEmpresa();
    }

    private Long extractEmpresaId(Personal personal) {
        if (personal == null || personal.getEmpresa() == null) {
            throw new IllegalArgumentException("El personal no tiene una empresa asociada");
        }
        Empresa empresa = personal.getEmpresa();
        if (empresa.getIdEmpresa() == null) {
            throw new IllegalArgumentException("El personal no tiene una empresa v\u00e1lida");
        }
        return empresa.getIdEmpresa();
    }

    private boolean perteneceALaEmpresaActual(AsignacionPersonal asignacion) {
        if (TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaActual = TenantContext.getEmpresaId().orElse(null);
        if (empresaActual == null) {
            return false;
        }
        Long empresaAsignacion = this.extractEmpresaId(asignacion.getReserva());
        return empresaActual.equals(empresaAsignacion);
    }

    @Generated
    public AsignacionPersonalService(AsignacionPersonalRepository asignacionRepository, PersonalRepository personalRepository, ReservaRepository reservaRepository) {
        this.asignacionRepository = asignacionRepository;
        this.personalRepository = personalRepository;
        this.reservaRepository = reservaRepository;
    }
}

