/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.config;

import com.sistema.turistico.security.JwtAuthenticationFilter;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CorsConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.cors.CorsConfigurationSource;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
public class SecurityConfig {
    private final JwtAuthenticationFilter jwtAuthenticationFilter;
    @Qualifier(value="corsConfigurationSource")
    private final CorsConfigurationSource corsConfigurationSource;

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.cors(cors -> {
            CorsConfigurer corsConfigurer = cors.configurationSource(this.corsConfigurationSource);
        }).csrf(AbstractHttpConfigurer::disable).sessionManagement(session -> {
            SessionManagementConfigurer sessionManagementConfigurer = session.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        }).authorizeHttpRequests(authz -> {
            AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().requestMatchers(new String[]{"/auth/**", "/health", "/swagger-ui/**", "/v3/api-docs/**"})).permitAll().requestMatchers(new String[]{"/admin/**"})).hasRole("SUPERADMINISTRADOR").requestMatchers(new String[]{"/empresas/**"})).hasAnyRole(new String[]{"ADMINISTRADOR", "SUPERADMINISTRADOR"}).requestMatchers(new String[]{"/reservas/**"})).hasAnyRole(new String[]{"EMPLEADO", "ADMINISTRADOR", "SUPERADMINISTRADOR"}).requestMatchers(new String[]{"/vouchers/**"})).hasAnyRole(new String[]{"EMPLEADO", "ADMINISTRADOR", "SUPERADMINISTRADOR"}).requestMatchers(new String[]{"/clientes/**"})).hasAnyRole(new String[]{"EMPLEADO", "ADMINISTRADOR", "SUPERADMINISTRADOR"}).requestMatchers(new String[]{"/servicios/**"})).hasAnyRole(new String[]{"EMPLEADO", "ADMINISTRADOR", "SUPERADMINISTRADOR"}).requestMatchers(new String[]{"/cajas/**"})).hasAnyRole(new String[]{"EMPLEADO", "ADMINISTRADOR", "SUPERADMINISTRADOR"}).requestMatchers(new String[]{"/pagos/**"})).hasAnyRole(new String[]{"EMPLEADO", "ADMINISTRADOR", "SUPERADMINISTRADOR"}).requestMatchers(new String[]{"/ventas/**"})).hasAnyRole(new String[]{"EMPLEADO", "ADMINISTRADOR", "SUPERADMINISTRADOR"}).requestMatchers(new String[]{"/reportes/finanzas/**"})).hasAnyRole(new String[]{"ADMINISTRADOR", "SUPERADMINISTRADOR"}).anyRequest()).authenticated();
        }).addFilterBefore((Filter)this.jwtAuthenticationFilter, UsernamePasswordAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationConfiguration config) throws Exception {
        return config.getAuthenticationManager();
    }

    @Generated
    public SecurityConfig(JwtAuthenticationFilter jwtAuthenticationFilter, CorsConfigurationSource corsConfigurationSource) {
        this.jwtAuthenticationFilter = jwtAuthenticationFilter;
        this.corsConfigurationSource = corsConfigurationSource;
    }
}

