/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Caja;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.Sucursal;
import com.sistema.turistico.entity.Usuario;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="cajas")
public class Caja {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_caja")
    private Long idCaja;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa", nullable=false)
    private Empresa empresa;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_sucursal", nullable=false)
    private Sucursal sucursal;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_usuario_apertura", nullable=false)
    private Usuario usuarioApertura;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_usuario_cierre")
    private Usuario usuarioCierre;
    @Column(name="fecha_apertura", nullable=false)
    private LocalDate fechaApertura;
    @Column(name="hora_apertura", nullable=false)
    private LocalTime horaApertura;
    @DecimalMin(value="0.00", message="El monto inicial no puede ser negativo")
    @Digits(integer=10, fraction=2)
    @Column(name="monto_inicial", nullable=false, precision=10, scale=2)
    private @DecimalMin(value="0.00", message="El monto inicial no puede ser negativo") @Digits(integer=10, fraction=2) BigDecimal montoInicial;
    @DecimalMin(value="0.00", message="El saldo actual no puede ser negativo")
    @Digits(integer=10, fraction=2)
    @Column(name="saldo_actual", nullable=false, precision=10, scale=2)
    private @DecimalMin(value="0.00", message="El saldo actual no puede ser negativo") @Digits(integer=10, fraction=2) BigDecimal saldoActual;
    @Digits(integer=10, fraction=2)
    @Column(name="monto_cierre", precision=10, scale=2)
    private @Digits(integer=10, fraction=2) BigDecimal montoCierre;
    @Digits(integer=10, fraction=2)
    @Column(name="diferencia", precision=10, scale=2)
    private @Digits(integer=10, fraction=2) BigDecimal diferencia;
    @Enumerated(value=EnumType.STRING)
    @Column(name="estado", nullable=false)
    private EstadoCaja estado = EstadoCaja.Abierta;
    @Column(name="observaciones", columnDefinition="TEXT")
    private String observaciones;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at")
    private LocalDateTime updatedAt;

    public boolean estaAbierta() {
        return EstadoCaja.Abierta.equals((Object)this.estado);
    }

    @Generated
    public Long getIdCaja() {
        return this.idCaja;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Sucursal getSucursal() {
        return this.sucursal;
    }

    @Generated
    public Usuario getUsuarioApertura() {
        return this.usuarioApertura;
    }

    @Generated
    public Usuario getUsuarioCierre() {
        return this.usuarioCierre;
    }

    @Generated
    public LocalDate getFechaApertura() {
        return this.fechaApertura;
    }

    @Generated
    public LocalTime getHoraApertura() {
        return this.horaApertura;
    }

    @Generated
    public BigDecimal getMontoInicial() {
        return this.montoInicial;
    }

    @Generated
    public BigDecimal getSaldoActual() {
        return this.saldoActual;
    }

    @Generated
    public BigDecimal getMontoCierre() {
        return this.montoCierre;
    }

    @Generated
    public BigDecimal getDiferencia() {
        return this.diferencia;
    }

    @Generated
    public EstadoCaja getEstado() {
        return this.estado;
    }

    @Generated
    public String getObservaciones() {
        return this.observaciones;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public void setIdCaja(Long idCaja) {
        this.idCaja = idCaja;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setSucursal(Sucursal sucursal) {
        this.sucursal = sucursal;
    }

    @Generated
    public void setUsuarioApertura(Usuario usuarioApertura) {
        this.usuarioApertura = usuarioApertura;
    }

    @Generated
    public void setUsuarioCierre(Usuario usuarioCierre) {
        this.usuarioCierre = usuarioCierre;
    }

    @Generated
    public void setFechaApertura(LocalDate fechaApertura) {
        this.fechaApertura = fechaApertura;
    }

    @Generated
    public void setHoraApertura(LocalTime horaApertura) {
        this.horaApertura = horaApertura;
    }

    @Generated
    public void setMontoInicial(BigDecimal montoInicial) {
        this.montoInicial = montoInicial;
    }

    @Generated
    public void setSaldoActual(BigDecimal saldoActual) {
        this.saldoActual = saldoActual;
    }

    @Generated
    public void setMontoCierre(BigDecimal montoCierre) {
        this.montoCierre = montoCierre;
    }

    @Generated
    public void setDiferencia(BigDecimal diferencia) {
        this.diferencia = diferencia;
    }

    @Generated
    public void setEstado(EstadoCaja estado) {
        this.estado = estado;
    }

    @Generated
    public void setObservaciones(String observaciones) {
        this.observaciones = observaciones;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public String toString() {
        return "Caja(idCaja=" + String.valueOf(this.getIdCaja()) + ", empresa=" + String.valueOf(this.getEmpresa()) + ", sucursal=" + String.valueOf(this.getSucursal()) + ", usuarioApertura=" + String.valueOf(this.getUsuarioApertura()) + ", usuarioCierre=" + String.valueOf(this.getUsuarioCierre()) + ", fechaApertura=" + String.valueOf(this.getFechaApertura()) + ", horaApertura=" + String.valueOf(this.getHoraApertura()) + ", montoInicial=" + String.valueOf(this.getMontoInicial()) + ", saldoActual=" + String.valueOf(this.getSaldoActual()) + ", montoCierre=" + String.valueOf(this.getMontoCierre()) + ", diferencia=" + String.valueOf(this.getDiferencia()) + ", estado=" + String.valueOf(this.getEstado()) + ", observaciones=" + this.getObservaciones() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }

    @Generated
    public Caja() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Caja)) {
            return false;
        }
        Caja other = (Caja)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idCaja = this.getIdCaja();
        Long other$idCaja = other.getIdCaja();
        return !(this$idCaja == null ? other$idCaja != null : !((Object)this$idCaja).equals(other$idCaja));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Caja;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idCaja = this.getIdCaja();
        result = result * 59 + ($idCaja == null ? 43 : ((Object)$idCaja).hashCode());
        return result;
    }
}

