/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.PagoReserva;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PagoReservaRepository
extends JpaRepository<PagoReserva, Long> {
    @Query(value="SELECT COALESCE(SUM(p.montoPagado), 0) FROM PagoReserva p WHERE p.reserva.idReserva = :reservaId AND p.estado = true")
    public BigDecimal sumMontosActivosPorReserva(@Param(value="reservaId") Long var1);

    public List<PagoReserva> findByReserva_IdReservaAndEstadoTrueOrderByFechaPagoAsc(Long var1);

    public List<PagoReserva> findByReserva_IdReservaOrderByFechaPagoAsc(Long var1);

    public Optional<PagoReserva> findByIdPagoAndReserva_IdReservaAndEstadoTrue(Long var1, Long var2);

    @Query(value="SELECT p FROM PagoReserva p WHERE (:empresaId IS NULL OR p.reserva.empresa.idEmpresa = :empresaId) AND (:metodoPago IS NULL OR p.metodoPago = :metodoPago) AND (:estado IS NULL OR p.estado = :estado) AND (:fechaDesde IS NULL OR p.fechaPago >= :fechaDesde) AND (:fechaHasta IS NULL OR p.fechaPago <= :fechaHasta) ORDER BY p.fechaPago DESC, p.createdAt DESC")
    public List<PagoReserva> findByFiltros(@Param(value="empresaId") Long var1, @Param(value="metodoPago") String var2, @Param(value="estado") Boolean var3, @Param(value="fechaDesde") LocalDate var4, @Param(value="fechaHasta") LocalDate var5);
}

