/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.Personal;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PersonalRepository
extends JpaRepository<Personal, Long> {
    @Query(value="SELECT p FROM Personal p WHERE p.empresa.idEmpresa = :empresaId AND p.estado = true")
    public List<Personal> findByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="SELECT p FROM Personal p WHERE p.sucursal.idSucursal = :sucursalId AND p.estado = true")
    public List<Personal> findBySucursalId(@Param(value="sucursalId") Long var1);

    @Query(value="SELECT p FROM Personal p WHERE p.cargo = :cargo AND p.empresa.idEmpresa = :empresaId AND p.estado = true")
    public List<Personal> findByCargoAndEmpresaId(@Param(value="cargo") Personal.Cargo var1, @Param(value="empresaId") Long var2);

    @Query(value="SELECT p FROM Personal p WHERE p.estado = :estado AND p.empresa.idEmpresa = :empresaId")
    public List<Personal> findByEstadoAndEmpresaId(@Param(value="estado") Boolean var1, @Param(value="empresaId") Long var2);

    @Query(value="SELECT p FROM Personal p WHERE p.dni = :dni AND p.empresa.idEmpresa = :empresaId AND p.estado = true")
    public Optional<Personal> findByDniAndEmpresaId(@Param(value="dni") String var1, @Param(value="empresaId") Long var2);

    @Query(value="SELECT p FROM Personal p WHERE p.email = :email AND p.empresa.idEmpresa = :empresaId AND p.estado = true")
    public Optional<Personal> findByEmailAndEmpresaId(@Param(value="email") String var1, @Param(value="empresaId") Long var2);

    @Query(value="SELECT p FROM Personal p WHERE (:empresaId IS NULL OR p.empresa.idEmpresa = :empresaId) AND (:sucursalId IS NULL OR p.sucursal.idSucursal = :sucursalId) AND (:cargo IS NULL OR p.cargo = :cargo) AND (:estado IS NULL OR p.estado = :estado) AND (:busqueda IS NULL OR LOWER(CONCAT(p.nombre, ' ', p.apellido)) LIKE LOWER(CONCAT('%', :busqueda, '%')))")
    public List<Personal> findWithFilters(@Param(value="empresaId") Long var1, @Param(value="sucursalId") Long var2, @Param(value="cargo") Personal.Cargo var3, @Param(value="estado") Boolean var4, @Param(value="busqueda") String var5);

    @Query(value="SELECT COUNT(p) > 0 FROM Personal p WHERE p.dni = :dni AND p.empresa.idEmpresa = :empresaId AND p.idPersonal != :excludeId AND p.estado = true")
    public boolean existsByDniAndEmpresaIdAndIdNot(@Param(value="dni") String var1, @Param(value="empresaId") Long var2, @Param(value="excludeId") Long var3);

    @Query(value="SELECT COUNT(p) > 0 FROM Personal p WHERE p.email = :email AND p.empresa.idEmpresa = :empresaId AND p.idPersonal != :excludeId AND p.estado = true")
    public boolean existsByEmailAndEmpresaIdAndIdNot(@Param(value="email") String var1, @Param(value="empresaId") Long var2, @Param(value="excludeId") Long var3);

    @Query(value="SELECT COUNT(p) FROM Personal p WHERE p.empresa.idEmpresa = :empresaId AND p.estado = true")
    public Long countActivoByEmpresaId(@Param(value="empresaId") Long var1);
}

