/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.PaqueteResponse;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.PaqueteServicio;
import com.sistema.turistico.entity.PaqueteTuristico;
import com.sistema.turistico.entity.ServicioTuristico;
import com.sistema.turistico.repository.EmpresaRepository;
import com.sistema.turistico.repository.PaqueteTuristicoRepository;
import com.sistema.turistico.repository.ServicioTuristicoRepository;
import com.sistema.turistico.security.TenantContext;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PaqueteTuristicoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PaqueteTuristicoService.class);
    private final PaqueteTuristicoRepository paqueteRepository;
    private final ServicioTuristicoRepository servicioRepository;
    private final EmpresaRepository empresaRepository;

    @Transactional
    public PaqueteTuristico create(PaqueteTuristico paquete) {
        log.info("Creando paquete tur\u00edstico: {}", (Object)(paquete != null ? paquete.getNombrePaquete() : null));
        if (paquete == null) {
            throw new IllegalArgumentException("El paquete es obligatorio");
        }
        Long empresaSolicitada = paquete.getEmpresa() != null ? paquete.getEmpresa().getIdEmpresa() : null;
        Long empresaId = TenantContext.requireEmpresaIdOrCurrent((Long)empresaSolicitada);
        Empresa empresa = this.obtenerEmpresaActiva(empresaId);
        this.validarDatosPaquete(paquete);
        this.validarServiciosIncluidos(paquete, empresaId);
        paquete.setEmpresa(empresa);
        if (paquete.getEstado() == null) {
            paquete.setEstado(Boolean.TRUE);
        }
        if (this.paqueteRepository.existsByEmpresaIdEmpresaAndNombrePaqueteAndIdPaqueteNot(empresaId, paquete.getNombrePaquete(), null)) {
            throw new IllegalArgumentException("Ya existe un paquete con este nombre en la empresa");
        }
        if (paquete.getPrecioTotal() == null && paquete.tieneServicios()) {
            paquete.setPrecioTotal(this.calcularPrecioTotal(paquete));
        }
        PaqueteTuristico paqueteGuardado = (PaqueteTuristico)this.paqueteRepository.save((Object)paquete);
        log.info("Paquete tur\u00edstico creado exitosamente con ID: {}", (Object)paqueteGuardado.getIdPaquete());
        return paqueteGuardado;
    }

    @Transactional(readOnly=true)
    public Optional<PaqueteTuristico> findById(Long id) {
        log.debug("Buscando paquete tur\u00edstico con ID: {}", (Object)id);
        return this.paqueteRepository.findById((Object)id).filter(paquete -> paquete.getDeletedAt() == null).map(paquete -> {
            this.validarPertenencia(paquete);
            return paquete;
        });
    }

    @Transactional(readOnly=true)
    public List<PaqueteTuristico> findByEmpresaId(Long empresaId) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Buscando paquetes de empresa ID: {}", (Object)empresaFiltrada);
        return this.paqueteRepository.findByEmpresaIdEmpresa(empresaFiltrada).stream().filter(paquete -> paquete.getDeletedAt() == null).toList();
    }

    @Transactional(readOnly=true)
    public List<PaqueteTuristico> findByEmpresaIdAndBusqueda(Long empresaId, String busqueda) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Buscando paquetes de empresa {} con b\u00fasqueda: {}", (Object)empresaFiltrada, (Object)busqueda);
        List paquetes = busqueda == null || busqueda.trim().isEmpty() ? this.paqueteRepository.findByEmpresaIdEmpresa(empresaFiltrada) : this.paqueteRepository.findByEmpresaIdAndBusqueda(empresaFiltrada, busqueda.trim());
        return paquetes.stream().filter(paquete -> paquete.getDeletedAt() == null).toList();
    }

    @Transactional(readOnly=true)
    public List<PaqueteTuristico> findPaquetesDisponiblesByEmpresaId(Long empresaId) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Buscando paquetes disponibles de empresa ID: {}", (Object)empresaFiltrada);
        return this.paqueteRepository.findPaquetesDisponiblesByEmpresaId(empresaFiltrada);
    }

    @Transactional
    public PaqueteTuristico update(Long id, PaqueteTuristico paquete) {
        log.info("Actualizando paquete tur\u00edstico ID: {}", (Object)id);
        if (paquete == null) {
            throw new IllegalArgumentException("El paquete es obligatorio");
        }
        PaqueteTuristico paqueteExistente = this.obtenerPaqueteAutorizado(id);
        this.validarDatosPaquete(paquete);
        if (this.paqueteRepository.existsByEmpresaIdEmpresaAndNombrePaqueteAndIdPaqueteNot(paqueteExistente.getEmpresa().getIdEmpresa(), paquete.getNombrePaquete(), id)) {
            throw new IllegalArgumentException("Ya existe otro paquete con este nombre en la empresa");
        }
        paqueteExistente.setNombrePaquete(paquete.getNombrePaquete());
        paqueteExistente.setDescripcion(paquete.getDescripcion());
        paqueteExistente.setPrecioTotal(paquete.getPrecioTotal());
        paqueteExistente.setDuracionDias(paquete.getDuracionDias());
        paqueteExistente.setPromocion(paquete.getPromocion());
        paqueteExistente.setDescuento(paquete.getDescuento());
        paqueteExistente.setEstado(paquete.getEstado());
        PaqueteTuristico paqueteActualizado = (PaqueteTuristico)this.paqueteRepository.save((Object)paqueteExistente);
        log.info("Paquete tur\u00edstico actualizado exitosamente");
        return paqueteActualizado;
    }

    @Transactional
    public void delete(Long id) {
        log.info("Eliminando paquete tur\u00edstico ID: {}", (Object)id);
        PaqueteTuristico paquete = this.obtenerPaqueteAutorizado(id);
        if (paquete.getDeletedAt() != null) {
            throw new IllegalArgumentException("El paquete ya fue eliminado");
        }
        paquete.setDeletedAt(LocalDateTime.now());
        paquete.setEstado(Boolean.valueOf(false));
        this.paqueteRepository.save((Object)paquete);
        log.info("Paquete tur\u00edstico eliminado (soft delete)");
    }

    @Transactional
    public PaqueteTuristico agregarServicio(Long paqueteId, Long servicioId, Integer orden) {
        log.info("Agregando servicio {} al paquete {}", (Object)servicioId, (Object)paqueteId);
        PaqueteTuristico paquete = this.obtenerPaqueteAutorizado(paqueteId);
        ServicioTuristico servicio = (ServicioTuristico)this.servicioRepository.findById((Object)servicioId).orElseThrow(() -> new IllegalArgumentException("Servicio tur\u00edstico no encontrado"));
        this.validarMismaEmpresa(paquete.getEmpresa().getIdEmpresa(), servicio.getEmpresa() != null ? servicio.getEmpresa().getIdEmpresa() : null, "servicio tur\u00edstico");
        if (!servicio.isActivo()) {
            throw new IllegalArgumentException("No se puede agregar un servicio inactivo al paquete");
        }
        boolean yaIncluido = paquete.getServiciosIncluidos().stream().anyMatch(ps -> ps.getServicio().getIdServicio().equals(servicioId));
        if (yaIncluido) {
            throw new IllegalArgumentException("El servicio ya est\u00e1 incluido en este paquete");
        }
        paquete.agregarServicio(servicio, orden);
        paquete.setPrecioTotal(this.calcularPrecioTotal(paquete));
        PaqueteTuristico paqueteActualizado = (PaqueteTuristico)this.paqueteRepository.save((Object)paquete);
        log.info("Servicio agregado al paquete exitosamente");
        return paqueteActualizado;
    }

    @Transactional
    public PaqueteTuristico removerServicio(Long paqueteId, Long servicioId) {
        log.info("Removiendo servicio {} del paquete {}", (Object)servicioId, (Object)paqueteId);
        PaqueteTuristico paquete = this.obtenerPaqueteAutorizado(paqueteId);
        ServicioTuristico servicio = (ServicioTuristico)this.servicioRepository.findById((Object)servicioId).orElseThrow(() -> new IllegalArgumentException("Servicio tur\u00edstico no encontrado"));
        boolean estaIncluido = paquete.getServiciosIncluidos().stream().anyMatch(ps -> ps.getServicio().getIdServicio().equals(servicioId));
        if (!estaIncluido) {
            throw new IllegalArgumentException("El servicio no est\u00e1 incluido en este paquete");
        }
        paquete.removerServicio(servicio);
        if (paquete.tieneServicios()) {
            paquete.setPrecioTotal(this.calcularPrecioTotal(paquete));
        } else {
            paquete.setPrecioTotal(BigDecimal.valueOf(0.01));
        }
        PaqueteTuristico paqueteActualizado = (PaqueteTuristico)this.paqueteRepository.save((Object)paquete);
        log.info("Servicio removido del paquete exitosamente");
        return paqueteActualizado;
    }

    public BigDecimal calcularPrecioTotal(PaqueteTuristico paquete) {
        if (paquete.getServiciosIncluidos() == null || paquete.getServiciosIncluidos().isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal total = paquete.getServiciosIncluidos().stream().filter(PaqueteServicio::isServicioActivo).map(PaqueteServicio::getPrecioServicio).reduce(BigDecimal.ZERO, BigDecimal::add);
        return total;
    }

    private void validarDatosPaquete(PaqueteTuristico paquete) {
        if (paquete.getNombrePaquete() == null || paquete.getNombrePaquete().trim().isEmpty()) {
            throw new IllegalArgumentException("El nombre del paquete es obligatorio");
        }
        if (paquete.getPrecioTotal() != null && paquete.getPrecioTotal().compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("El precio total debe ser mayor a 0");
        }
        if (paquete.getDuracionDias() != null && paquete.getDuracionDias() <= 0) {
            throw new IllegalArgumentException("La duraci\u00f3n debe ser mayor a 0 d\u00edas");
        }
        if (paquete.getDescuento() != null && (paquete.getDescuento().compareTo(BigDecimal.ZERO) < 0 || paquete.getDescuento().compareTo(BigDecimal.valueOf(100L)) > 0)) {
            throw new IllegalArgumentException("El descuento debe estar entre 0% y 100%");
        }
    }

    private void validarServiciosIncluidos(PaqueteTuristico paquete, Long empresaId) {
        if (paquete.getServiciosIncluidos() == null) {
            return;
        }
        for (PaqueteServicio paqueteServicio : paquete.getServiciosIncluidos()) {
            if (paqueteServicio == null || paqueteServicio.getServicio() == null || paqueteServicio.getServicio().getIdServicio() == null) {
                throw new IllegalArgumentException("Cada servicio incluido debe tener un identificador v\u00e1lido");
            }
            ServicioTuristico servicio = (ServicioTuristico)this.servicioRepository.findById((Object)paqueteServicio.getServicio().getIdServicio()).orElseThrow(() -> new IllegalArgumentException("Servicio tur\u00edstico no encontrado"));
            this.validarMismaEmpresa(empresaId, servicio.getEmpresa() != null ? servicio.getEmpresa().getIdEmpresa() : null, "servicio tur\u00edstico incluido");
            if (!servicio.isActivo()) {
                throw new IllegalArgumentException("El servicio " + servicio.getNombreServicio() + " no est\u00e1 activo");
            }
            paqueteServicio.setPaquete(paquete);
            paqueteServicio.setServicio(servicio);
        }
    }

    public PaqueteResponse toResponse(PaqueteTuristico paquete) {
        PaqueteResponse response = new PaqueteResponse();
        response.setIdPaquete(paquete.getIdPaquete());
        response.setNombrePaquete(paquete.getNombrePaquete());
        response.setDescripcion(paquete.getDescripcion());
        response.setPrecioTotal(paquete.getPrecioTotal());
        response.setDuracionDias(paquete.getDuracionDias());
        response.setPromocion(paquete.getPromocion());
        response.setDescuento(paquete.getDescuento());
        response.setEstado(paquete.getEstado());
        response.setCreatedAt(paquete.getCreatedAt());
        response.setUpdatedAt(paquete.getUpdatedAt());
        if (paquete.getServiciosIncluidos() != null) {
            response.setNumeroServicios(Integer.valueOf(paquete.getServiciosIncluidos().size()));
            List<PaqueteResponse.ServicioSimplificado> serviciosSimplificados = paquete.getServiciosIncluidos().stream().filter(PaqueteServicio::isServicioActivo).map(ps -> {
                PaqueteResponse.ServicioSimplificado ss = new PaqueteResponse.ServicioSimplificado();
                ss.setIdServicio(ps.getServicio().getIdServicio());
                ss.setNombreServicio(ps.getServicio().getNombreServicio());
                ss.setTipoServicio(ps.getServicio().getTipoServicio().toString());
                ss.setOrden(ps.getOrden());
                return ss;
            }).toList();
            response.setServiciosIncluidos(serviciosSimplificados);
        } else {
            response.setNumeroServicios(Integer.valueOf(0));
            response.setServiciosIncluidos(List.of());
        }
        return response;
    }

    private PaqueteTuristico obtenerPaqueteAutorizado(Long id) {
        PaqueteTuristico paquete = (PaqueteTuristico)this.paqueteRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Paquete tur\u00edstico no encontrado"));
        if (paquete.getDeletedAt() != null) {
            throw new IllegalArgumentException("Paquete tur\u00edstico no encontrado");
        }
        this.validarPertenencia(paquete);
        return paquete;
    }

    private boolean esSuperAdmin() {
        return TenantContext.isSuperAdmin();
    }

    private void validarMismaEmpresa(Long empresaEsperada, Long empresaRelacionada, String recurso) {
        if (empresaEsperada == null || empresaRelacionada == null || !empresaEsperada.equals(empresaRelacionada)) {
            throw new IllegalArgumentException("El " + recurso + " no pertenece a la empresa actual");
        }
    }

    private Empresa obtenerEmpresaActiva(Long empresaId) {
        return (Empresa)this.empresaRepository.findActivaById(empresaId).orElseThrow(() -> new IllegalArgumentException("Empresa no encontrada"));
    }

    private void validarPertenencia(PaqueteTuristico paquete) {
        if (!this.esSuperAdmin()) {
            Long empresaPaquete;
            Long empresaActual = TenantContext.requireEmpresaId();
            Long l = empresaPaquete = paquete.getEmpresa() != null ? paquete.getEmpresa().getIdEmpresa() : null;
            if (!empresaActual.equals(empresaPaquete)) {
                throw new IllegalArgumentException("El paquete no pertenece a la empresa actual");
            }
        }
    }

    @Generated
    public PaqueteTuristicoService(PaqueteTuristicoRepository paqueteRepository, ServicioTuristicoRepository servicioRepository, EmpresaRepository empresaRepository) {
        this.paqueteRepository = paqueteRepository;
        this.servicioRepository = servicioRepository;
        this.empresaRepository = empresaRepository;
    }
}

