/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.service.ReportesService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reportes"})
@Tag(name="Reportes Generales", description="Reportes de reservas, ventas, clientes, personal y servicios")
public class ReportesController {
    private static final Logger log = LoggerFactory.getLogger(ReportesController.class);
    private final ReportesService reportesService;

    @GetMapping(value={"/reservas"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Reporte de reservas", description="Obtiene estad\u00edsticas de reservas por empresa en un per\u00edodo")
    public ResponseEntity<Map<String, Object>> reporteReservas(@RequestParam(required=false) Long empresaId, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaInicio, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaFin, @RequestParam(required=false) String estado) {
        try {
            Map data = this.reportesService.reporteReservas(empresaId, fechaInicio, fechaFin, estado);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reporte de reservas obtenido correctamente");
            response.put("data", data);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Solicitud inv\u00e1lida para reporte de reservas: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener reporte de reservas", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/ventas"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Reporte de ventas", description="Obtiene estad\u00edsticas de ventas por empresa en un per\u00edodo")
    public ResponseEntity<Map<String, Object>> reporteVentas(@RequestParam(required=false) Long empresaId, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaInicio, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaFin) {
        try {
            Map data = this.reportesService.reporteVentas(empresaId, fechaInicio, fechaFin);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reporte de ventas obtenido correctamente");
            response.put("data", data);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Solicitud inv\u00e1lida para reporte de ventas: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener reporte de ventas", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/clientes"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Reporte de clientes", description="Obtiene estad\u00edsticas de clientes por empresa")
    public ResponseEntity<Map<String, Object>> reporteClientes(@RequestParam(required=false) Long empresaId) {
        try {
            Map data = this.reportesService.reporteClientes(empresaId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reporte de clientes obtenido correctamente");
            response.put("data", data);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Solicitud inv\u00e1lida para reporte de clientes: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener reporte de clientes", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/personal"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Reporte de personal", description="Obtiene estad\u00edsticas de personal por empresa")
    public ResponseEntity<Map<String, Object>> reportePersonal(@RequestParam(required=false) Long empresaId) {
        try {
            Map data = this.reportesService.reportePersonal(empresaId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reporte de personal obtenido correctamente");
            response.put("data", data);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Solicitud inv\u00e1lida para reporte de personal: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener reporte de personal", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/servicios"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Reporte de servicios tur\u00edsticos", description="Obtiene estad\u00edsticas de servicios por empresa")
    public ResponseEntity<Map<String, Object>> reporteServicios(@RequestParam(required=false) Long empresaId) {
        try {
            Map data = this.reportesService.reporteServicios(empresaId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reporte de servicios obtenido correctamente");
            response.put("data", data);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Solicitud inv\u00e1lida para reporte de servicios: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener reporte de servicios", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/paquetes"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Reporte de paquetes tur\u00edsticos", description="Obtiene estad\u00edsticas de paquetes por empresa")
    public ResponseEntity<Map<String, Object>> reportePaquetes(@RequestParam(required=false) Long empresaId) {
        try {
            Map data = this.reportesService.reportePaquetes(empresaId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reporte de paquetes obtenido correctamente");
            response.put("data", data);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Solicitud inv\u00e1lida para reporte de paquetes: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener reporte de paquetes", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    public ReportesController(ReportesService reportesService) {
        this.reportesService = reportesService;
    }
}

