/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.SucursalRequest;
import com.sistema.turistico.dto.SucursalResponse;
import com.sistema.turistico.entity.Sucursal;
import com.sistema.turistico.service.SucursalService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sucursales"})
@Tag(name="Sucursales", description="Endpoints para gesti\u00f3n de sucursales")
public class SucursalController {
    private static final Logger log = LoggerFactory.getLogger(SucursalController.class);
    private final SucursalService sucursalService;

    @PostMapping
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR')")
    @Operation(summary="Crear sucursal", description="Crea una nueva sucursal")
    public ResponseEntity<Map<String, Object>> crearSucursal(@Valid @RequestBody SucursalRequest request) {
        try {
            log.info("Solicitando creaci\u00f3n de sucursal");
            Sucursal sucursal = this.sucursalService.crear(request);
            SucursalResponse data = this.sucursalService.toResponse(sucursal);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Sucursal creada exitosamente");
            response.put("data", data);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al crear sucursal: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error interno al crear sucursal", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR')")
    @Operation(summary="Listar sucursales", description="Obtiene la lista de sucursales")
    public ResponseEntity<Map<String, Object>> listarSucursales(@RequestParam(required=false) String busqueda, @RequestParam(required=false) Integer estado, @RequestParam(required=false) Long empresaId) {
        try {
            log.info("Listando sucursales con filtros: busqueda={}, estado={}, empresaId={}", new Object[]{busqueda, estado, empresaId});
            List sucursales = this.sucursalService.listar(busqueda, estado, empresaId);
            List<SucursalResponse> data = sucursales.stream().map(arg_0 -> ((SucursalService)this.sucursalService).toResponse(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Sucursales obtenidas exitosamente");
            response.put("data", data);
            response.put("total", data.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar sucursales", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR')")
    @Operation(summary="Obtener sucursal", description="Obtiene una sucursal por su identificador")
    public ResponseEntity<Map<String, Object>> obtenerSucursal(@PathVariable Long id) {
        try {
            log.info("Obteniendo sucursal {}", (Object)id);
            Sucursal sucursal = this.sucursalService.obtenerPorId(id);
            SucursalResponse data = this.sucursalService.toResponse(sucursal);
            return ResponseEntity.ok(Map.of("success", true, "message", "Sucursal obtenida exitosamente", "data", data));
        }
        catch (IllegalArgumentException ex) {
            log.warn("Sucursal no encontrada: {}", (Object)ex.getMessage());
            return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener sucursal {}", (Object)id, (Object)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR')")
    @Operation(summary="Actualizar sucursal", description="Actualiza los datos de una sucursal")
    public ResponseEntity<Map<String, Object>> actualizarSucursal(@PathVariable Long id, @Valid @RequestBody SucursalRequest request) {
        try {
            log.info("Actualizando sucursal {}", (Object)id);
            Sucursal sucursal = this.sucursalService.actualizar(id, request);
            SucursalResponse data = this.sucursalService.toResponse(sucursal);
            return ResponseEntity.ok(Map.of("success", true, "message", "Sucursal actualizada exitosamente", "data", data));
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al actualizar sucursal: {}", (Object)ex.getMessage());
            if ("Sucursal no encontrada".equalsIgnoreCase(ex.getMessage()) || "Empresa no encontrada".equalsIgnoreCase(ex.getMessage())) {
                return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
            }
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error interno al actualizar sucursal {}", (Object)id, (Object)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR')")
    @Operation(summary="Eliminar sucursal", description="Realiza un borrado l\u00f3gico de una sucursal")
    public ResponseEntity<Map<String, Object>> eliminarSucursal(@PathVariable Long id) {
        try {
            log.info("Eliminando sucursal {}", (Object)id);
            this.sucursalService.eliminar(id);
            return ResponseEntity.ok(Map.of("success", true, "message", "Sucursal eliminada exitosamente"));
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al eliminar sucursal: {}", (Object)ex.getMessage());
            if ("Sucursal no encontrada".equalsIgnoreCase(ex.getMessage())) {
                return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
            }
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error interno al eliminar sucursal {}", (Object)id, (Object)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    public SucursalController(SucursalService sucursalService) {
        this.sucursalService = sucursalService;
    }
}

