/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Modulo;
import com.sistema.turistico.entity.Rol;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Set;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="permisos")
@EntityListeners(value={AuditingEntityListener.class})
public class Permiso {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_permiso")
    private Long idPermiso;
    @NotBlank(message="El nombre del permiso es obligatorio")
    @Size(max=100, message="El nombre del permiso no puede exceder 100 caracteres")
    @Column(name="nombre_permiso", nullable=false, length=100)
    private @NotBlank(message="El nombre del permiso es obligatorio") @Size(max=100, message="El nombre del permiso no puede exceder 100 caracteres") String nombrePermiso;
    @Size(max=500, message="La descripci\u00f3n no puede exceder 500 caracteres")
    @Column(name="descripcion", columnDefinition="TEXT")
    private @Size(max=500, message="La descripci\u00f3n no puede exceder 500 caracteres") String descripcion;
    @Column(name="estado", nullable=false)
    private Integer estado = 1;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_modulo", nullable=false)
    private Modulo modulo;
    @CreatedDate
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @LastModifiedDate
    @Column(name="updated_at", nullable=false)
    private LocalDateTime updatedAt;
    @ManyToMany(mappedBy="permisos", fetch=FetchType.LAZY)
    private Set<Rol> roles;

    public Long getIdPermiso() {
        return this.idPermiso;
    }

    public String getNombrePermiso() {
        return this.nombrePermiso;
    }

    public String getDescripcion() {
        return this.descripcion;
    }

    public Integer getEstado() {
        return this.estado;
    }

    public Modulo getModulo() {
        return this.modulo;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public Set<Rol> getRoles() {
        return this.roles;
    }

    public void setIdPermiso(Long idPermiso) {
        this.idPermiso = idPermiso;
    }

    public void setNombrePermiso(String nombrePermiso) {
        this.nombrePermiso = nombrePermiso;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public void setEstado(Integer estado) {
        this.estado = estado;
    }

    public void setModulo(Modulo modulo) {
        this.modulo = modulo;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setRoles(Set<Rol> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Permiso)) {
            return false;
        }
        Permiso other = (Permiso)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idPermiso = this.getIdPermiso();
        Long other$idPermiso = other.getIdPermiso();
        if (this$idPermiso == null ? other$idPermiso != null : !((Object)this$idPermiso).equals(other$idPermiso)) {
            return false;
        }
        Integer this$estado = this.getEstado();
        Integer other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        String this$nombrePermiso = this.getNombrePermiso();
        String other$nombrePermiso = other.getNombrePermiso();
        if (this$nombrePermiso == null ? other$nombrePermiso != null : !this$nombrePermiso.equals(other$nombrePermiso)) {
            return false;
        }
        String this$descripcion = this.getDescripcion();
        String other$descripcion = other.getDescripcion();
        if (this$descripcion == null ? other$descripcion != null : !this$descripcion.equals(other$descripcion)) {
            return false;
        }
        Modulo this$modulo = this.getModulo();
        Modulo other$modulo = other.getModulo();
        if (this$modulo == null ? other$modulo != null : !this$modulo.equals(other$modulo)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Set this$roles = this.getRoles();
        Set other$roles = other.getRoles();
        return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Permiso;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idPermiso = this.getIdPermiso();
        result = result * 59 + ($idPermiso == null ? 43 : ((Object)$idPermiso).hashCode());
        Integer $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        String $nombrePermiso = this.getNombrePermiso();
        result = result * 59 + ($nombrePermiso == null ? 43 : $nombrePermiso.hashCode());
        String $descripcion = this.getDescripcion();
        result = result * 59 + ($descripcion == null ? 43 : $descripcion.hashCode());
        Modulo $modulo = this.getModulo();
        result = result * 59 + ($modulo == null ? 43 : $modulo.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Set $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        return result;
    }

    public String toString() {
        return "Permiso(idPermiso=" + this.getIdPermiso() + ", nombrePermiso=" + this.getNombrePermiso() + ", descripcion=" + this.getDescripcion() + ", estado=" + this.getEstado() + ", modulo=" + String.valueOf(this.getModulo()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", roles=" + String.valueOf(this.getRoles()) + ")";
    }

    public Permiso() {
    }

    public Permiso(Long idPermiso, String nombrePermiso, String descripcion, Integer estado, Modulo modulo, LocalDateTime createdAt, LocalDateTime updatedAt, Set<Rol> roles) {
        this.idPermiso = idPermiso;
        this.nombrePermiso = nombrePermiso;
        this.descripcion = descripcion;
        this.estado = estado;
        this.modulo = modulo;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.roles = roles;
    }
}

