/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.Personal;
import com.sistema.turistico.entity.Sucursal;
import com.sistema.turistico.repository.EmpresaRepository;
import com.sistema.turistico.repository.PersonalRepository;
import com.sistema.turistico.repository.SucursalRepository;
import com.sistema.turistico.security.TenantContext;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PersonalService {
    private static final Logger log = LoggerFactory.getLogger(PersonalService.class);
    private final PersonalRepository personalRepository;
    private final EmpresaRepository empresaRepository;
    private final SucursalRepository sucursalRepository;

    @Transactional
    public Personal crearPersonal(Personal personal) {
        log.info("Creando nuevo personal: {} {}", (Object)(personal != null ? personal.getNombre() : null), (Object)(personal != null ? personal.getApellido() : null));
        if (personal == null) {
            throw new IllegalArgumentException("El personal es obligatorio");
        }
        Long empresaSolicitada = personal.getEmpresa() != null ? personal.getEmpresa().getIdEmpresa() : null;
        Long empresaId = TenantContext.requireEmpresaIdOrCurrent((Long)empresaSolicitada);
        Empresa empresa = this.obtenerEmpresaActiva(empresaId);
        this.normalizarPersonal(personal);
        this.validarIdentificadores(personal.getDni(), personal.getEmail(), empresaId, null);
        Sucursal sucursal = null;
        if (personal.getSucursal() != null && personal.getSucursal().getIdSucursal() != null) {
            sucursal = this.obtenerSucursalAutorizada(personal.getSucursal().getIdSucursal(), empresaId);
        }
        personal.setEmpresa(empresa);
        personal.setSucursal(sucursal);
        personal.setEstado(personal.getEstado() != null ? personal.getEstado() : Boolean.TRUE);
        personal.setDeletedAt(null);
        Personal creado = (Personal)this.personalRepository.save((Object)personal);
        log.info("Personal creado exitosamente con ID: {}", (Object)creado.getIdPersonal());
        return creado;
    }

    @Transactional(readOnly=true)
    public Optional<Personal> obtenerPersonalPorId(Long id) {
        return this.personalRepository.findById((Object)id).filter(personal -> personal.getDeletedAt() == null).map(personal -> {
            this.validarPertenencia(personal);
            return personal;
        });
    }

    @Transactional(readOnly=true)
    public List<Personal> listarPersonalPorEmpresa(Long empresaId) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId, (String)"La empresa es obligatoria para listar personal");
        if (empresaFiltrada == null) {
            throw new IllegalArgumentException("La empresa es obligatoria para listar personal");
        }
        return this.personalRepository.findByEmpresaId(empresaFiltrada).stream().filter(personal -> personal.getDeletedAt() == null).toList();
    }

    @Transactional(readOnly=true)
    public List<Personal> listarPersonalConFiltros(Long empresaId, Long sucursalId, Personal.Cargo cargo, Boolean estado, String busqueda) {
        boolean superAdmin = TenantContext.isSuperAdmin();
        Long empresaFiltrada = TenantContext.resolveEmpresaId((Long)empresaId);
        Long sucursalFiltrada = sucursalId;
        if (sucursalId != null) {
            if (superAdmin) {
                this.obtenerSucursalAutorizada(sucursalId, empresaFiltrada);
            } else {
                this.obtenerSucursalAutorizada(sucursalId, TenantContext.requireEmpresaId());
            }
        }
        return this.personalRepository.findWithFilters(empresaFiltrada, sucursalFiltrada, cargo, estado, this.normalizarBusqueda(busqueda)).stream().filter(personal -> personal.getDeletedAt() == null).filter(personal -> superAdmin || this.perteneceAEmpresaActual(personal)).toList();
    }

    @Transactional
    public Personal actualizarPersonal(Long id, Personal personalActualizado) {
        log.info("Actualizando personal ID: {}", (Object)id);
        if (personalActualizado == null) {
            throw new IllegalArgumentException("El personal es obligatorio");
        }
        Personal personalExistente = this.obtenerPersonalAutorizado(id);
        Long empresaSolicitada = personalActualizado.getEmpresa() != null ? personalActualizado.getEmpresa().getIdEmpresa() : personalExistente.getEmpresa().getIdEmpresa();
        Long empresaId = TenantContext.requireEmpresaIdOrCurrent((Long)empresaSolicitada);
        Empresa empresa = this.obtenerEmpresaActiva(empresaId);
        this.normalizarPersonal(personalActualizado);
        this.validarIdentificadores(personalActualizado.getDni(), personalActualizado.getEmail(), empresaId, id);
        Sucursal sucursal = null;
        if (personalActualizado.getSucursal() != null && personalActualizado.getSucursal().getIdSucursal() != null) {
            sucursal = this.obtenerSucursalAutorizada(personalActualizado.getSucursal().getIdSucursal(), empresaId);
        }
        personalExistente.setNombre(personalActualizado.getNombre());
        personalExistente.setApellido(personalActualizado.getApellido());
        personalExistente.setDni(personalActualizado.getDni());
        personalExistente.setFechaNacimiento(personalActualizado.getFechaNacimiento());
        personalExistente.setTelefono(personalActualizado.getTelefono());
        personalExistente.setEmail(personalActualizado.getEmail());
        personalExistente.setDireccion(personalActualizado.getDireccion());
        personalExistente.setCargo(personalActualizado.getCargo());
        personalExistente.setFechaIngreso(personalActualizado.getFechaIngreso());
        personalExistente.setTurno(personalActualizado.getTurno());
        personalExistente.setSueldo(personalActualizado.getSueldo());
        personalExistente.setFoto(personalActualizado.getFoto());
        if (personalActualizado.getEstado() != null) {
            personalExistente.setEstado(personalActualizado.getEstado());
        }
        personalExistente.setEmpresa(empresa);
        personalExistente.setSucursal(sucursal);
        Personal actualizado = (Personal)this.personalRepository.save((Object)personalExistente);
        log.info("Personal actualizado exitosamente: {}", (Object)actualizado.getIdPersonal());
        return actualizado;
    }

    @Transactional
    public void eliminarPersonal(Long id) {
        log.info("Desactivando personal ID: {}", (Object)id);
        Personal personal = this.obtenerPersonalAutorizado(id);
        if (personal.getDeletedAt() != null) {
            throw new IllegalArgumentException("El personal ya fue eliminado");
        }
        personal.setEstado(Boolean.valueOf(false));
        personal.setDeletedAt(new Date());
        this.personalRepository.save((Object)personal);
        log.info("Personal desactivado exitosamente: {}", (Object)id);
    }

    @Transactional(readOnly=true)
    public List<Personal> obtenerPersonalPorCargo(Long empresaId, Personal.Cargo cargo) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId, (String)"La empresa es obligatoria para listar por cargo");
        if (empresaFiltrada == null) {
            throw new IllegalArgumentException("La empresa es obligatoria para listar por cargo");
        }
        return this.personalRepository.findByCargoAndEmpresaId(cargo, empresaFiltrada).stream().filter(personal -> personal.getDeletedAt() == null).toList();
    }

    @Transactional(readOnly=true)
    public Long contarPersonalActivo(Long empresaId) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId, (String)"La empresa es obligatoria para contar personal");
        if (empresaFiltrada == null) {
            throw new IllegalArgumentException("La empresa es obligatoria para contar personal");
        }
        return this.personalRepository.countActivoByEmpresaId(empresaFiltrada);
    }

    private void normalizarPersonal(Personal personal) {
        if (personal.getNombre() != null) {
            personal.setNombre(personal.getNombre().trim());
        }
        if (personal.getApellido() != null) {
            personal.setApellido(personal.getApellido().trim());
        }
        if (personal.getDni() != null) {
            personal.setDni(personal.getDni().trim());
        }
        if (personal.getTelefono() != null) {
            personal.setTelefono(personal.getTelefono().trim());
        }
        if (personal.getEmail() != null && !personal.getEmail().isBlank()) {
            personal.setEmail(personal.getEmail().trim().toLowerCase());
        } else {
            personal.setEmail(null);
        }
        if (personal.getDireccion() != null) {
            personal.setDireccion(personal.getDireccion().trim());
        }
    }

    private void validarIdentificadores(String dni, String email, Long empresaId, Long personalId) {
        if (dni != null && !dni.isBlank()) {
            boolean existeDni;
            boolean bl = existeDni = personalId == null ? this.personalRepository.findByDniAndEmpresaId(dni, empresaId).isPresent() : this.personalRepository.existsByDniAndEmpresaIdAndIdNot(dni, empresaId, personalId);
            if (existeDni) {
                throw new IllegalArgumentException("Ya existe personal con este DNI en la empresa");
            }
        }
        if (email != null && !email.isBlank()) {
            boolean existeEmail;
            boolean bl = existeEmail = personalId == null ? this.personalRepository.findByEmailAndEmpresaId(email, empresaId).isPresent() : this.personalRepository.existsByEmailAndEmpresaIdAndIdNot(email, empresaId, personalId);
            if (existeEmail) {
                throw new IllegalArgumentException("Ya existe personal con este email en la empresa");
            }
        }
    }

    private Personal obtenerPersonalAutorizado(Long id) {
        Personal personal = (Personal)this.personalRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Personal no encontrado"));
        if (personal.getDeletedAt() != null) {
            throw new IllegalArgumentException("Personal no encontrado");
        }
        this.validarPertenencia(personal);
        return personal;
    }

    private Sucursal obtenerSucursalAutorizada(Long sucursalId, Long empresaId) {
        Sucursal sucursal = (Sucursal)this.sucursalRepository.findActivaById(sucursalId).orElseThrow(() -> new IllegalArgumentException("Sucursal no encontrada"));
        if (empresaId != null) {
            Long empresaSucursal;
            Long l = empresaSucursal = sucursal.getEmpresa() != null ? sucursal.getEmpresa().getIdEmpresa() : null;
            if (!empresaId.equals(empresaSucursal)) {
                throw new IllegalArgumentException("La sucursal no pertenece a la empresa actual");
            }
        } else if (!this.esSuperAdmin()) {
            Long empresaSucursal;
            Long empresaActual = TenantContext.requireEmpresaId();
            Long l = empresaSucursal = sucursal.getEmpresa() != null ? sucursal.getEmpresa().getIdEmpresa() : null;
            if (!empresaActual.equals(empresaSucursal)) {
                throw new IllegalArgumentException("La sucursal no pertenece a la empresa actual");
            }
        }
        return sucursal;
    }

    private boolean perteneceAEmpresaActual(Personal personal) {
        Long empresaActual = TenantContext.requireEmpresaId();
        Long empresaPersonal = personal.getEmpresa() != null ? personal.getEmpresa().getIdEmpresa() : null;
        return empresaActual.equals(empresaPersonal);
    }

    private boolean esSuperAdmin() {
        return TenantContext.isSuperAdmin();
    }

    private Empresa obtenerEmpresaActiva(Long empresaId) {
        return (Empresa)this.empresaRepository.findActivaById(empresaId).orElseThrow(() -> new IllegalArgumentException("Empresa no encontrada"));
    }

    private void validarPertenencia(Personal personal) {
        if (!this.esSuperAdmin()) {
            Long empresaPersonal;
            Long empresaActual = TenantContext.requireEmpresaId();
            Long l = empresaPersonal = personal.getEmpresa() != null ? personal.getEmpresa().getIdEmpresa() : null;
            if (!empresaActual.equals(empresaPersonal)) {
                throw new IllegalArgumentException("El personal no pertenece a la empresa actual");
            }
        }
    }

    private String normalizarBusqueda(String busqueda) {
        return busqueda != null && !busqueda.trim().isEmpty() ? busqueda.trim() : null;
    }

    public PersonalService(PersonalRepository personalRepository, EmpresaRepository empresaRepository, SucursalRepository sucursalRepository) {
        this.personalRepository = personalRepository;
        this.empresaRepository = empresaRepository;
        this.sucursalRepository = sucursalRepository;
    }
}

