/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.RegisterRequest;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.Rol;
import com.sistema.turistico.entity.Usuario;
import com.sistema.turistico.repository.EmpresaRepository;
import com.sistema.turistico.repository.RolRepository;
import com.sistema.turistico.repository.UsuarioRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsuarioService {
    private static final Logger log = LoggerFactory.getLogger(UsuarioService.class);
    private final UsuarioRepository usuarioRepository;
    private final RolRepository rolRepository;
    private final EmpresaRepository empresaRepository;
    private final PasswordEncoder passwordEncoder;

    @Transactional
    public Usuario registrarUsuario(RegisterRequest request) {
        log.info("Registrando nuevo usuario: {}", (Object)request.getEmail());
        if (this.usuarioRepository.existsByEmail(request.getEmail())) {
            log.warn("Intento de registro con email ya existente: {}", (Object)request.getEmail());
            throw new IllegalArgumentException("Ya existe un usuario con este email");
        }
        if (request.getDni() != null && this.usuarioRepository.existsByDni(request.getDni())) {
            log.warn("Intento de registro con DNI ya existente: {}", (Object)request.getDni());
            throw new IllegalArgumentException("Ya existe un usuario con este DNI");
        }
        Rol rol = (Rol)this.rolRepository.findByNombreRol("Superadministrador").orElseThrow(() -> new IllegalArgumentException("Rol por defecto 'Superadministrador' no encontrado"));
        Empresa empresa = (Empresa)this.empresaRepository.findById((Object)1L).orElseThrow(() -> new IllegalArgumentException("Empresa por defecto (ID: 1) no encontrada"));
        Usuario usuario = new Usuario();
        usuario.setNombre(request.getNombre());
        usuario.setApellido(request.getApellido());
        usuario.setEmail(request.getEmail());
        usuario.setPasswordHash(this.passwordEncoder.encode((CharSequence)request.getPassword()));
        usuario.setDni(request.getDni());
        usuario.setEstado(Integer.valueOf(1));
        usuario.setEmpresa(empresa);
        usuario.setRol(rol);
        try {
            Usuario usuarioGuardado = (Usuario)this.usuarioRepository.save((Object)usuario);
            log.info("Usuario registrado exitosamente con ID: {}", (Object)usuarioGuardado.getIdUsuario());
            return usuarioGuardado;
        }
        catch (Exception e) {
            log.error("Error al guardar usuario en base de datos: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException("Error interno al registrar usuario");
        }
    }

    public UsuarioService(UsuarioRepository usuarioRepository, RolRepository rolRepository, EmpresaRepository empresaRepository, PasswordEncoder passwordEncoder) {
        this.usuarioRepository = usuarioRepository;
        this.rolRepository = rolRepository;
        this.empresaRepository = empresaRepository;
        this.passwordEncoder = passwordEncoder;
    }
}

