/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.AsignacionPersonalRequest;
import com.sistema.turistico.dto.AsignacionPersonalReservaRequest;
import com.sistema.turistico.dto.AsignacionPersonalUpdateRequest;
import com.sistema.turistico.entity.AsignacionPersonal;
import com.sistema.turistico.service.AsignacionPersonalService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/asignaciones-personal"})
@Tag(name="Asignaciones de Personal", description="Gesti\u00f3n de asignaciones de personal a reservas")
public class AsignacionPersonalController {
    private static final Logger log = LoggerFactory.getLogger(AsignacionPersonalController.class);
    private final AsignacionPersonalService asignacionService;

    @PostMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Crear asignaci\u00f3n", description="Asigna personal a una reserva")
    public ResponseEntity<Map<String, Object>> crearAsignacion(@Valid @RequestBody AsignacionPersonalRequest request) {
        try {
            AsignacionPersonal nuevaAsignacion = this.asignacionService.create(request);
            HashMap<String, Object> asignacionData = new HashMap<String, Object>();
            asignacionData.put("idAsignacion", nuevaAsignacion.getIdAsignacion());
            asignacionData.put("idPersonal", nuevaAsignacion.getPersonal().getIdPersonal());
            asignacionData.put("idReserva", nuevaAsignacion.getReserva().getIdReserva());
            asignacionData.put("rolAsignado", nuevaAsignacion.getRolAsignado().toString());
            asignacionData.put("fechaAsignacion", nuevaAsignacion.getFechaAsignacion());
            asignacionData.put("estado", nuevaAsignacion.getEstado().toString());
            asignacionData.put("observaciones", nuevaAsignacion.getObservaciones());
            asignacionData.put("createdAt", nuevaAsignacion.getCreatedAt());
            asignacionData.put("updatedAt", nuevaAsignacion.getUpdatedAt());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Asignaci\u00f3n creada exitosamente");
            response.put("data", asignacionData);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al crear asignaci\u00f3n: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al crear asignaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Obtener asignaci\u00f3n", description="Obtiene una asignaci\u00f3n espec\u00edfica por ID")
    public ResponseEntity<Map<String, Object>> obtenerAsignacion(@PathVariable Long id) {
        try {
            AsignacionPersonal asignacion = (AsignacionPersonal)this.asignacionService.findById(id).orElseThrow(() -> new IllegalArgumentException("Asignaci\u00f3n no encontrada"));
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Asignaci\u00f3n obtenida exitosamente");
            response.put("data", asignacion);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Asignaci\u00f3n no encontrada: {}", (Object)ex.getMessage());
            return ResponseEntity.notFound().build();
        }
        catch (Exception ex) {
            log.error("Error al obtener asignaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PostMapping(value={"/reserva/{reservaId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Crear asignaci\u00f3n para reserva", description="Asigna personal a una reserva espec\u00edfica")
    public ResponseEntity<Map<String, Object>> crearAsignacionParaReserva(@PathVariable Long reservaId, @Valid @RequestBody AsignacionPersonalReservaRequest request) {
        try {
            AsignacionPersonalRequest fullRequest = new AsignacionPersonalRequest();
            fullRequest.setIdPersonal(request.getIdPersonal());
            fullRequest.setIdReserva(reservaId);
            fullRequest.setFechaAsignacion(request.getFechaAsignacion());
            fullRequest.setObservaciones(request.getObservaciones());
            AsignacionPersonal nuevaAsignacion = this.asignacionService.create(fullRequest);
            HashMap<String, Object> asignacionData = new HashMap<String, Object>();
            asignacionData.put("idAsignacion", nuevaAsignacion.getIdAsignacion());
            asignacionData.put("idPersonal", nuevaAsignacion.getPersonal().getIdPersonal());
            asignacionData.put("idReserva", nuevaAsignacion.getReserva().getIdReserva());
            asignacionData.put("rolAsignado", nuevaAsignacion.getRolAsignado().toString());
            asignacionData.put("fechaAsignacion", nuevaAsignacion.getFechaAsignacion());
            asignacionData.put("estado", nuevaAsignacion.getEstado().toString());
            asignacionData.put("observaciones", nuevaAsignacion.getObservaciones());
            asignacionData.put("createdAt", nuevaAsignacion.getCreatedAt());
            asignacionData.put("updatedAt", nuevaAsignacion.getUpdatedAt());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Asignaci\u00f3n creada exitosamente");
            response.put("data", asignacionData);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al crear asignaci\u00f3n: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al crear asignaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/reserva/{reservaId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Asignaciones por reserva", description="Lista todas las asignaciones de una reserva")
    public ResponseEntity<Map<String, Object>> listarPorReserva(@PathVariable Long reservaId) {
        try {
            List asignaciones = this.asignacionService.findByReservaId(reservaId);
            List<Map> asignacionesSimplificadas = asignaciones.stream().map(asignacion -> {
                HashMap<String, Object> asignacionData = new HashMap<String, Object>();
                asignacionData.put("idAsignacion", asignacion.getIdAsignacion());
                asignacionData.put("idPersonal", asignacion.getPersonal().getIdPersonal());
                asignacionData.put("idReserva", asignacion.getReserva().getIdReserva());
                asignacionData.put("rolAsignado", asignacion.getRolAsignado().toString());
                asignacionData.put("fechaAsignacion", asignacion.getFechaAsignacion());
                asignacionData.put("estado", asignacion.getEstado().toString());
                asignacionData.put("observaciones", asignacion.getObservaciones());
                asignacionData.put("createdAt", asignacion.getCreatedAt());
                asignacionData.put("updatedAt", asignacion.getUpdatedAt());
                return asignacionData;
            }).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Asignaciones obtenidas exitosamente");
            response.put("data", asignacionesSimplificadas);
            response.put("total", asignaciones.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar asignaciones por reserva", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/personal/{personalId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Asignaciones por personal", description="Lista todas las asignaciones de un miembro del personal")
    public ResponseEntity<Map<String, Object>> listarPorPersonal(@PathVariable Long personalId) {
        try {
            List asignaciones = this.asignacionService.findByPersonalId(personalId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Asignaciones obtenidas exitosamente");
            response.put("data", asignaciones);
            response.put("total", asignaciones.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar asignaciones por personal", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/fecha/{fecha}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Asignaciones por fecha", description="Lista todas las asignaciones para una fecha espec\u00edfica")
    public ResponseEntity<Map<String, Object>> listarPorFecha(@PathVariable @DateTimeFormat(pattern="yyyy-MM-dd") Date fecha) {
        try {
            List asignaciones = this.asignacionService.findByFecha(fecha);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Asignaciones obtenidas exitosamente");
            response.put("data", asignaciones);
            response.put("total", asignaciones.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar asignaciones por fecha", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Actualizar asignaci\u00f3n", description="Actualiza el personal y observaciones de una asignaci\u00f3n")
    public ResponseEntity<Map<String, Object>> actualizarAsignacion(@PathVariable Long id, @Valid @RequestBody AsignacionPersonalUpdateRequest request) {
        try {
            AsignacionPersonal asignacionActualizada = this.asignacionService.update(id, request);
            HashMap<String, Object> asignacionData = new HashMap<String, Object>();
            asignacionData.put("idAsignacion", asignacionActualizada.getIdAsignacion());
            asignacionData.put("idPersonal", asignacionActualizada.getPersonal().getIdPersonal());
            asignacionData.put("idReserva", asignacionActualizada.getReserva().getIdReserva());
            asignacionData.put("rolAsignado", asignacionActualizada.getRolAsignado().toString());
            asignacionData.put("fechaAsignacion", asignacionActualizada.getFechaAsignacion());
            asignacionData.put("estado", asignacionActualizada.getEstado().toString());
            asignacionData.put("observaciones", asignacionActualizada.getObservaciones());
            asignacionData.put("createdAt", asignacionActualizada.getCreatedAt());
            asignacionData.put("updatedAt", asignacionActualizada.getUpdatedAt());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Asignaci\u00f3n actualizada exitosamente");
            response.put("data", asignacionData);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al actualizar asignaci\u00f3n: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al actualizar asignaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/{id}/completar"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Completar asignaci\u00f3n", description="Marca una asignaci\u00f3n como completada")
    public ResponseEntity<Map<String, Object>> completarAsignacion(@PathVariable Long id) {
        try {
            AsignacionPersonal asignacionCompletada = this.asignacionService.completar(id);
            HashMap<String, Object> asignacionData = new HashMap<String, Object>();
            asignacionData.put("idAsignacion", asignacionCompletada.getIdAsignacion());
            asignacionData.put("idPersonal", asignacionCompletada.getPersonal().getIdPersonal());
            asignacionData.put("idReserva", asignacionCompletada.getReserva().getIdReserva());
            asignacionData.put("rolAsignado", asignacionCompletada.getRolAsignado().toString());
            asignacionData.put("fechaAsignacion", asignacionCompletada.getFechaAsignacion());
            asignacionData.put("estado", asignacionCompletada.getEstado().toString());
            asignacionData.put("observaciones", asignacionCompletada.getObservaciones());
            asignacionData.put("createdAt", asignacionCompletada.getCreatedAt());
            asignacionData.put("updatedAt", asignacionCompletada.getUpdatedAt());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Asignaci\u00f3n completada exitosamente");
            response.put("data", asignacionData);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al completar asignaci\u00f3n: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al completar asignaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/{id}/cancelar"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Cancelar asignaci\u00f3n", description="Cancela una asignaci\u00f3n activa")
    public ResponseEntity<Map<String, Object>> cancelarAsignacion(@PathVariable Long id, @RequestParam String motivo) {
        try {
            AsignacionPersonal asignacionCancelada = this.asignacionService.cancelar(id, motivo);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Asignaci\u00f3n cancelada exitosamente");
            response.put("data", asignacionCancelada);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al cancelar asignaci\u00f3n: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al cancelar asignaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Eliminar asignaci\u00f3n", description="Elimina una asignaci\u00f3n del sistema")
    public ResponseEntity<Map<String, Object>> eliminarAsignacion(@PathVariable Long id) {
        try {
            this.asignacionService.delete(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Asignaci\u00f3n eliminada exitosamente");
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al eliminar asignaci\u00f3n: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al eliminar asignaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/disponibilidad"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Verificar disponibilidad", description="Verifica si un personal est\u00e1 disponible en una fecha espec\u00edfica")
    public ResponseEntity<Map<String, Object>> verificarDisponibilidad(@RequestParam Long personalId, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd") Date fecha) {
        try {
            boolean disponible = this.asignacionService.verificarDisponibilidadPersonal(personalId, fecha);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Disponibilidad verificada exitosamente");
            response.put("data", Map.of("personalId", personalId, "fecha", fecha, "disponible", disponible));
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al verificar disponibilidad", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    public AsignacionPersonalController(AsignacionPersonalService asignacionService) {
        this.asignacionService = asignacionService;
    }
}

