/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.CajaAperturaRequest;
import com.sistema.turistico.dto.CajaCierreRequest;
import com.sistema.turistico.dto.MovimientoCajaRequest;
import com.sistema.turistico.entity.Caja;
import com.sistema.turistico.entity.MovimientoCaja;
import com.sistema.turistico.service.CajaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cajas"})
@Tag(name="Caja", description="Gesti\u00f3n de cajas y movimientos")
public class CajaController {
    private static final Logger log = LoggerFactory.getLogger(CajaController.class);
    private final CajaService cajaService;

    @PostMapping
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Abrir caja", description="Crea una nueva apertura de caja")
    public ResponseEntity<Map<String, Object>> abrirCaja(@Valid @RequestBody CajaAperturaRequest request) {
        try {
            Caja caja = this.cajaService.abrirCaja(request);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Caja aperturada correctamente");
            response.put("data", this.buildCajaData(caja));
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn("Error al aperturar caja: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al aperturar caja", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Listar cajas", description="Obtiene todas las cajas con filtros opcionales")
    public ResponseEntity<Map<String, Object>> listarCajas(@RequestParam(required=false) Long empresaId, @RequestParam(required=false) Long sucursalId, @RequestParam(required=false) Caja.EstadoCaja estado) {
        try {
            List cajas = this.cajaService.listarCajas(empresaId, sucursalId, estado);
            List<Map> cajasData = cajas.stream().map(arg_0 -> this.buildCajaData(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Cajas obtenidas correctamente");
            response.put("data", cajasData);
            response.put("total", cajas.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar cajas", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/abiertas"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Listar cajas abiertas", description="Obtiene las cajas abiertas por empresa")
    public ResponseEntity<Map<String, Object>> listarCajasAbiertas(@RequestParam(required=false) Long empresaId) {
        try {
            List cajas = this.cajaService.listarCajasAbiertas(empresaId);
            List<Map> cajasData = cajas.stream().map(arg_0 -> this.buildCajaData(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Cajas abiertas obtenidas correctamente");
            response.put("data", cajasData);
            response.put("total", cajas.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar cajas abiertas", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Detalle de caja", description="Obtiene la informaci\u00f3n de una caja espec\u00edfica")
    public ResponseEntity<Map<String, Object>> obtenerCaja(@PathVariable Long id) {
        try {
            Caja caja = this.cajaService.obtenerCaja(id);
            Map cajaData = this.buildCajaData(caja);
            cajaData.put("idUsuarioCierre", caja.getUsuarioCierre() != null ? caja.getUsuarioCierre().getIdUsuario() : null);
            cajaData.put("montoCierre", caja.getMontoCierre());
            cajaData.put("diferencia", caja.getDiferencia());
            cajaData.put("createdAt", caja.getCreatedAt());
            cajaData.put("updatedAt", caja.getUpdatedAt());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Caja obtenida correctamente");
            response.put("data", cajaData);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Caja no encontrada: {}", (Object)ex.getMessage());
            return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener caja", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/{id}/cerrar"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Cerrar caja", description="Registra el cierre de una caja abierta")
    public ResponseEntity<Map<String, Object>> cerrarCaja(@PathVariable Long id, @Valid @RequestBody CajaCierreRequest request) {
        try {
            Caja caja = this.cajaService.cerrarCaja(id, request);
            Map cajaData = this.buildCajaData(caja);
            cajaData.put("idUsuarioCierre", caja.getUsuarioCierre() != null ? caja.getUsuarioCierre().getIdUsuario() : null);
            cajaData.put("montoCierre", caja.getMontoCierre());
            cajaData.put("diferencia", caja.getDiferencia());
            cajaData.put("createdAt", caja.getCreatedAt());
            cajaData.put("updatedAt", caja.getUpdatedAt());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Caja cerrada correctamente");
            response.put("data", cajaData);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn("Error al cerrar caja: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al cerrar caja", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PostMapping(value={"/{id}/movimientos"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Registrar movimiento", description="Agrega un movimiento manual a la caja")
    public ResponseEntity<Map<String, Object>> registrarMovimiento(@PathVariable Long id, @Valid @RequestBody MovimientoCajaRequest request) {
        try {
            MovimientoCaja movimiento = this.cajaService.registrarMovimiento(id, request);
            Map movimientoData = this.buildMovimientoData(movimiento);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Movimiento registrado correctamente");
            response.put("data", movimientoData);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn("Error al registrar movimiento: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al registrar movimiento", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/{id}/movimientos"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Listar movimientos", description="Lista los movimientos de una caja con filtros opcionales")
    public ResponseEntity<Map<String, Object>> listarMovimientos(@PathVariable Long id, @RequestParam(required=false) MovimientoCaja.TipoMovimiento tipo, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime fechaInicio, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime fechaFin) {
        try {
            List movimientos = this.cajaService.obtenerMovimientos(id, fechaInicio, fechaFin, tipo);
            List<Map> movimientosData = movimientos.stream().map(arg_0 -> this.buildMovimientoData(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Movimientos obtenidos correctamente");
            response.put("data", movimientosData);
            response.put("total", movimientos.size());
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al listar movimientos: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al listar movimientos", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/{id}/movimientos/{movimientoId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Detalle de movimiento", description="Obtiene la informaci\u00f3n de un movimiento espec\u00edfico de caja")
    public ResponseEntity<Map<String, Object>> obtenerMovimiento(@PathVariable Long id, @PathVariable Long movimientoId) {
        try {
            MovimientoCaja movimiento = this.cajaService.obtenerMovimiento(id, movimientoId);
            Map movimientoData = this.buildMovimientoData(movimiento);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Movimiento obtenido correctamente");
            response.put("data", movimientoData);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Movimiento no encontrado: {}", (Object)ex.getMessage());
            return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener movimiento", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @DeleteMapping(value={"/{id}/movimientos/{movimientoId}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Anular movimiento", description="Anula un movimiento de caja (solo movimientos manuales)")
    public ResponseEntity<Map<String, Object>> anularMovimiento(@PathVariable Long id, @PathVariable Long movimientoId, @RequestParam String motivo) {
        try {
            MovimientoCaja movimientoReverso = this.cajaService.anularMovimiento(id, movimientoId, motivo);
            Map movimientoData = this.buildMovimientoData(movimientoReverso);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Movimiento anulado correctamente");
            response.put("data", movimientoData);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn("Error al anular movimiento: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al anular movimiento", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/{id}/arqueo"})
    private Map<String, Object> buildCajaData(Caja caja) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("idCaja", caja.getIdCaja());
        data.put("idEmpresa", caja.getEmpresa() != null ? caja.getEmpresa().getIdEmpresa() : null);
        data.put("idSucursal", caja.getSucursal() != null ? caja.getSucursal().getIdSucursal() : null);
        data.put("idUsuarioApertura", caja.getUsuarioApertura() != null ? caja.getUsuarioApertura().getIdUsuario() : null);
        data.put("fechaApertura", caja.getFechaApertura());
        data.put("horaApertura", caja.getHoraApertura());
        data.put("montoInicial", caja.getMontoInicial());
        data.put("saldoActual", caja.getSaldoActual());
        data.put("estado", caja.getEstado());
        data.put("observaciones", caja.getObservaciones());
        return data;
    }

    private Map<String, Object> buildMovimientoData(MovimientoCaja movimiento) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("idMovimiento", movimiento.getIdMovimiento());
        data.put("idCaja", movimiento.getCaja() != null ? movimiento.getCaja().getIdCaja() : null);
        data.put("tipoMovimiento", movimiento.getTipoMovimiento());
        data.put("monto", movimiento.getMonto());
        data.put("descripcion", movimiento.getDescripcion());
        data.put("fechaHora", movimiento.getFechaHora());
        data.put("createdAt", movimiento.getCreatedAt());
        return data;
    }

    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Arqueo de caja", description="Obtiene el resumen de ingresos y egresos de una caja")
    public ResponseEntity<Map<String, Object>> obtenerArqueo(@PathVariable Long id, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaInicio, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaFin) {
        try {
            Map resumen = this.cajaService.obtenerArqueo(id, fechaInicio, fechaFin);
            resumen.put("success", true);
            resumen.put("message", "Arqueo generado correctamente");
            return ResponseEntity.ok((Object)resumen);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al generar arqueo: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al generar arqueo", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    public CajaController(CajaService cajaService) {
        this.cajaService = cajaService;
    }
}

