/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.ClienteResponse;
import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.service.ClienteService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/clientes"})
@Tag(name="Clientes", description="Endpoints para gesti\u00f3n de clientes")
public class ClienteController {
    private static final Logger log = LoggerFactory.getLogger(ClienteController.class);
    private final ClienteService clienteService;

    @PostMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Crear cliente", description="Crea un nuevo cliente en el sistema")
    public ResponseEntity<Map<String, Object>> crearCliente(@Valid @RequestBody Cliente cliente) {
        try {
            log.info("Creando cliente: {} {}", (Object)cliente.getNombre(), (Object)cliente.getApellido());
            Cliente nuevoCliente = this.clienteService.create(cliente);
            ClienteResponse clienteResponse = this.clienteService.toResponse(nuevoCliente);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Cliente creado exitosamente");
            response.put("data", clienteResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error de validaci\u00f3n al crear cliente: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error interno al crear cliente", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Listar clientes", description="Obtiene la lista de clientes con filtros opcionales")
    public ResponseEntity<Map<String, Object>> listarClientes(@RequestParam(value="empresaId", required=false) Long empresaId, @RequestParam(value="busqueda", required=false) String busqueda, @RequestParam(value="page", required=false, defaultValue="1") int page, @RequestParam(value="size", required=false, defaultValue="10") int size) {
        try {
            log.info("Listando clientes de empresa {} con b\u00fasqueda: {} - p\u00e1gina: {}, tama\u00f1o: {}", new Object[]{empresaId, busqueda, page, size});
            List clientes = this.clienteService.findByEmpresaIdAndBusqueda(empresaId, busqueda);
            if (page < 1) {
                page = 1;
            }
            if (size < 1) {
                size = 10;
            }
            int startIndex = Math.min((page - 1) * size, clientes.size());
            int endIndex = Math.min(startIndex + size, clientes.size());
            List clientesPaginados = clientes.isEmpty() ? Collections.emptyList() : clientes.subList(startIndex, endIndex);
            List<ClienteResponse> clientesResponse = clientesPaginados.stream().map(arg_0 -> ((ClienteService)this.clienteService).toResponse(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Clientes obtenidos exitosamente");
            response.put("data", clientesResponse);
            response.put("total", clientes.size());
            response.put("page", page);
            response.put("size", size);
            response.put("totalPages", (int)Math.ceil((double)clientes.size() / (double)size));
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            log.error("Error al listar clientes", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Obtener cliente por ID", description="Obtiene un cliente espec\u00edfico por su ID")
    public ResponseEntity<Map<String, Object>> obtenerCliente(@PathVariable Long id) {
        try {
            log.info("Obteniendo cliente con ID: {}", (Object)id);
            Cliente cliente = (Cliente)this.clienteService.findById(id).orElseThrow(() -> new IllegalArgumentException("Cliente no encontrado"));
            ClienteResponse clienteResponse = this.clienteService.toResponse(cliente);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Cliente obtenido exitosamente");
            response.put("data", clienteResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Cliente no encontrado: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.status((int)404).body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al obtener cliente con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Actualizar cliente", description="Actualiza los datos de un cliente existente")
    public ResponseEntity<Map<String, Object>> actualizarCliente(@PathVariable Long id, @Valid @RequestBody Cliente cliente) {
        try {
            log.info("Actualizando cliente ID: {}", (Object)id);
            Cliente clienteActualizado = this.clienteService.update(id, cliente);
            ClienteResponse clienteResponse = this.clienteService.toResponse(clienteActualizado);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Cliente actualizado exitosamente");
            response.put("data", clienteResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error de validaci\u00f3n al actualizar cliente: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al actualizar cliente con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Eliminar cliente", description="Elimina un cliente del sistema (soft delete)")
    public ResponseEntity<Map<String, Object>> eliminarCliente(@PathVariable Long id) {
        try {
            log.info("Eliminando cliente ID: {}", (Object)id);
            this.clienteService.delete(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Cliente eliminado exitosamente");
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error al eliminar cliente: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al eliminar cliente con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    public ClienteController(ClienteService clienteService) {
        this.clienteService = clienteService;
    }
}

