/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.ReservaAsignacionSyncRequest;
import com.sistema.turistico.dto.ReservaEditRequest;
import com.sistema.turistico.dto.ReservaRequest;
import com.sistema.turistico.dto.ReservaResponse;
import com.sistema.turistico.dto.ReservaUpdateRequest;
import com.sistema.turistico.dto.VoucherResponse;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.Voucher;
import com.sistema.turistico.repository.VoucherRepository;
import com.sistema.turistico.security.TenantContext;
import com.sistema.turistico.service.ReservaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reservas"})
@Tag(name="Reservas", description="Endpoints para gesti\u00f3n de reservas")
public class ReservaController {
    private static final Logger log = LoggerFactory.getLogger(ReservaController.class);
    private final ReservaService reservaService;
    private final VoucherRepository voucherRepository;

    @PostMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Crear reserva", description="Crea una nueva reserva en el sistema")
    public ResponseEntity<Map<String, Object>> crearReserva(@Valid @RequestBody ReservaRequest request) {
        try {
            log.info("Creando nueva reserva para cliente ID: {}", (Object)request.getClienteId());
            Reserva nuevaReserva = this.reservaService.create(request);
            ReservaResponse reservaResponse = this.reservaService.toResponse(nuevaReserva);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reserva creada exitosamente");
            response.put("data", reservaResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.warn("Error de validaci\u00f3n al crear reserva: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error interno al crear reserva", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Listar reservas", description="Obtiene la lista de reservas con filtros opcionales")
    public ResponseEntity<Map<String, Object>> listarReservas(@RequestParam(name="busqueda", required=false) String busqueda, @RequestParam(name="estado", required=false) Reserva.EstadoReserva estado, @RequestParam(name="page", required=false, defaultValue="1") int page, @RequestParam(name="size", required=false, defaultValue="10") int size, @RequestParam(name="empresaId", required=false) Long empresaId) {
        try {
            Long empresaLog = empresaId != null ? empresaId : (Long)TenantContext.getEmpresaId().orElse(null);
            int pageNumber = Math.max(page, 1);
            int pageSize = size > 0 ? size : 10;
            log.info("Listando reservas de empresa {} con filtros - p\u00e1gina: {}, tama\u00f1o: {}", new Object[]{empresaLog, pageNumber, pageSize});
            List reservas = estado != null ? this.reservaService.findByEmpresaIdAndEstado(empresaId, estado) : this.reservaService.findByEmpresaIdAndBusqueda(empresaId, busqueda);
            int startIndex = (pageNumber - 1) * pageSize;
            if (startIndex >= reservas.size()) {
                startIndex = reservas.size();
            }
            int endIndex = Math.min(startIndex + pageSize, reservas.size());
            List reservasPaginadas = reservas.subList(startIndex, endIndex);
            List<ReservaResponse> reservasResponse = reservasPaginadas.stream().map(arg_0 -> ((ReservaService)this.reservaService).toResponse(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reservas obtenidas exitosamente");
            response.put("data", reservasResponse);
            response.put("total", reservas.size());
            response.put("page", pageNumber);
            response.put("size", pageSize);
            response.put("totalPages", pageSize > 0 ? (int)Math.ceil((double)reservas.size() / (double)pageSize) : 1);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.warn("Error de validaci\u00f3n al listar reservas: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al listar reservas", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Obtener reserva por ID", description="Obtiene una reserva espec\u00edfica por su ID")
    public ResponseEntity<Map<String, Object>> obtenerReserva(@PathVariable Long id) {
        try {
            log.info("Obteniendo reserva con ID: {}", (Object)id);
            ReservaResponse reservaResponse = (ReservaResponse)this.reservaService.findByIdAndConvert(id).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reserva obtenida exitosamente");
            response.put("data", reservaResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.warn("Reserva no encontrada: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            log.error("Error al obtener reserva con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Actualizar reserva", description="Actualiza los datos de una reserva existente")
    public ResponseEntity<Map<String, Object>> actualizarReserva(@PathVariable Long id, @RequestBody ReservaUpdateRequest request) {
        try {
            log.info("Actualizando reserva ID: {}", (Object)id);
            Reserva reservaActualizada = this.reservaService.update(id, request);
            ReservaResponse reservaResponse = this.reservaService.toResponse(reservaActualizada);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reserva actualizada exitosamente");
            response.put("data", reservaResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.warn("Error de validaci\u00f3n al actualizar reserva: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al actualizar reserva con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @PutMapping(value={"/{id}/detalle"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Actualizar detalle de reserva", description="Actualiza fecha de servicio, observaciones, descuento, n\u00famero de personas e items de una reserva pendiente")
    public ResponseEntity<Map<String, Object>> actualizarDetalleReserva(@PathVariable Long id, @Valid @RequestBody ReservaEditRequest request) {
        try {
            log.info("Actualizando detalle completo de reserva ID: {}", (Object)id);
            Reserva reservaActual = (Reserva)this.reservaService.findById(id).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
            if (reservaActual.getEstado() != Reserva.EstadoReserva.Pendiente) {
                HashMap<String, Object> conflictResponse = new HashMap<String, Object>();
                conflictResponse.put("success", false);
                conflictResponse.put("message", "Solo se pueden editar reservas en estado Pendiente");
                return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(conflictResponse);
            }
            Reserva reservaActualizada = this.reservaService.updateDetalle(id, request);
            ReservaResponse reservaResponse = this.reservaService.toResponse(reservaActualizada);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reserva actualizada exitosamente");
            response.put("data", reservaResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error de validaci\u00f3n al actualizar detalle de reserva: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (IllegalStateException e) {
            log.warn("Conflicto al actualizar detalle de reserva: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al actualizar detalle de reserva con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping(value={"/{id}/asignaciones"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Listado de personal asignado", description="Obtiene el personal asociado a la reserva")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Asignaciones obtenidas exitosamente", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="400", description="Error de validaci\u00f3n", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="500", description="Error interno del servidor", content={@Content(mediaType="application/json")})})
    public ResponseEntity<Map<String, Object>> obtenerAsignacionesReserva(@PathVariable Long id) {
        try {
            List asignaciones = this.reservaService.obtenerAsignaciones(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Asignaciones obtenidas exitosamente");
            response.put("data", asignaciones);
            response.put("total", asignaciones.size());
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.warn("Error al obtener asignaciones para reserva {}: {}", (Object)id, (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error interno al obtener asignaciones de la reserva {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @PutMapping(value={"/{id}/asignaciones"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Sincronizar personal asignado", description="Reemplaza el personal asociado a la reserva. Solo v\u00e1lido para reservas en estado Pendiente o Pagada")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Asignaciones actualizadas exitosamente", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="400", description="Error de validaci\u00f3n", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="500", description="Error interno del servidor", content={@Content(mediaType="application/json")})})
    public ResponseEntity<Map<String, Object>> sincronizarAsignaciones(@PathVariable Long id, @Valid @RequestBody ReservaAsignacionSyncRequest request) {
        try {
            Reserva reservaActualizada = this.reservaService.actualizarAsignaciones(id, request);
            ReservaResponse reservaResponse = this.reservaService.toResponse(reservaActualizada);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Asignaciones actualizadas exitosamente");
            response.put("data", reservaResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.warn("Error al sincronizar asignaciones de la reserva {}: {}", (Object)id, (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error interno al sincronizar asignaciones de la reserva {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Eliminar reserva", description="Elimina una reserva del sistema (soft delete)")
    public ResponseEntity<Map<String, Object>> eliminarReserva(@PathVariable Long id) {
        try {
            log.info("Eliminando reserva ID: {}", (Object)id);
            this.reservaService.delete(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reserva eliminada exitosamente");
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.warn("Error al eliminar reserva: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al eliminar reserva con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @PutMapping(value={"/{id}/cancelar"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Cancelar reserva", description="Cancela una reserva activa")
    public ResponseEntity<Map<String, Object>> cancelarReserva(@PathVariable Long id) {
        try {
            log.info("Cancelando reserva ID: {}", (Object)id);
            Reserva reservaCancelada = this.reservaService.cancel(id);
            ReservaResponse reservaResponse = this.reservaService.toResponse(reservaCancelada);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reserva cancelada exitosamente");
            response.put("data", reservaResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.warn("Error al cancelar reserva: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al cancelar reserva con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @PutMapping(value={"/{id}/completar"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Completar reserva", description="Marca una reserva como completada despu\u00e9s de finalizar el servicio")
    public ResponseEntity<Map<String, Object>> completarReserva(@PathVariable Long id) {
        try {
            log.info("Completando reserva ID {}", (Object)id);
            Reserva reservaCompletada = this.reservaService.completar(id);
            ReservaResponse reservaResponse = this.reservaService.toResponse(reservaCompletada);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reserva completada exitosamente");
            response.put("data", reservaResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.warn("Error al completar reserva: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al completar reserva con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @PutMapping(value={"/{id}/evaluar"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Marcar reserva como evaluada", description="Marca una reserva completada como evaluada")
    public ResponseEntity<Map<String, Object>> marcarComoEvaluada(@PathVariable Long id) {
        try {
            log.info("Marcando reserva ID {} como evaluada", (Object)id);
            Reserva reservaEvaluada = this.reservaService.marcarComoEvaluada(id);
            ReservaResponse reservaResponse = this.reservaService.toResponse(reservaEvaluada);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reserva marcada como evaluada exitosamente");
            response.put("data", reservaResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.warn("Error al marcar reserva como evaluada: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al marcar reserva como evaluada con ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping(value={"/proximas"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Reservas pr\u00f3ximas", description="Obtiene las reservas pr\u00f3ximas (pr\u00f3ximos 7 d\u00edas)")
    public ResponseEntity<Map<String, Object>> obtenerReservasProximas(@RequestParam(required=false) Long empresaId) {
        try {
            Long empresaLog = empresaId != null ? empresaId : (Long)TenantContext.getEmpresaId().orElse(null);
            log.info("Obteniendo reservas pr\u00f3ximas para empresa {}", (Object)empresaLog);
            List reservas = this.reservaService.findReservasProximas(empresaId);
            List<ReservaResponse> reservasResponse = reservas.stream().map(arg_0 -> ((ReservaService)this.reservaService).toResponse(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Reservas pr\u00f3ximas obtenidas exitosamente");
            response.put("data", reservasResponse);
            response.put("total", reservasResponse.size());
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.warn("Error al obtener reservas pr\u00f3ximas: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al obtener reservas pr\u00f3ximas", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping(value={"/{id}/voucher"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Obtener voucher de reserva", description="Obtiene el voucher asociado a una reserva espec\u00edfica")
    public ResponseEntity<Map<String, Object>> obtenerVoucherReserva(@PathVariable Long id) {
        try {
            log.info("Obteniendo voucher para reserva ID: {}", (Object)id);
            Reserva reserva = (Reserva)this.reservaService.findById(id).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
            Voucher voucher = (Voucher)this.voucherRepository.findByReserva_IdReserva(id).orElseThrow(() -> new IllegalArgumentException("Voucher no encontrado para esta reserva"));
            VoucherResponse voucherResponse = this.reservaService.toVoucherResponse(voucher);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Voucher obtenido exitosamente");
            response.put("data", voucherResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            log.warn("Error al obtener voucher: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            log.error("Error al obtener voucher para reserva ID: {}", (Object)id, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    public ReservaController(ReservaService reservaService, VoucherRepository voucherRepository) {
        this.reservaService = reservaService;
        this.voucherRepository = voucherRepository;
    }
}

