/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.VentaAnulacionRequest;
import com.sistema.turistico.dto.VentaRequest;
import com.sistema.turistico.dto.VentaResponse;
import com.sistema.turistico.service.VentaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ventas"})
@Tag(name="Ventas", description="Emisi\u00f3n y gesti\u00f3n de ventas")
public class VentaController {
    private static final Logger log = LoggerFactory.getLogger(VentaController.class);
    private final VentaService ventaService;

    @PostMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Emitir venta", description="Genera una venta asociada a una reserva pagada")
    public ResponseEntity<Map<String, Object>> emitirVenta(@Valid @RequestBody VentaRequest request) {
        try {
            VentaResponse venta = this.ventaService.emitirVenta(request);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Venta emitida correctamente");
            response.put("data", venta);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn("Error al emitir venta: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al emitir venta", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Listar ventas", description="Lista las ventas con filtros opcionales")
    public ResponseEntity<Map<String, Object>> listarVentas(@RequestParam(value="empresaId", required=false) Long empresaId, @RequestParam(value="fechaDesde", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaDesde, @RequestParam(value="fechaHasta", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaHasta, @RequestParam(value="metodoPago", required=false) String metodoPago, @RequestParam(value="estado", required=false) Boolean estado) {
        try {
            LocalDateTime fin;
            LocalDateTime inicio = fechaDesde != null ? fechaDesde.atStartOfDay() : null;
            LocalDateTime localDateTime = fin = fechaHasta != null ? fechaHasta.atTime(LocalTime.MAX) : null;
            if (inicio != null && fin != null && fin.isBefore(inicio)) {
                throw new IllegalArgumentException("El rango de fechas es inv\u00e1lido");
            }
            List ventas = this.ventaService.listarVentas(empresaId, inicio, fin, metodoPago, estado);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Ventas obtenidas correctamente");
            response.put("data", ventas);
            response.put("total", ventas.size());
            HashMap<String, Object> filtros = new HashMap<String, Object>();
            filtros.put("empresaId", empresaId);
            filtros.put("fechaDesde", fechaDesde);
            filtros.put("fechaHasta", fechaHasta);
            filtros.put("metodoPago", metodoPago);
            filtros.put("estado", estado);
            response.put("filtros", filtros);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn("Error al listar ventas: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al listar ventas", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Detalle de venta", description="Obtiene la informaci\u00f3n de una venta espec\u00edfica")
    public ResponseEntity<Map<String, Object>> obtenerVenta(@PathVariable Long id) {
        try {
            VentaResponse venta = this.ventaService.obtenerVenta(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Venta obtenida correctamente");
            response.put("data", venta);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Venta no encontrada: {}", (Object)ex.getMessage());
            return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener venta", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Actualizar venta", description="Actualiza informaci\u00f3n de una venta (solo campos permitidos)")
    public ResponseEntity<Map<String, Object>> actualizarVenta(@PathVariable Long id, @Valid @RequestBody VentaRequest request) {
        try {
            VentaResponse venta = this.ventaService.actualizarVenta(id, request);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Venta actualizada correctamente");
            response.put("data", venta);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn("Error al actualizar venta: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al actualizar venta", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Eliminar venta", description="Elimina una venta (solo ventas del d\u00eda actual)")
    public ResponseEntity<Map<String, Object>> eliminarVenta(@PathVariable Long id, @RequestParam(value="cajaId") Long cajaId, @RequestParam(value="motivo", required=false) String motivo) {
        try {
            this.ventaService.eliminarVenta(id, cajaId, motivo);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Venta eliminada correctamente");
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn("Error al eliminar venta: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al eliminar venta", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PostMapping(value={"/{id}/anular"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Anular venta", description="Anula una venta y genera el movimiento de reverso")
    public ResponseEntity<Map<String, Object>> anularVenta(@PathVariable Long id, @Valid @RequestBody VentaAnulacionRequest request) {
        try {
            VentaResponse venta = this.ventaService.anularVenta(id, request);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Venta anulada correctamente");
            response.put("data", venta);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn("Error al anular venta: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al anular venta", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/siguiente-numero"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Obtener siguiente numeraci\u00f3n", description="Sugiere la siguiente numeraci\u00f3n para ventas del d\u00eda")
    public ResponseEntity<Map<String, Object>> obtenerSiguienteNumero(@RequestParam(value="empresaId", required=false) Long empresaId) {
        try {
            Map numeracion = this.ventaService.obtenerProximaNumeracion(empresaId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Numeraci\u00f3n obtenida correctamente");
            response.put("data", numeracion);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn("Error al obtener siguiente numeraci\u00f3n: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener siguiente numeraci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    public VentaController(VentaService ventaService) {
        this.ventaService = ventaService;
    }
}

