/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.dto;

import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;

public class EmpresaRequest {
    @NotBlank(message="El nombre de la empresa es obligatorio")
    @Size(max=255, message="El nombre de la empresa no puede exceder 255 caracteres")
    private @NotBlank(message="El nombre de la empresa es obligatorio") @Size(max=255, message="El nombre de la empresa no puede exceder 255 caracteres") String nombreEmpresa;
    @NotBlank(message="El RUC es obligatorio")
    @Size(max=20, message="El RUC no puede exceder 20 caracteres")
    @Pattern(regexp="^\\d{11}$", message="El RUC debe contener 11 d\u00edgitos")
    private @NotBlank(message="El RUC es obligatorio") @Size(max=20, message="El RUC no puede exceder 20 caracteres") @Pattern(regexp="^\\d{11}$", message="El RUC debe contener 11 d\u00edgitos") String ruc;
    @NotBlank(message="El email es obligatorio")
    @Email(message="El email debe tener un formato v\u00e1lido")
    @Size(max=255, message="El email no puede exceder 255 caracteres")
    private @NotBlank(message="El email es obligatorio") @Email(message="El email debe tener un formato v\u00e1lido") @Size(max=255, message="El email no puede exceder 255 caracteres") String email;
    @Size(max=20, message="El tel\u00e9fono no puede exceder 20 caracteres")
    private @Size(max=20, message="El tel\u00e9fono no puede exceder 20 caracteres") String telefono;
    private String direccion;
    private Integer estado;

    public String getNombreEmpresa() {
        return this.nombreEmpresa;
    }

    public String getRuc() {
        return this.ruc;
    }

    public String getEmail() {
        return this.email;
    }

    public String getTelefono() {
        return this.telefono;
    }

    public String getDireccion() {
        return this.direccion;
    }

    public Integer getEstado() {
        return this.estado;
    }

    public void setNombreEmpresa(String nombreEmpresa) {
        this.nombreEmpresa = nombreEmpresa;
    }

    public void setRuc(String ruc) {
        this.ruc = ruc;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    public void setDireccion(String direccion) {
        this.direccion = direccion;
    }

    public void setEstado(Integer estado) {
        this.estado = estado;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmpresaRequest)) {
            return false;
        }
        EmpresaRequest other = (EmpresaRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$estado = this.getEstado();
        Integer other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        String this$nombreEmpresa = this.getNombreEmpresa();
        String other$nombreEmpresa = other.getNombreEmpresa();
        if (this$nombreEmpresa == null ? other$nombreEmpresa != null : !this$nombreEmpresa.equals(other$nombreEmpresa)) {
            return false;
        }
        String this$ruc = this.getRuc();
        String other$ruc = other.getRuc();
        if (this$ruc == null ? other$ruc != null : !this$ruc.equals(other$ruc)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$telefono = this.getTelefono();
        String other$telefono = other.getTelefono();
        if (this$telefono == null ? other$telefono != null : !this$telefono.equals(other$telefono)) {
            return false;
        }
        String this$direccion = this.getDireccion();
        String other$direccion = other.getDireccion();
        return !(this$direccion == null ? other$direccion != null : !this$direccion.equals(other$direccion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmpresaRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        String $nombreEmpresa = this.getNombreEmpresa();
        result = result * 59 + ($nombreEmpresa == null ? 43 : $nombreEmpresa.hashCode());
        String $ruc = this.getRuc();
        result = result * 59 + ($ruc == null ? 43 : $ruc.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $telefono = this.getTelefono();
        result = result * 59 + ($telefono == null ? 43 : $telefono.hashCode());
        String $direccion = this.getDireccion();
        result = result * 59 + ($direccion == null ? 43 : $direccion.hashCode());
        return result;
    }

    public String toString() {
        return "EmpresaRequest(nombreEmpresa=" + this.getNombreEmpresa() + ", ruc=" + this.getRuc() + ", email=" + this.getEmail() + ", telefono=" + this.getTelefono() + ", direccion=" + this.getDireccion() + ", estado=" + this.getEstado() + ")";
    }
}

