/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.dto;

import com.sistema.turistico.dto.ReservaAsignacionPayload;
import com.sistema.turistico.dto.ReservaItemRequest;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.List;

public class ReservaEditRequest {
    private Long empresaId;
    @NotBlank(message="La fecha de servicio es obligatoria")
    private @NotBlank(message="La fecha de servicio es obligatoria") String fechaServicio;
    private Integer numeroPersonas;
    @DecimalMin(value="0.00", message="El descuento aplicado no puede ser negativo")
    @Digits(integer=10, fraction=2, message="El descuento debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales")
    private @DecimalMin(value="0.00", message="El descuento aplicado no puede ser negativo") @Digits(integer=10, fraction=2, message="El descuento debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales") BigDecimal descuentoAplicado;
    private String observaciones;
    @Valid
    @NotNull(message="Debe especificar los items de la reserva")
    @Size(min=1, message="Debe registrar al menos un item")
    private @Valid @NotNull(message="Debe especificar los items de la reserva") @Size(min=1, message="Debe registrar al menos un item") List<ReservaItemRequest> items;
    @Valid
    @Size(max=50, message="No se pueden registrar m\u00e1s de 50 asignaciones")
    private @Valid @Size(max=50, message="No se pueden registrar m\u00e1s de 50 asignaciones") List<ReservaAsignacionPayload> asignaciones;
    private Boolean sincronizarAsignaciones;

    public Long getEmpresaId() {
        return this.empresaId;
    }

    public String getFechaServicio() {
        return this.fechaServicio;
    }

    public Integer getNumeroPersonas() {
        return this.numeroPersonas;
    }

    public BigDecimal getDescuentoAplicado() {
        return this.descuentoAplicado;
    }

    public String getObservaciones() {
        return this.observaciones;
    }

    public List<ReservaItemRequest> getItems() {
        return this.items;
    }

    public List<ReservaAsignacionPayload> getAsignaciones() {
        return this.asignaciones;
    }

    public Boolean getSincronizarAsignaciones() {
        return this.sincronizarAsignaciones;
    }

    public void setEmpresaId(Long empresaId) {
        this.empresaId = empresaId;
    }

    public void setFechaServicio(String fechaServicio) {
        this.fechaServicio = fechaServicio;
    }

    public void setNumeroPersonas(Integer numeroPersonas) {
        this.numeroPersonas = numeroPersonas;
    }

    public void setDescuentoAplicado(BigDecimal descuentoAplicado) {
        this.descuentoAplicado = descuentoAplicado;
    }

    public void setObservaciones(String observaciones) {
        this.observaciones = observaciones;
    }

    public void setItems(List<ReservaItemRequest> items) {
        this.items = items;
    }

    public void setAsignaciones(List<ReservaAsignacionPayload> asignaciones) {
        this.asignaciones = asignaciones;
    }

    public void setSincronizarAsignaciones(Boolean sincronizarAsignaciones) {
        this.sincronizarAsignaciones = sincronizarAsignaciones;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReservaEditRequest)) {
            return false;
        }
        ReservaEditRequest other = (ReservaEditRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$empresaId = this.getEmpresaId();
        Long other$empresaId = other.getEmpresaId();
        if (this$empresaId == null ? other$empresaId != null : !((Object)this$empresaId).equals(other$empresaId)) {
            return false;
        }
        Integer this$numeroPersonas = this.getNumeroPersonas();
        Integer other$numeroPersonas = other.getNumeroPersonas();
        if (this$numeroPersonas == null ? other$numeroPersonas != null : !((Object)this$numeroPersonas).equals(other$numeroPersonas)) {
            return false;
        }
        Boolean this$sincronizarAsignaciones = this.getSincronizarAsignaciones();
        Boolean other$sincronizarAsignaciones = other.getSincronizarAsignaciones();
        if (this$sincronizarAsignaciones == null ? other$sincronizarAsignaciones != null : !((Object)this$sincronizarAsignaciones).equals(other$sincronizarAsignaciones)) {
            return false;
        }
        String this$fechaServicio = this.getFechaServicio();
        String other$fechaServicio = other.getFechaServicio();
        if (this$fechaServicio == null ? other$fechaServicio != null : !this$fechaServicio.equals(other$fechaServicio)) {
            return false;
        }
        BigDecimal this$descuentoAplicado = this.getDescuentoAplicado();
        BigDecimal other$descuentoAplicado = other.getDescuentoAplicado();
        if (this$descuentoAplicado == null ? other$descuentoAplicado != null : !((Object)this$descuentoAplicado).equals(other$descuentoAplicado)) {
            return false;
        }
        String this$observaciones = this.getObservaciones();
        String other$observaciones = other.getObservaciones();
        if (this$observaciones == null ? other$observaciones != null : !this$observaciones.equals(other$observaciones)) {
            return false;
        }
        List this$items = this.getItems();
        List other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        List this$asignaciones = this.getAsignaciones();
        List other$asignaciones = other.getAsignaciones();
        return !(this$asignaciones == null ? other$asignaciones != null : !((Object)this$asignaciones).equals(other$asignaciones));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReservaEditRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $empresaId = this.getEmpresaId();
        result = result * 59 + ($empresaId == null ? 43 : ((Object)$empresaId).hashCode());
        Integer $numeroPersonas = this.getNumeroPersonas();
        result = result * 59 + ($numeroPersonas == null ? 43 : ((Object)$numeroPersonas).hashCode());
        Boolean $sincronizarAsignaciones = this.getSincronizarAsignaciones();
        result = result * 59 + ($sincronizarAsignaciones == null ? 43 : ((Object)$sincronizarAsignaciones).hashCode());
        String $fechaServicio = this.getFechaServicio();
        result = result * 59 + ($fechaServicio == null ? 43 : $fechaServicio.hashCode());
        BigDecimal $descuentoAplicado = this.getDescuentoAplicado();
        result = result * 59 + ($descuentoAplicado == null ? 43 : ((Object)$descuentoAplicado).hashCode());
        String $observaciones = this.getObservaciones();
        result = result * 59 + ($observaciones == null ? 43 : $observaciones.hashCode());
        List $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        List $asignaciones = this.getAsignaciones();
        result = result * 59 + ($asignaciones == null ? 43 : ((Object)$asignaciones).hashCode());
        return result;
    }

    public String toString() {
        return "ReservaEditRequest(empresaId=" + this.getEmpresaId() + ", fechaServicio=" + this.getFechaServicio() + ", numeroPersonas=" + this.getNumeroPersonas() + ", descuentoAplicado=" + String.valueOf(this.getDescuentoAplicado()) + ", observaciones=" + this.getObservaciones() + ", items=" + String.valueOf(this.getItems()) + ", asignaciones=" + String.valueOf(this.getAsignaciones()) + ", sincronizarAsignaciones=" + this.getSincronizarAsignaciones() + ")";
    }
}

