/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Caja;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.Sucursal;
import com.sistema.turistico.entity.Usuario;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="cajas")
public class Caja {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_caja")
    private Long idCaja;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa", nullable=false)
    private Empresa empresa;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_sucursal", nullable=false)
    private Sucursal sucursal;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_usuario_apertura", nullable=false)
    private Usuario usuarioApertura;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_usuario_cierre")
    private Usuario usuarioCierre;
    @Column(name="fecha_apertura", nullable=false)
    private LocalDate fechaApertura;
    @Column(name="hora_apertura", nullable=false)
    private LocalTime horaApertura;
    @DecimalMin(value="0.00", message="El monto inicial no puede ser negativo")
    @Digits(integer=10, fraction=2)
    @Column(name="monto_inicial", nullable=false, precision=10, scale=2)
    private @DecimalMin(value="0.00", message="El monto inicial no puede ser negativo") @Digits(integer=10, fraction=2) BigDecimal montoInicial;
    @DecimalMin(value="0.00", message="El saldo actual no puede ser negativo")
    @Digits(integer=10, fraction=2)
    @Column(name="saldo_actual", nullable=false, precision=10, scale=2)
    private @DecimalMin(value="0.00", message="El saldo actual no puede ser negativo") @Digits(integer=10, fraction=2) BigDecimal saldoActual;
    @Digits(integer=10, fraction=2)
    @Column(name="monto_cierre", precision=10, scale=2)
    private @Digits(integer=10, fraction=2) BigDecimal montoCierre;
    @Digits(integer=10, fraction=2)
    @Column(name="diferencia", precision=10, scale=2)
    private @Digits(integer=10, fraction=2) BigDecimal diferencia;
    @Enumerated(value=EnumType.STRING)
    @Column(name="estado", nullable=false)
    private EstadoCaja estado = EstadoCaja.Abierta;
    @Column(name="observaciones", columnDefinition="TEXT")
    private String observaciones;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at")
    private LocalDateTime updatedAt;

    public boolean estaAbierta() {
        return EstadoCaja.Abierta.equals((Object)this.estado);
    }

    public Long getIdCaja() {
        return this.idCaja;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public Sucursal getSucursal() {
        return this.sucursal;
    }

    public Usuario getUsuarioApertura() {
        return this.usuarioApertura;
    }

    public Usuario getUsuarioCierre() {
        return this.usuarioCierre;
    }

    public LocalDate getFechaApertura() {
        return this.fechaApertura;
    }

    public LocalTime getHoraApertura() {
        return this.horaApertura;
    }

    public BigDecimal getMontoInicial() {
        return this.montoInicial;
    }

    public BigDecimal getSaldoActual() {
        return this.saldoActual;
    }

    public BigDecimal getMontoCierre() {
        return this.montoCierre;
    }

    public BigDecimal getDiferencia() {
        return this.diferencia;
    }

    public EstadoCaja getEstado() {
        return this.estado;
    }

    public String getObservaciones() {
        return this.observaciones;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setIdCaja(Long idCaja) {
        this.idCaja = idCaja;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setSucursal(Sucursal sucursal) {
        this.sucursal = sucursal;
    }

    public void setUsuarioApertura(Usuario usuarioApertura) {
        this.usuarioApertura = usuarioApertura;
    }

    public void setUsuarioCierre(Usuario usuarioCierre) {
        this.usuarioCierre = usuarioCierre;
    }

    public void setFechaApertura(LocalDate fechaApertura) {
        this.fechaApertura = fechaApertura;
    }

    public void setHoraApertura(LocalTime horaApertura) {
        this.horaApertura = horaApertura;
    }

    public void setMontoInicial(BigDecimal montoInicial) {
        this.montoInicial = montoInicial;
    }

    public void setSaldoActual(BigDecimal saldoActual) {
        this.saldoActual = saldoActual;
    }

    public void setMontoCierre(BigDecimal montoCierre) {
        this.montoCierre = montoCierre;
    }

    public void setDiferencia(BigDecimal diferencia) {
        this.diferencia = diferencia;
    }

    public void setEstado(EstadoCaja estado) {
        this.estado = estado;
    }

    public void setObservaciones(String observaciones) {
        this.observaciones = observaciones;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String toString() {
        return "Caja(idCaja=" + this.getIdCaja() + ", empresa=" + String.valueOf(this.getEmpresa()) + ", sucursal=" + String.valueOf(this.getSucursal()) + ", usuarioApertura=" + String.valueOf(this.getUsuarioApertura()) + ", usuarioCierre=" + String.valueOf(this.getUsuarioCierre()) + ", fechaApertura=" + String.valueOf(this.getFechaApertura()) + ", horaApertura=" + String.valueOf(this.getHoraApertura()) + ", montoInicial=" + String.valueOf(this.getMontoInicial()) + ", saldoActual=" + String.valueOf(this.getSaldoActual()) + ", montoCierre=" + String.valueOf(this.getMontoCierre()) + ", diferencia=" + String.valueOf(this.getDiferencia()) + ", estado=" + String.valueOf(this.getEstado()) + ", observaciones=" + this.getObservaciones() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Caja)) {
            return false;
        }
        Caja other = (Caja)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idCaja = this.getIdCaja();
        Long other$idCaja = other.getIdCaja();
        return !(this$idCaja == null ? other$idCaja != null : !((Object)this$idCaja).equals(other$idCaja));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Caja;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idCaja = this.getIdCaja();
        result = result * 59 + ($idCaja == null ? 43 : ((Object)$idCaja).hashCode());
        return result;
    }
}

