/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.Sucursal;
import com.sistema.turistico.entity.Usuario;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="pagos_reservas")
public class PagoReserva {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_pago")
    private Long idPago;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_reserva", nullable=false)
    private Reserva reserva;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_sucursal")
    private Sucursal sucursal;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_usuario", nullable=false)
    private Usuario usuario;
    @NotNull
    @DecimalMin(value="0.01", message="El monto debe ser mayor a 0")
    @Digits(integer=10, fraction=2)
    @Column(name="monto_pagado", nullable=false, precision=10, scale=2)
    private @NotNull @DecimalMin(value="0.01", message="El monto debe ser mayor a 0") @Digits(integer=10, fraction=2) BigDecimal montoPagado;
    @Column(name="metodo_pago", nullable=false, length=50)
    private String metodoPago;
    @Column(name="numero_operacion", length=100)
    private String numeroOperacion;
    @Column(name="comprobante", length=100)
    private String comprobante;
    @Column(name="fecha_pago", nullable=false)
    private LocalDate fechaPago;
    @Column(name="observaciones", columnDefinition="TEXT")
    private String observaciones;
    @Column(name="estado", nullable=false)
    private Boolean estado = Boolean.TRUE;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at")
    private LocalDateTime updatedAt;

    public Long getIdPago() {
        return this.idPago;
    }

    public Reserva getReserva() {
        return this.reserva;
    }

    public Sucursal getSucursal() {
        return this.sucursal;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public BigDecimal getMontoPagado() {
        return this.montoPagado;
    }

    public String getMetodoPago() {
        return this.metodoPago;
    }

    public String getNumeroOperacion() {
        return this.numeroOperacion;
    }

    public String getComprobante() {
        return this.comprobante;
    }

    public LocalDate getFechaPago() {
        return this.fechaPago;
    }

    public String getObservaciones() {
        return this.observaciones;
    }

    public Boolean getEstado() {
        return this.estado;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setIdPago(Long idPago) {
        this.idPago = idPago;
    }

    public void setReserva(Reserva reserva) {
        this.reserva = reserva;
    }

    public void setSucursal(Sucursal sucursal) {
        this.sucursal = sucursal;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public void setMontoPagado(BigDecimal montoPagado) {
        this.montoPagado = montoPagado;
    }

    public void setMetodoPago(String metodoPago) {
        this.metodoPago = metodoPago;
    }

    public void setNumeroOperacion(String numeroOperacion) {
        this.numeroOperacion = numeroOperacion;
    }

    public void setComprobante(String comprobante) {
        this.comprobante = comprobante;
    }

    public void setFechaPago(LocalDate fechaPago) {
        this.fechaPago = fechaPago;
    }

    public void setObservaciones(String observaciones) {
        this.observaciones = observaciones;
    }

    public void setEstado(Boolean estado) {
        this.estado = estado;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String toString() {
        return "PagoReserva(idPago=" + this.getIdPago() + ", reserva=" + String.valueOf(this.getReserva()) + ", sucursal=" + String.valueOf(this.getSucursal()) + ", usuario=" + String.valueOf(this.getUsuario()) + ", montoPagado=" + String.valueOf(this.getMontoPagado()) + ", metodoPago=" + this.getMetodoPago() + ", numeroOperacion=" + this.getNumeroOperacion() + ", comprobante=" + this.getComprobante() + ", fechaPago=" + String.valueOf(this.getFechaPago()) + ", observaciones=" + this.getObservaciones() + ", estado=" + this.getEstado() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagoReserva)) {
            return false;
        }
        PagoReserva other = (PagoReserva)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idPago = this.getIdPago();
        Long other$idPago = other.getIdPago();
        return !(this$idPago == null ? other$idPago != null : !((Object)this$idPago).equals(other$idPago));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PagoReserva;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idPago = this.getIdPago();
        result = result * 59 + ($idPago == null ? 43 : ((Object)$idPago).hashCode());
        return result;
    }
}

